/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.ivrFile.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.ivrFile.service.IVRFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/ivrFile"})
@RestController
public class IVRFileController {
    @Autowired
    IVRFileService ivrFileService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createIVRFile(@RequestParam(value="group") String group, @RequestParam(value="description") String description) {
        RequestResponse returnValue = this.ivrFileService.create(group, description);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<RequestResponse> uploadFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="language") String language, @RequestParam(value="filename") String filename) {
        RequestResponse returnValue = this.ivrFileService.uploadFile(file, language, filename);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

