/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.leadMaster.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.leadMaster.service.LeadMasterService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/leadMaster"})
@RestController
public class LeadMasterController {
    private static final Logger logger = LogManager.getLogger(LeadMasterController.class);
    @Autowired
    LeadMasterService leadMasterService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, @PathVariable(value="campaignId") Long campaignId) {
        RequestResponse returnValue = this.leadMasterService.getAllByFilter(searchRequest, campaignId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/{queue}"})
    public ResponseEntity<RequestResponse> getAllLeadMasterByQueue(@PathVariable(value="queue") Long queue) {
        RequestResponse returnValue = this.leadMasterService.getAllLeadMasterByQueue(queue);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllLeadMaster/{campaignId}"})
    public ResponseEntity<RequestResponse> getAllLeadMasterByCampaignId(@PathVariable(value="campaignId") Long campaignId, @RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.leadMasterService.getAllLeadMasterFilterAgainstCampaign(searchRequest, campaignId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/{uuid}"})
    public ResponseEntity<RequestResponse> getCSVFile(@PathVariable(value="uuid") String uuid) {
        RequestResponse returnValue = this.leadMasterService.convertCsvToJsonByUuid(uuid);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

