/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.complaint.complaintDetail.controller;

import com.coraltele.db.telephony.complaint.entity.ComplaintDetail;
import com.coraltele.db.telephony.complaint.entity.view.ComplaintDetailApproval;
import com.coraltele.db.telephony.complaint.entity.view.ComplaintDetailAssignment;
import com.coraltele.db.telephony.complaint.entity.view.ComplaintDetailClosed;
import com.coraltele.db.telephony.complaint.entity.view.ComplaintDetailEngineer;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailApprovalRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailAssignmentRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailClosedRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailEngineerRepository;
import com.coraltele.db.telephony.complaint.repository.ComplaintDetailRepository;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailApprovalSpecification;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailAssignmentSpecification;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailClosedSpecification;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailEngineerSpecification;
import com.coraltele.db.telephony.complaint.specification.ComplaintDetailSpecification;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.complaint.complaintDetail.service.ComplaintDetailPdfService;
import com.coraltele.service.complaint.complaintDetail.service.ComplaintDetailService;
import com.coraltele.service.pbx.t_cdr.model.TCdrModel;
import com.coraltele.service.user.service.UserRoleService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/complaintDetail"})
public class ComplaintDetailController {
    private static final Logger logger = LogManager.getLogger(ComplaintDetailController.class);
    @Autowired
    ComplaintDetailService complaintService;
    @Autowired
    ComplaintDetailRepository complaintDetailRepository;
    @Autowired
    ComplaintDetailPdfService pdfGenerator;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    ComplaintDetailAssignmentRepository assignmentRepository;
    @Autowired
    ComplaintDetailEngineerRepository complaintDetailEngineerRepository;
    @Autowired
    ComplaintDetailClosedRepository closedRepository;
    @Autowired
    ComplaintDetailApprovalRepository complaintDetailApprovalRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserRoleRepository userRoleRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    UserRoleService userRoleService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllEpVoicePicker(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.complaintService.getAllCloseComplaint(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for cmsReport--");
            Specification filters = ComplaintDetailSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.complaintDetailRepository.findAll(filters, sort) : this.complaintDetailRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (ComplaintDetail item : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for cmsReport", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading cmsReport CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String getColumnValue(ComplaintDetail item, String columnName) {
        switch (columnName) {
            case "agentRemarks": {
                return this.checkNull((Object)item.getAgentRemarks());
            }
            case "pendingForApprovalDate": {
                return this.checkNull((Object)item.getPendingForApprovalDate());
            }
            case "closedBy": {
                return this.checkNull((Object)item.getClosedBy());
            }
            case "complaintDesc": {
                return this.checkNull((Object)item.getComplaintDesc());
            }
            case "complaintNo": {
                return this.checkNull((Object)item.getComplaintNo());
            }
            case "complaintType": {
                return this.checkNull((Object)item.getComplaintType());
            }
            case "currentStatus": {
                return this.checkNull((Object)item.getCurrentStatus());
            }
            case "ext": {
                return this.checkNull((Object)item.getExt());
            }
            case "latitude": {
                return this.checkNull((Object)item.getLatitude());
            }
            case "longitude": {
                return this.checkNull((Object)item.getLongitude());
            }
            case "rluLocation": {
                return this.checkNull((Object)item.getRluLocation());
            }
            case "closedOn": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getClosedOn()));
            }
            case "complaintTime": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getComplaintTime()));
            }
            case "assignedOn": {
                return this.checkNull((Object)item.getAssignedOn());
            }
            case "pendingAt": {
                return this.checkNull((Object)item.getPendingAt());
            }
        }
        return "";
    }

    private String checkNull(Object value) {
        return value != null && !value.equals("null") ? value.toString() : "";
    }

    @PostMapping(value={"/assignmentList"})
    public ResponseEntity<RequestResponse> getAllComplaintAssignment(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.complaintService.getAllComplaintAssignment(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV/assignment"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForAssignment(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for pending assignment--");
            Specification filters = ComplaintDetailAssignmentSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.assignmentRepository.findAll(filters, sort) : this.assignmentRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (ComplaintDetailAssignment item : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for pending assignment", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading pending assignment CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String getColumnValue(ComplaintDetailAssignment item, String columnName) {
        switch (columnName) {
            case "agentRemarks": {
                return this.checkNull((Object)item.getAgentRemarks());
            }
            case "closedBy": {
                return this.checkNull((Object)item.getClosedBy());
            }
            case "complaintDesc": {
                return this.checkNull((Object)item.getComplaintDesc());
            }
            case "complaintNo": {
                return this.checkNull((Object)item.getComplaintNo());
            }
            case "complaintType": {
                return this.checkNull((Object)item.getComplaintType());
            }
            case "currentStatus": {
                return this.checkNull((Object)item.getCurrentStatus());
            }
            case "ext": {
                return this.checkNull((Object)item.getExt());
            }
            case "latitude": {
                return this.checkNull((Object)item.getLatitude());
            }
            case "longitude": {
                return this.checkNull((Object)item.getLongitude());
            }
            case "rluLocation": {
                return this.checkNull((Object)item.getRluLocation());
            }
            case "closedOn": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getClosedOn()));
            }
            case "complaintTime": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getComplaintTime()));
            }
            case "compSource": {
                return this.checkNull((Object)item.getCompSource());
            }
        }
        return "";
    }

    @PostMapping(value={"/engineerList"})
    public ResponseEntity<RequestResponse> getAllComplaintEngineer(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.complaintService.getAllComplaintEngineer(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV/engineer"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForEngineer(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for complaint engineer--");
            String agentId = "";
            if (!this.checkAdminOrHead(principal.getName())) {
                agentId = principal.getName();
            }
            Specification filters = ComplaintDetailEngineerSpecification.generateFilters((SearchRequest)searchRequestData, (String)agentId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.complaintDetailEngineerRepository.findAll(filters, sort) : this.complaintDetailEngineerRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (ComplaintDetailEngineer item : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for complaint engineer", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading complaint engineer CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String getColumnValue(ComplaintDetailEngineer item, String columnName) {
        switch (columnName) {
            case "agentRemarks": {
                return this.checkNull((Object)item.getAgentRemarks());
            }
            case "closedBy": {
                return this.checkNull((Object)item.getClosedBy());
            }
            case "complaintDesc": {
                return this.checkNull((Object)item.getComplaintDesc());
            }
            case "complaintNo": {
                return this.checkNull((Object)item.getComplaintNo());
            }
            case "complaintType": {
                return this.checkNull((Object)item.getComplaintType());
            }
            case "currentStatus": {
                return this.checkNull((Object)item.getCurrentStatus());
            }
            case "ext": {
                return this.checkNull((Object)item.getExt());
            }
            case "latitude": {
                return this.checkNull((Object)item.getLatitude());
            }
            case "longitude": {
                return this.checkNull((Object)item.getLongitude());
            }
            case "rluLocation": {
                return this.checkNull((Object)item.getRluLocation());
            }
            case "closedOn": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getClosedOn()));
            }
            case "complaintTime": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getComplaintTime()));
            }
            case "adminRemarks": {
                return this.checkNull((Object)item.getAdminRemarks());
            }
            case "agentId": {
                return this.checkNull((Object)item.getAgentId());
            }
            case "assignedOn": {
                return this.checkNull((Object)item.getAssignedOn());
            }
            case "pendingAt": {
                return this.checkNull((Object)item.getPendingAt());
            }
            case "compSource": {
                return this.checkNull((Object)item.getCompSource());
            }
        }
        return "";
    }

    @PostMapping(value={"/closedList"})
    public ResponseEntity<RequestResponse> getAllComplaintClosed(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.complaintService.getAllComplaintClosed(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV/closed"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForClosed(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for closed complaint--");
            Specification filters = ComplaintDetailClosedSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.closedRepository.findAll(filters, sort) : this.closedRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (ComplaintDetailClosed item : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for closed complaint", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading closed complaint CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String getColumnValue(ComplaintDetailClosed item, String columnName) {
        switch (columnName) {
            case "agentRemarks": {
                return this.checkNull((Object)item.getAgentRemarks());
            }
            case "closedBy": {
                return this.checkNull((Object)item.getClosedBy());
            }
            case "complaintDesc": {
                return this.checkNull((Object)item.getComplaintDesc());
            }
            case "complaintNo": {
                return this.checkNull((Object)item.getComplaintNo());
            }
            case "complaintType": {
                return this.checkNull((Object)item.getComplaintType());
            }
            case "currentStatus": {
                return this.checkNull((Object)item.getCurrentStatus());
            }
            case "ext": {
                return this.checkNull((Object)item.getExt());
            }
            case "latitude": {
                return this.checkNull((Object)item.getLatitude());
            }
            case "longitude": {
                return this.checkNull((Object)item.getLongitude());
            }
            case "rluLocation": {
                return this.checkNull((Object)item.getRluLocation());
            }
            case "closedOn": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getClosedOn()));
            }
            case "complaintTime": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getComplaintTime()));
            }
        }
        return "";
    }

    @PostMapping(value={"/approvalList"})
    public ResponseEntity<RequestResponse> getAllComplaintDetailApproval(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.complaintService.getAllComplaintDetailApproval(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV/approval"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForApproval(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for approval complaint--");
            Specification filters = ComplaintDetailApprovalSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.complaintDetailApprovalRepository.findAll(filters, sort) : this.complaintDetailApprovalRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (ComplaintDetailApproval item : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for approval complaint", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading approval complaint CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String getColumnValue(ComplaintDetailApproval item, String columnName) {
        switch (columnName) {
            case "agentRemarks": {
                return this.checkNull((Object)item.getAgentRemarks());
            }
            case "closedBy": {
                return this.checkNull((Object)item.getClosedBy());
            }
            case "complaintDesc": {
                return this.checkNull((Object)item.getComplaintDesc());
            }
            case "complaintNo": {
                return this.checkNull((Object)item.getComplaintNo());
            }
            case "complaintType": {
                return this.checkNull((Object)item.getComplaintType());
            }
            case "currentStatus": {
                return this.checkNull((Object)item.getCurrentStatus());
            }
            case "ext": {
                return this.checkNull((Object)item.getExt());
            }
            case "latitude": {
                return this.checkNull((Object)item.getLatitude());
            }
            case "longitude": {
                return this.checkNull((Object)item.getLongitude());
            }
            case "rluLocation": {
                return this.checkNull((Object)item.getRluLocation());
            }
            case "closedOn": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getClosedOn()));
            }
            case "complaintTime": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getComplaintTime()));
            }
            case "compSource": {
                return this.checkNull((Object)item.getCompSource());
            }
        }
        return "";
    }

    @PostMapping(value={"/updateByComplaintNoAssignment"})
    public ResponseEntity<RequestResponse> updateByComplaintNoForAssignment(@RequestBody TCdrModel data, Principal principal) {
        RequestResponse returnValue = this.complaintService.updateByComplaintNoForAssignment(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateByComplaintNoEngineer"})
    public ResponseEntity<RequestResponse> updateByComplaintNoForEngineer(@RequestBody TCdrModel data, Principal principal) {
        RequestResponse returnValue = this.complaintService.updateByComplaintNoForEngineer(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateByComplaintNoAdminAndHead"})
    public ResponseEntity<RequestResponse> updateByComplaintNoForEngineerForAdminAndHed(@RequestBody TCdrModel data, Principal principal) {
        RequestResponse returnValue = this.complaintService.updateByComplaintNoForEngineerForAdminAndHed(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateByComplaintNoApproved"})
    public ResponseEntity<RequestResponse> updateByComplaintNoForApproved(@RequestBody TCdrModel data, Principal principal) {
        RequestResponse returnValue = this.complaintService.updateByComplaintNoForApproved(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateByComplaintNoAssignUser"})
    public ResponseEntity<RequestResponse> updateByComplaintNoForAssignToOtherUser(@RequestBody TCdrModel data, Principal principal) {
        RequestResponse returnValue = this.complaintService.updateByComplaintNoForAssignToOtherUser(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    public boolean checkAdminOrHead(String userName) {
        Optional roleHead = this.roleRepository.findByShortCode("ROLE_DEPTHEAD");
        Optional roleAdmin = this.roleRepository.findByShortCode("ROLE_ADMIN");
        ArrayList roleId = new ArrayList();
        roleHead.ifPresent(role -> roleId.add(role.getId()));
        roleAdmin.ifPresent(role -> roleId.add(role.getId()));
        List havingRole = this.userRoleService.roleIdOfParticularUser(userName);
        for (Integer id : roleId) {
            if (!havingRole.contains(id)) continue;
            return true;
        }
        return false;
    }

    static {
        columnMappings.put("agentRemarks", "Remarks");
        columnMappings.put("closedBy", "Closed By");
        columnMappings.put("complaintDesc", "Complaint Desc");
        columnMappings.put("complaintNo", "Complaint Number");
        columnMappings.put("complaintType", "Complaint Type");
        columnMappings.put("currentStatus", "Current Status");
        columnMappings.put("ext", "Extension");
        columnMappings.put("latitude", "Latitude");
        columnMappings.put("longitude", "Longitude");
        columnMappings.put("rluLocation", "RLULocation");
        columnMappings.put("complaintTime", "Complaint Time");
        columnMappings.put("adminRemarks", "Remarks");
        columnMappings.put("agentId", "Agent Id");
        columnMappings.put("assignedOn", "Assigned On");
        columnMappings.put("pendingAt", "Pending At");
        columnMappings.put("assignedOn", "Assigned On");
        columnMappings.put("pendingAt", "Assigned To");
        columnMappings.put("compSource", "Source");
        columnMappings.put("pendingForApprovalDate", "Pending For Approval Date");
    }
}

