/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.billingSummaryView.service;

import com.coraltele.db.billing.main.entity.view.ViewChannels;
import com.coraltele.db.billing.main.repository.ViewChannelsRepository;
import com.coraltele.db.billing.main.specification.ViewChannelsSpecification;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.billingSummaryView.model.BillingSummaryViewModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BillingSummaryViewService {
    private static final Logger logger = LogManager.getLogger(BillingSummaryViewService.class);
    @Autowired
    ViewChannelsRepository viewChannelsRepository;

    public RequestResponse getAllFilteredData(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ViewChannelsSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = this.determineSortOrder(searchRequestData);
        List billingSummaryViews = this.viewChannelsRepository.findAll(filters);
        List aggregatedData = this.aggregateBillingSummary(billingSummaryViews);
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(0L);
        responseData.setPageSize((long)aggregatedData.size());
        responseData.setTotalPages(1L);
        responseData.setTotalRecords((long)aggregatedData.size());
        responseData.setCurrentPageData((Object)aggregatedData);
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    private Sort determineSortOrder(SearchRequest searchRequestData) {
        Sort sort = null;
        if ("asc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if ("desc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).descending();
        }
        return sort;
    }

    private List<BillingSummaryViewModel> aggregateBillingSummary(List<ViewChannels> billingSummaryViews) {
        HashMap<String, BillingSummaryViewModel> aggregationMap = new HashMap<String, BillingSummaryViewModel>();
        for (ViewChannels row : billingSummaryViews) {
            String direction = this.mapDirection(row.getDirection());
            BillingSummaryViewModel data = aggregationMap.getOrDefault(direction, new BillingSummaryViewModel());
            data.setDirection(direction);
            data.setTotal(Long.valueOf(data.getTotal() + 1L));
            if (row.getCallType() == null || row.getCallType().isEmpty()) {
                data.setNoCallType(Long.valueOf(data.getNoCallType() + 1L));
            } else if ("LOCAL".equalsIgnoreCase(row.getCallType())) {
                data.setLocal(Long.valueOf(data.getLocal() + 1L));
            } else if ("STD".equalsIgnoreCase(row.getCallType())) {
                data.setStd(Long.valueOf(data.getStd() + 1L));
            } else if ("ISD".equalsIgnoreCase(row.getCallType())) {
                data.setIsd(Long.valueOf(data.getIsd() + 1L));
            }
            aggregationMap.put(direction, data);
        }
        return new ArrayList<BillingSummaryViewModel>(aggregationMap.values());
    }

    private String mapDirection(String direction) {
        if ("INT".equalsIgnoreCase(direction)) {
            return "Intercom";
        }
        if ("IN".equalsIgnoreCase(direction)) {
            return "Incoming";
        }
        if ("OUT".equalsIgnoreCase(direction)) {
            return "Outgoing";
        }
        return direction;
    }
}

