/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.helper.Constants;
import com.coraltele.helper.Messaging;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.OutageModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/message/request"})
@RestController
public class MessageController {
    private static final Logger logger = LogManager.getLogger(MessageController.class);

    public MessageController(SimpMessagingTemplate simpMessagingTemplate) {
        Messaging.setMessagingTemplate((SimpMessagingTemplate)simpMessagingTemplate);
    }

    @PostMapping(value={"/sendMessage"})
    public ResponseEntity<RequestResponse> sendEvent(@RequestBody OutageModel message) {
        try {
            ObjectMapper obj = new ObjectMapper();
            String data = obj.writeValueAsString((Object)message);
            logger.info("Sending message : {}", (Object)data);
            Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", "events"), (Object)data);
        }
        catch (Exception ex) {
            logger.error("Sending message", (Throwable)ex);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        if (returnValue.getStatus() == Constants.Error.OK) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

