CREATE OR REPLACE VIEW public.v_uc_channels
 AS
 SELECT a.cc_agent,
    a.coral_rlucode,
    a.coral_gatewayname,
    a.coral_gateway,
    a.transfertype AS type,
    a.caller_id_number,
    a.caller_id_name,
    a.operator_a,
    a.operator_name,
    a.did_number,
    a.dod_number,
    a.direction,
    a.initial_dest,
    a.destination_number,
    a.start_stamp,
    a.answer_stamp,
    a.end_stamp,
        CASE
            WHEN a.answer_stamp IS NOT NULL THEN date_part('epoch'::text, a.end_stamp::timestamp without time zone - a.answer_stamp)::numeric
            ELSE 0::numeric
        END AS billsec,
        CASE
            WHEN a.answer_stamp IS NOT NULL THEN date_part('epoch'::text, a.end_stamp::timestamp without time zone - a.start_stamp)::numeric
            ELSE 0::numeric
        END AS duration,
    a.status,
    a.call_type,
    a.pulse,
    (ceiling(COALESCE(
        CASE
            WHEN a.answer_stamp IS NOT NULL THEN date_part('epoch'::text, a.end_stamp::timestamp without time zone - a.answer_stamp)::numeric
            ELSE 0::numeric
        END, 0::numeric) /
        CASE
            WHEN COALESCE(a.pulse, 60::numeric) = 0::numeric THEN 60::numeric
            ELSE COALESCE(a.pulse, 60::numeric)
        END) * (COALESCE(a.pulserate, 0::numeric) / 100::numeric))::numeric(10,2) AS call_cost,
    a.featurecodename,
    a.servercode,
    a.transfertype,
    a.transferredby,
    a.transferredto,
    a.company,
    a.department,
    a.designation,
    a.accountcode,
    a.id,
    a.epoch,
    a.uuid,
    a.hungupcause AS hangup_cause,
    a.coral_inboundgateway,
    a.coral_inboundgatewayname,
    ''::text AS coral_accountcode,
    0 AS nooftry,
    ''::text AS column14,
    false AS sendsms,
    0::numeric AS pdd_ms,
    0::numeric AS rtp_audio_in_mos,
    ''::text AS billaccount,
    ''::text AS oc_group,
    ''::text AS coral_op_oc_ext,
    ''::text AS cc_queue,
    ''::text AS cc_member_uuid,
    '1970-01-01 00:00:00'::timestamp without time zone AS agent_answer_stamp,
    0::numeric AS cc_queue_joined_epoch,
    ''::text AS cc_agent_type,
    ''::text AS trfr_by_contact,
    a.operator_a AS trfr_by_agent,
    ''::text AS trfr_from_queue,
    a.recording_file AS cc_record_filename,
    ''::text AS cc_campaign,
    ''::text AS last_app,
    ''::text AS vm_filepath,
    a.ucvm AS isvoicemail,
    a.ucfax AS isfax,
    a.ucmissedcall AS ismissedcall,
    0 AS iscallcentercall,
    0 AS isoccall,
    a.uccallback AS iscallback,
    ''::text AS digits_dialed,
    a.sourceip AS remote_caller_ip,
    a.destinationip AS remote_callee_ip,
    a.call_type AS coral_call_type,
    ''::text AS column1,
    ''::text AS column2,
    a.start_stamp AS coral_startstamp,
    a.end_stamp::timestamp without time zone AS coral_endstamp,
    a.start_epoch,
    a.end_epoch,
    a.extensiontype,
    a.ucuser,
    a.isnotified,
    a.isread
   FROM ( SELECT channels.pulserate,
            (channels.ringepoch / 1000)::numeric AS start_epoch,
            (channels.endepoch / 1000)::numeric AS end_epoch,
            channels.sourceip::text AS sourceip,
            channels.destinationip::text AS destinationip,
            channels.uccallback,
            channels.ucvm,
            channels.ucfax,
            channels.ucmissedcall,
            channels.recording_file,
            channels.inboundgateway,
            channels.outboundgateway,
            channels.hungupcause,
            channels.uuid::text AS uuid,
            channels.id,
            channels.epoch,
            ''::text AS cc_agent,
            channels.location::text AS coral_rlucode,
            channels.coral_inboundgateway,
            channels.coral_inboundgatewayname,
            channels.coral_gatewayname,
            channels.coral_gateway,
            '0'::numeric AS duration,
            ''::text AS type,
            COALESCE(channels.actuallocaluser, channels.localuser)::text AS caller_id_number,
            channels.localname::text AS caller_id_name,
            channels.callassistedby::text AS operator_a,
            ''::text AS operator_name,
            channels.did_number,
            channels.dod_number,
            COALESCE(channels.calldirection, channels.calldirection)::text AS direction,
            COALESCE(channels.actualremoteuser, channels.remoteuser)::text AS initial_dest,
            COALESCE(channels.actualremoteuser, channels.remoteuser)::text AS destination_number,
            to_char(to_timestamp((channels.ringepoch / 1000)::double precision), 'YYYY-MM-DD HH24:MI:SS'::text)::timestamp without time zone AS start_stamp,
                CASE
                    WHEN channels.answerepoch = '0'::bigint THEN NULL::timestamp without time zone
                    ELSE to_char(to_timestamp((channels.answerepoch / 1000)::double precision), 'YYYY-MM-DD HH24:MI:SS'::text)::timestamp without time zone
                END AS answer_stamp,
            to_char(to_timestamp((channels.endepoch / 1000)::double precision), 'YYYY-MM-DD HH24:MI:SS'::text) AS end_stamp,
                CASE
                    WHEN channels.answerepoch > 0 THEN ceiling((channels.endepoch - channels.answerepoch)::double precision / 1000::double precision)::numeric
                    ELSE 0::numeric
                END AS billsec,
                CASE
                    WHEN channels.answerepoch > 0 THEN 'Answered'::text
                    ELSE 'Unanswered'::text
                END AS status,
            channels.call_type,
            channels.pulse::numeric AS pulse,
            0::numeric AS call_cost,
            channels.featuretype::text AS featurecodename,
            channels.servercode::text AS servercode,
                CASE
                    WHEN channels.transfertype::text = 'A'::text THEN 'Attendant Transfer'::text
                    WHEN channels.transfertype::text = 'B'::text THEN 'Blind Transfer'::text
                    ELSE ''::text
                END AS transfertype,
            channels.transferredby::text AS transferredby,
            channels.transferredto::text AS transferredto,
            channels.extensiontype,
            channels.company::text AS company,
            channels.department::text AS department,
            channels.designation::text AS designation,
            channels.accountcode::text AS accountcode,
            channels.ucuser,
            channels.isnotified,
            channels.isread
           FROM ( SELECT channels_1.id,
                    channels_1.callid,
                    channels_1.entityuser,
                    channels_1.direction,
                    channels_1.entity,
                    channels_1.localuser,
                    channels_1.remoteuser,
                    channels_1.localtag,
                    channels_1.remotetag,
                    channels_1.epoch,
                    channels_1.localnumber,
                    channels_1.remotenumber,
                    channels_1.localname,
                    channels_1.remotename,
                    channels_1.state,
                    channels_1.entitynumber,
                    channels_1.updatetype,
                    channels_1.epochdate,
                    channels_1.groupcode,
                    channels_1.replacetag,
                    channels_1.via,
                    channels_1.holdstate,
                    channels_1.uuid,
                    channels_1.respondedbynumber,
                    channels_1.respondedbyname,
                    channels_1.topic,
                    channels_1.subtopic,
                    channels_1.issingleleg,
                    channels_1.lastpacket,
                    channels_1.lastpacketip,
                    channels_1.localcontact,
                    channels_1.remotecontact,
                    channels_1.featuretype,
                    channels_1.parkedby,
                    channels_1.parkingslot,
                    channels_1.referto,
                    channels_1.refertoentity,
                    channels_1.refertoreplace,
                    channels_1.refertoactualnumber,
                    channels_1.virtual,
                    channels_1.localrpid,
                    channels_1.remoterpid,
                    channels_1.linkcallid,
                    channels_1.ringepoch,
                    channels_1.answerepoch,
                    channels_1.endepoch,
                    channels_1.company,
                    channels_1.department,
                    channels_1.designation,
                    channels_1.accountcode,
                    channels_1.location,
                    channels_1.hangupcause,
                    channels_1.sourceip,
                    channels_1.sourceport,
                    channels_1.destinationip,
                    channels_1.destinationport,
                    channels_1.traceid,
                    channels_1.channeltype,
                    channels_1.extensiontype,
                    channels_1.rlucode,
                    channels_1.isanswered,
                    channels_1.servercode,
                    channels_1.billingsent,
                    channels_1.transfertype,
                    channels_1.transferredby,
                    channels_1.transferredto,
                    channels_1.callassistedby,
                    channels_1.actuallocaluser,
                    channels_1.actualremoteuser,
                    channels_1.calldirection,
                    channels_1.fsuuid,
                    channels_1.inboundgateway,
                    channels_1.outboundgateway,
                    channels_1.keyfield,
                    channels_1.ucmissedcall,
                    channels_1.ucvm,
                    channels_1.ucfax,
                    channels_1.uccallback,
                    channels_1.ucfileupload,
                    channels_1.ucmessage,
                    channels_1.ucuser,
                    channels_1.hostname,
                    channels_1.recording_file,
                    channels_1.unreachablecall,
                    channels_1.hungupcause,
                    channels_1.did_number,
                    channels_1.dod_number,
                    channels_1.call_type,
                    channels_1.coral_inboundgateway,
                    channels_1.coral_inboundgatewayname,
                    channels_1.coral_gatewayname,
                    channels_1.coral_gateway,
                    channels_1.pulse,
                    channels_1.pulserate,
                    channels_1.call_cost,
                    channels_1.recordingfileprocessed,
                    channels_1.isnotified,
                    channels_1.isread
                   FROM channels channels_1
                UNION
                 SELECT channels_recipient.id,
                    channels_recipient.callid,
                    channels_recipient.entityuser,
                    channels_recipient.direction,
                    channels_recipient.entity,
                    channels_recipient.localuser,
                    channels_recipient.remoteuser,
                    channels_recipient.localtag,
                    channels_recipient.remotetag,
                    channels_recipient.epoch,
                    channels_recipient.remotenumber AS localnumber,
                    channels_recipient.localnumber AS remotenumber,
                    channels_recipient.remotename AS localname,
                    channels_recipient.localname AS remotename,
                    channels_recipient.state,
                    channels_recipient.entitynumber,
                    channels_recipient.updatetype,
                    channels_recipient.epochdate,
                    channels_recipient.groupcode,
                    channels_recipient.replacetag,
                    channels_recipient.via,
                    channels_recipient.holdstate,
                    channels_recipient.uuid,
                    channels_recipient.respondedbynumber,
                    channels_recipient.respondedbyname,
                    channels_recipient.topic,
                    channels_recipient.subtopic,
                    channels_recipient.issingleleg,
                    channels_recipient.lastpacket,
                    channels_recipient.lastpacketip,
                    channels_recipient.localcontact,
                    channels_recipient.remotecontact,
                    channels_recipient.featuretype,
                    channels_recipient.parkedby,
                    channels_recipient.parkingslot,
                    channels_recipient.referto,
                    channels_recipient.refertoentity,
                    channels_recipient.refertoreplace,
                    channels_recipient.refertoactualnumber,
                    channels_recipient.virtual,
                    channels_recipient.localrpid,
                    channels_recipient.remoterpid,
                    channels_recipient.linkcallid,
                    channels_recipient.ringepoch,
                    channels_recipient.answerepoch,
                    channels_recipient.endepoch,
                    channels_recipient.company,
                    channels_recipient.department,
                    channels_recipient.designation,
                    channels_recipient.accountcode,
                    channels_recipient.location,
                    channels_recipient.hangupcause,
                    channels_recipient.sourceip,
                    channels_recipient.sourceport,
                    channels_recipient.destinationip,
                    channels_recipient.destinationport,
                    channels_recipient.traceid,
                    channels_recipient.channeltype,
                    channels_recipient.extensiontype,
                    channels_recipient.rlucode,
                    channels_recipient.isanswered,
                    channels_recipient.servercode,
                    channels_recipient.billingsent,
                    channels_recipient.transfertype,
                    channels_recipient.transferredby,
                    channels_recipient.transferredto,
                    channels_recipient.callassistedby,
                    channels_recipient.actualremoteuser AS actuallocaluser,
                    channels_recipient.actuallocaluser AS actualremoteuser,
                    channels_recipient.calldirection,
                    channels_recipient.fsuuid,
                    channels_recipient.inboundgateway,
                    channels_recipient.outboundgateway,
                    channels_recipient.keyfield,
                    channels_recipient.ucmissedcall,
                    channels_recipient.ucvm,
                    channels_recipient.ucfax,
                    channels_recipient.uccallback,
                    channels_recipient.ucfileupload,
                    channels_recipient.ucmessage,
                    channels_recipient.ucuser,
                    channels_recipient.hostname,
                    channels_recipient.recording_file,
                    channels_recipient.unreachablecall,
                    channels_recipient.hungupcause,
                    channels_recipient.did_number,
                    channels_recipient.dod_number,
                    channels_recipient.call_type,
                    channels_recipient.coral_inboundgateway,
                    channels_recipient.coral_inboundgatewayname,
                    channels_recipient.coral_gatewayname,
                    channels_recipient.coral_gateway,
                    channels_recipient.pulse,
                    channels_recipient.pulserate,
                    channels_recipient.call_cost,
                    channels_recipient.recordingfileprocessed,
                    channels_recipient.isnotified,
                    channels_recipient.isread
                   FROM channels_recipient) channels) a;