/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.telephony.uc.entity.VMTransferDetails;
import com.coraltele.db.telephony.uc.repository.VMTransferDetailsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.uc.model.VMTransferDetailsModel;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class VMTransferDetailsService {
    private static final Logger logger = LogManager.getLogger(VMTransferDetailsService.class);
    @Autowired
    VMTransferDetailsRepository vmTransferDetailsRepository;

    public RequestResponse createVMTransferDetails(VMTransferDetailsModel dataList, Authentication authentication, Long keyValue) {
        RequestResponse returnValue = new RequestResponse();
        List extensions = dataList.getExtension();
        if (extensions.size() == 0 || extensions.isEmpty()) {
            returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
            returnValue.setMessage("Data Can Not Be Transferred");
            returnValue.setMessageDetail("Users Must Be Selected For Transferring The Voicemail ");
            logger.info(returnValue.getMessageDetail());
        } else {
            for (String extension : extensions) {
                VMTransferDetails vmTransferDetails = new VMTransferDetails();
                vmTransferDetails.setCreatedOn(LocalDateTime.now());
                vmTransferDetails.setDescription(dataList.getDescription());
                vmTransferDetails.setSourceUser(authentication.getName());
                vmTransferDetails.setDestinationUser(extension);
                vmTransferDetails.setRemarks(dataList.getRemarks());
                vmTransferDetails.setKeyvalue(keyValue);
                vmTransferDetails.setUuid(UUID.randomUUID().toString());
                if (dataList.getRemarks() != null && !dataList.getRemarks().equals("")) {
                    this.vmTransferDetailsRepository.save((Object)vmTransferDetails);
                    continue;
                }
                returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
                returnValue.setMessage("Data Can Not Be Transferred");
                returnValue.setMessageDetail("Remarks Must Not Be Empty ");
                logger.info(returnValue.getMessageDetail());
                return returnValue;
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("vmTransferDetails created");
            returnValue.setMessageDetail("Data Has Been Successfully Sent To Selected Users. ");
            logger.info(returnValue.getMessageDetail());
        }
        return returnValue;
    }
}

