/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentCSVReport.service;

import com.coraltele.model.Filter;
import com.coraltele.model.SearchResultModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AgentPerformanceDailyCSVService {
    private static final Logger logger = LogManager.getLogger(AgentPerformanceDailyCSVService.class);

    private boolean isDurationField(String fieldName) {
        return Arrays.asList("talk_duration", "ring_duration", "avg_talktime", "logintime", "breaktime", "acwtime", "unservicetime", "netlogintime", "idealtime").contains(fieldName);
    }

    private String formatSecondsToHHMMSS(long seconds) {
        Duration duration = Duration.ofSeconds(seconds);
        long h = duration.toHours();
        long m = duration.toMinutes() % 60L;
        long s = duration.getSeconds() % 60L;
        return String.format("%02d:%02d:%02d", h, m, s);
    }

    private Map<String, String> getHeaderMapping() {
        LinkedHashMap<String, String> headerMapping = new LinkedHashMap<String, String>();
        headerMapping.put("date", "Date");
        headerMapping.put("agent_name", "Agent Name");
        headerMapping.put("full_name", "Full Name");
        headerMapping.put("offered", "Total Offered");
        headerMapping.put("dialout", "Total Dialout");
        headerMapping.put("answered", "Total Answered");
        headerMapping.put("noanswered", "No Answered");
        headerMapping.put("ring_duration", "Ring Duration");
        headerMapping.put("talk_duration", "Talk Duration");
        headerMapping.put("avg_talktime", "Average Talk Time");
        headerMapping.put("second10", "Calls 10s");
        headerMapping.put("second20", "Calls 20s");
        headerMapping.put("second30", "Calls 30s");
        headerMapping.put("second40", "Calls 40s");
        headerMapping.put("second50", "Calls 50s");
        headerMapping.put("second60", "Calls 60s");
        headerMapping.put("logintime", "Login Time");
        headerMapping.put("breaktime", "Break Time");
        headerMapping.put("acwtime", "ACW Time");
        headerMapping.put("unservicetime", "Unservice Time");
        headerMapping.put("netlogintime", "Net Login Time");
        headerMapping.put("idealtime", "Idle Time");
        return headerMapping;
    }

    private String buildQuery1(SearchResultModel searchModel, String type) {
        String sortClause;
        StringBuilder dateFilter = new StringBuilder("1=1");
        StringBuilder userDateFilter = new StringBuilder("1=1");
        StringBuilder timeFilter = new StringBuilder();
        StringBuilder userTimeFilter = new StringBuilder();
        StringBuilder agentFilter = new StringBuilder();
        StringBuilder agentFilterUser = new StringBuilder();
        if (searchModel.getFilters() != null) {
            for (Filter filter : searchModel.getFilters()) {
                String field = filter.getField();
                String operator = filter.getOperator();
                String value1 = filter.getValue1();
                String value2 = filter.getValue2();
                List value3 = filter.getValue3();
                switch (field) {
                    case "agent_name": {
                        if (!"is".equalsIgnoreCase(operator) || value3 == null || value3.isEmpty()) break;
                        String names = value3.stream().map(name -> "'" + name + "'").collect(Collectors.joining(", "));
                        agentFilter.append("AND agent_name IN (").append(names).append(") ");
                        agentFilterUser.append("AND user_name IN (").append(names).append(") ");
                        break;
                    }
                    case "date": {
                        if ("is".equalsIgnoreCase(operator)) {
                            dateFilter.setLength(0);
                            userDateFilter.setLength(0);
                            dateFilter.append("TO_TIMESTAMP(start_time)::date = '").append(value1).append("'");
                            userDateFilter.append("TO_TIMESTAMP(start_epoch)::date = '").append(value1).append("'");
                            break;
                        }
                        if ("between".equalsIgnoreCase(operator)) {
                            dateFilter.setLength(0);
                            userDateFilter.setLength(0);
                            dateFilter.append("TO_TIMESTAMP(start_time)::date BETWEEN '").append(value1).append("' AND '").append(value2).append("'");
                            userDateFilter.append("TO_TIMESTAMP(start_epoch)::date BETWEEN '").append(value1).append("' AND '").append(value2).append("'");
                            break;
                        }
                        if ("greaterThan".equalsIgnoreCase(operator)) {
                            dateFilter.setLength(0);
                            userDateFilter.setLength(0);
                            dateFilter.append("TO_TIMESTAMP(start_time)::date > '").append(value1).append("'");
                            userDateFilter.append("TO_TIMESTAMP(start_epoch)::date > '").append(value1).append("'");
                            break;
                        }
                        if (!"lessThan".equalsIgnoreCase(operator)) break;
                        dateFilter.setLength(0);
                        userDateFilter.setLength(0);
                        dateFilter.append("TO_TIMESTAMP(start_time)::date < '").append(value1).append("'");
                        userDateFilter.append("TO_TIMESTAMP(start_epoch)::date < '").append(value1).append("'");
                        break;
                    }
                    case "time": {
                        if (!"between".equalsIgnoreCase(operator)) break;
                        timeFilter.setLength(0);
                        userTimeFilter.setLength(0);
                        timeFilter.append("AND TO_TIMESTAMP(start_time)::time BETWEEN '").append(value1).append("' AND '").append(value2).append("' ");
                        userTimeFilter.append("AND TO_TIMESTAMP(start_epoch)::time BETWEEN '").append(value1).append("' AND '").append(value2).append("' ");
                    }
                }
            }
        }
        String orderBy = "";
        if (searchModel.getSorts() != null && !searchModel.getSorts().isEmpty() && !(sortClause = searchModel.getSorts().stream().filter(s -> s.getColumn() != null && s.getDirection() != null).map(s -> {
            String direction = s.getDirection().equalsIgnoreCase("descending") ? "DESC" : "ASC";
            return s.getColumn() + " " + direction;
        }).collect(Collectors.joining(", "))).isEmpty()) {
            orderBy = " ORDER BY " + sortClause;
        }
        String query = "";
        query = type.equalsIgnoreCase("daily") ? "SELECT a1.date, a1.agent_name, a1.full_name, a1.Offered, a1.Dialout, a1.Answered, a1.NoAnswered, a1.Ring_Duration, a1.Talk_Duration, ROUND(a1.Talk_Duration / NULLIF(a1.Answered, 0), 2) AS Avg_TalkTime, a1.second10, a1.second20, a1.second30, a1.second40, a1.second50, a1.second60, b1.LoginTime, b1.BreakTime, b1.ACWTime, b1.UnserviceTime, b1.LoginTime - (b1.BreakTime + b1.UnserviceTime) AS NetLoginTime, b1.LoginTime - (a1.Ring_Duration + b1.ACWTime + a1.Talk_Duration + b1.BreakTime + b1.UnserviceTime) AS IdealTime FROM ( SELECT date, agent_name, full_name, SUM(Offered) AS Offered, SUM(DialOut) AS Dialout, SUM(Answered) AS Answered, SUM(NoAnswered) AS NoAnswered, SUM(Ring_Duration) AS Ring_Duration, SUM(talk_duration) AS Talk_Duration, SUM(second10) AS second10, SUM(second20) AS second20, SUM(second30) AS second30, SUM(second40) AS second40, SUM(second50) AS second50, SUM(second60) AS second60 FROM ( SELECT TO_TIMESTAMP(start_time)::date AS date, agent_name, full_name, CASE WHEN call_direction = 'IN' THEN 1 ELSE 0 END AS Offered, CASE WHEN call_direction = 'OUT' THEN 1 ELSE 0 END AS DialOut, CASE WHEN bridge_uuid IS NOT NULL THEN 1 ELSE 0 END AS Answered, CASE WHEN bridge_uuid IS NULL THEN 1 ELSE 0 END AS NoAnswered, duration, CASE WHEN call_direction = 'IN' AND bridge_uuid IS NOT NULL THEN duration - talk_duration ELSE duration END AS Ring_Duration, talk_duration, second10, second20, second30, second40, second50, second60 FROM agent_cdr WHERE " + dateFilter + " " + timeFilter + " " + agentFilter.toString() + ") a GROUP BY date, agent_name, full_name ) a1 LEFT JOIN ( SELECT date, user_name, SUM(LoginTime) AS LoginTime, SUM(BreakTime) AS BreakTime, SUM(ACWTime) AS ACWTime, SUM(UnserviceTime) AS UnserviceTime FROM ( SELECT TO_TIMESTAMP(start_epoch)::date AS date, user_name, CASE WHEN status = 'Login' THEN end_epoch - start_epoch ELSE 0 END AS LoginTime, CASE WHEN status = 'Break' THEN end_epoch - start_epoch ELSE 0 END AS BreakTime, CASE WHEN status = 'ACW' THEN end_epoch - start_epoch ELSE 0 END AS ACWTime, CASE WHEN status = 'Start Call' THEN end_epoch - start_epoch ELSE 0 END AS UnserviceTime FROM user_status_details WHERE " + userDateFilter + " " + userTimeFilter + " " + agentFilterUser.toString() + ") a GROUP BY date, user_name ) b1 ON a1.date = b1.date AND a1.agent_name = b1.user_name " + orderBy : "SELECT a1.agent_name, a1.full_name, a1.Offered, a1.Dialout, a1.Answered, a1.NoAnswered, a1.Ring_Duration, a1.Talk_Duration, ROUND(a1.Talk_Duration / NULLIF(a1.Answered, 0), 2) AS Avg_TalkTime, a1.second10, a1.second20, a1.second30, a1.second40, a1.second50, a1.second60, b1.LoginTime, b1.BreakTime, b1.ACWTime, b1.UnserviceTime, b1.LoginTime - (b1.BreakTime + b1.UnserviceTime) AS NetLoginTime, b1.LoginTime - (a1.Ring_Duration + b1.ACWTime + a1.Talk_Duration + b1.BreakTime + b1.UnserviceTime) AS IdealTime FROM ( SELECT agent_name, full_name, SUM(Offered) AS Offered, SUM(DialOut) AS Dialout, SUM(Answered) AS Answered, SUM(NoAnswered) AS NoAnswered, SUM(Ring_Duration) AS Ring_Duration, SUM(talk_duration) AS Talk_Duration, SUM(second10) AS second10, SUM(second20) AS second20, SUM(second30) AS second30, SUM(second40) AS second40, SUM(second50) AS second50, SUM(second60) AS second60 FROM ( SELECT TO_TIMESTAMP(start_time)::date AS date, agent_name, full_name, CASE WHEN call_direction = 'IN' THEN 1 ELSE 0 END AS Offered, CASE WHEN call_direction = 'OUT' THEN 1 ELSE 0 END AS DialOut, CASE WHEN bridge_uuid IS NOT NULL THEN 1 ELSE 0 END AS Answered, CASE WHEN bridge_uuid IS NULL THEN 1 ELSE 0 END AS NoAnswered, duration, CASE WHEN call_direction = 'IN' AND bridge_uuid IS NOT NULL THEN duration - talk_duration ELSE duration END AS Ring_Duration, talk_duration, second10, second20, second30, second40, second50, second60 FROM agent_cdr WHERE " + dateFilter + " " + timeFilter + " " + agentFilter.toString() + ") a GROUP BY agent_name, full_name ) a1 LEFT JOIN ( SELECT user_name, SUM(LoginTime) AS LoginTime, SUM(BreakTime) AS BreakTime, SUM(ACWTime) AS ACWTime, SUM(UnserviceTime) AS UnserviceTime FROM ( SELECT TO_TIMESTAMP(start_epoch)::date AS date, user_name, CASE WHEN status = 'Login' THEN end_epoch - start_epoch ELSE 0 END AS LoginTime, CASE WHEN status = 'Break' THEN end_epoch - start_epoch ELSE 0 END AS BreakTime, CASE WHEN status = 'ACW' THEN end_epoch - start_epoch ELSE 0 END AS ACWTime, CASE WHEN status = 'Start Call' THEN end_epoch - start_epoch ELSE 0 END AS UnserviceTime FROM user_status_details WHERE " + userDateFilter + " " + userTimeFilter + " " + agentFilterUser.toString() + ") a GROUP BY user_name ) b1 ON a1.agent_name = b1.user_name " + orderBy;
        return query;
    }

    public void exportReportToCsv1(SearchResultModel searchModel, OutputStream outputStream) {
        String sql = "";
        sql = this.buildQuery1(searchModel, "daily");
        ArrayList results = new ArrayList();
        logger.info("sql query is :: {}", (Object)sql);
        Map headerMapping = this.getHeaderMapping();
        if (results.isEmpty()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
                 CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT.withHeader(new String[]{"No Data"}));){
                try {
                    csvPrinter.printRecord(new Object[]{"No matching records found"});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT.withHeader((String[])searchModel.getSelectedColumns().stream().map(col -> headerMapping.getOrDefault(col, col)).toArray(String[]::new)));){
            for (Map row : results) {
                ArrayList<String> formattedRow = new ArrayList<String>();
                for (String column : searchModel.getSelectedColumns()) {
                    Object value = row.get(column);
                    if (value instanceof Number && this.isDurationField(column)) {
                        formattedRow.add(this.formatSecondsToHHMMSS(((Number)value).longValue()));
                        continue;
                    }
                    formattedRow.add((String)value);
                }
                csvPrinter.printRecord(formattedRow);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exportReportToCsv2(SearchResultModel searchModel, OutputStream outputStream) {
        String sql = "";
        sql = this.buildQuery1(searchModel, "summary");
        ArrayList results = new ArrayList();
        logger.info("sql query is :: {}", (Object)sql);
        Map headerMapping = this.getHeaderMapping();
        if (results.isEmpty()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
                 CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT.withHeader(new String[]{"No Data"}));){
                try {
                    csvPrinter.printRecord(new Object[]{"No matching records found"});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT.withHeader((String[])searchModel.getSelectedColumns().stream().map(col -> headerMapping.getOrDefault(col, col)).toArray(String[]::new)));){
            for (Map row : results) {
                ArrayList<String> formattedRow = new ArrayList<String>();
                for (String column : searchModel.getSelectedColumns()) {
                    Object value = row.get(column);
                    if (value instanceof Number && this.isDurationField(column)) {
                        formattedRow.add(this.formatSecondsToHHMMSS(((Number)value).longValue()));
                        continue;
                    }
                    formattedRow.add((String)value);
                }
                csvPrinter.printRecord(formattedRow);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

