/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taskStatus.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.taskStatus.model.TaskStatusModel;
import com.coraltele.service.pbx.taskStatus.service.TaskStatusService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/taskStatus"})
public class TaskStatusController {
    private static final Logger logger = LogManager.getLogger(TaskStatusController.class);
    @Autowired
    private TaskStatusService taskStatusService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createTaskStatus(@RequestBody TaskStatusModel taskStatusModel, Principal principal) {
        RequestResponse returnValue = this.taskStatusService.createTaskStatus(taskStatusModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllTaskStatuses() {
        RequestResponse returnValue = this.taskStatusService.getAllTaskStatuses();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateTaskStatus(@RequestBody TaskStatusModel taskStatusModel, Principal principal) {
        RequestResponse returnValue = this.taskStatusService.updateTaskStatus(taskStatusModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteTaskStatus(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.taskStatusService.deleteTaskStatus(id);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getFilterTaskStatuses(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.taskStatusService.getFilterTaskStatus(searchRequest);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

