/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.smDp.service;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.smDp.model.SmDpServerModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SmDpServerService {
    private static final Logger logger = LogManager.getLogger(SmDpServerService.class);
    private static final String FILE_PATH = "/etc/default/smdp/server.config";
    ObjectMapper objectMapper = new ObjectMapper();

    public RequestResponse createOrUpdateFile(SmDpServerModel model) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Properties properties = new Properties();
            File file = new File(FILE_PATH);
            if (!file.exists()) {
                Files.createDirectories(Paths.get(file.getParent(), new String[0]), new FileAttribute[0]);
                file.createNewFile();
            }
            try (FileInputStream input2 = new FileInputStream(FILE_PATH);){
                properties.load(input2);
            }
            catch (FileNotFoundException input2) {
                // empty catch block
            }
            String keyValueJson = this.objectMapper.writeValueAsString(model.getKeyValue());
            properties.setProperty("domain", model.getDomain());
            properties.setProperty("authType", model.getAuthType());
            properties.setProperty("keyValue", keyValueJson);
            try (FileOutputStream output = new FileOutputStream(FILE_PATH);){
                properties.store(output, null);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data Save Successfully");
            returnValue.setMessageDetail("File updated successfully");
            logger.info(returnValue.getMessageDetail());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Data");
            returnValue.setMessageDetail("Contact Administrator: " + e.getMessage());
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse retrieveDataFromFile() {
        RequestResponse returnValue;
        block18: {
            returnValue = new RequestResponse();
            SmDpServerModel model = new SmDpServerModel();
            try {
                Properties properties = new Properties();
                File file = new File(FILE_PATH);
                if (file.exists()) {
                    try (FileInputStream input = new FileInputStream(FILE_PATH);){
                        properties.load(input);
                        model.setDomain(properties.getProperty("domain"));
                        model.setAuthType(properties.getProperty("authType"));
                        String keyValueJson = properties.getProperty("keyValue");
                        if (keyValueJson != null && !keyValueJson.isEmpty()) {
                            Object keyValueObject = this.objectMapper.readValue(keyValueJson, Object.class);
                            model.setKeyValue(keyValueObject);
                        }
                        returnValue.setStatus(Constants.Error.OK);
                        returnValue.setData((Object)model);
                        returnValue.setMessage("Data fetched successfully");
                        break block18;
                    }
                    catch (IOException e) {
                        logger.error("Error reading file: " + e.getMessage(), (Throwable)e);
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Error while getting Data");
                        returnValue.setMessageDetail("Contact Administrator: " + e.getMessage());
                    }
                    break block18;
                }
                logger.warn("Config file does not exist: /etc/default/smdp/server.config");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Error while getting Data");
                returnValue.setMessageDetail("Config file does not exist");
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Error while getting Data");
                returnValue.setMessageDetail("Contact Administrator: " + e.getMessage());
                logger.error("Error retrieving data: " + e.getMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }
}

