/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fileConfiguration.sipTrunkConfiguration.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.fileConfiguration.sipTrunkConfiguration.model.DataModel;
import com.coraltele.service.pbx.fileConfiguration.sipTrunkConfiguration.service.SipTrunkConfigurationService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/sipFile"})
@RestController
public class SipTrunkConfigurationController {
    @Autowired
    SipTrunkConfigurationService sipTrunkConfigurationService;

    @PostMapping(value={"/dropDown"})
    public ResponseEntity<RequestResponse> getDropDown() throws IOException {
        RequestResponse returnValue = this.sipTrunkConfigurationService.getAllFiles();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{fileName}/list"})
    public ResponseEntity<RequestResponse> getFiles(@PathVariable String fileName) throws IOException {
        RequestResponse returnValue = this.sipTrunkConfigurationService.retrieveData(fileName);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{fileName}/create"})
    public ResponseEntity<RequestResponse> storeFile(@RequestBody DataModel data, @PathVariable String fileName) throws IOException {
        RequestResponse returnValue = this.sipTrunkConfigurationService.storeFile(data, fileName);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/default/{fileName}/create"})
    public ResponseEntity<RequestResponse> storeDFile(@RequestBody DataModel data, @PathVariable String fileName) throws IOException {
        RequestResponse returnValue = this.sipTrunkConfigurationService.storeDFile(data, fileName);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

