/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.distortionFile.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.distortionFile.model.DistortionFileModel;
import com.coraltele.service.pbx.distortionFile.model.DistortionPlayModel;
import com.coraltele.service.pbx.distortionFile.service.DistortionFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/distortionFile"})
@RestController
public class DistortionFileController {
    @Autowired
    DistortionFileService distortionFileService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createData(@RequestBody DistortionFileModel data) {
        RequestResponse returnValue = this.distortionFileService.createData(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.distortionFileService.getAllDistortionFile();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody DistortionFileModel data) {
        RequestResponse returnValue = this.distortionFileService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"delete"})
    public ResponseEntity<RequestResponse> delete(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.distortionFileService.deleteById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.distortionFileService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/play"})
    public ResponseEntity<RequestResponse> playDistortionFile(@RequestBody DistortionPlayModel data) {
        RequestResponse returnValue = this.distortionFileService.playDistortionFile(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<RequestResponse> upload(@RequestParam(value="file") MultipartFile file) {
        RequestResponse returnValue = this.distortionFileService.uploadWavFile(file);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/playDistortion/loop"})
    public ResponseEntity<RequestResponse> playDistortionFileInLoop(@RequestBody DistortionPlayModel data) {
        RequestResponse returnValue = this.distortionFileService.playDistortionFileInLoop(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/stopDistortion/{confNumber}"})
    public ResponseEntity<RequestResponse> stopDistortion(@PathVariable(value="confNumber") String conferenceNumber) {
        RequestResponse returnValue = this.distortionFileService.stopDistortionFilePlayback(conferenceNumber);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

