/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.campaignSummaryView.controller;

import com.coraltele.db.coralapps.callcenter.entity.view.CampaignSummaryView;
import com.coraltele.db.coralapps.callcenter.repository.CampaignSummaryViewRepository;
import com.coraltele.db.coralapps.callcenter.specification.CampaignSummaryViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.campaignSummaryView.service.CampaignSummaryPDFGenerator;
import com.coraltele.service.coralApps.callcenter.campaignSummaryView.service.CampaignSummaryViewService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/campaignSummary"})
@RestController
public class CampaignSummaryViewController {
    private static final Logger logger = LogManager.getLogger(CampaignSummaryViewController.class);
    @Autowired
    CampaignSummaryViewService campaignSummaryViewService;
    @Autowired
    CampaignSummaryViewRepository campaignSummaryViewRepository;
    @Autowired
    CampaignSummaryPDFGenerator campaignSummaryPDFGenerator;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllCampaignSummaryByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.campaignSummaryViewService.getAllCampaignSummaryByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for campaignSummary--");
            Specification filters = CampaignSummaryViewSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "leadUploadDate" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "leadUploadDate" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.campaignSummaryViewRepository.findAll(filters, sort) : this.campaignSummaryViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CampaignSummaryView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for campaignSummary", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading campaignSummary CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(CampaignSummaryView item, String columnName) {
        switch (columnName) {
            case "abandoned": {
                return this.checkNull((Object)item.getAbondoned());
            }
            case "answered": {
                return this.checkNull((Object)item.getAnswered());
            }
            case "campaign": {
                return this.checkNull((Object)item.getCampaign());
            }
            case "campaignId": {
                return this.checkNull((Object)item.getCampaignId());
            }
            case "dialPending": {
                return this.checkNull((Object)item.getDialPending());
            }
            case "dnCl": {
                return this.checkNull((Object)item.getDnCl());
            }
            case "duplicate": {
                return this.checkNull((Object)item.getDuplicate());
            }
            case "upload": {
                return this.checkNull((Object)item.getUpload());
            }
            case "validUpload": {
                return this.checkNull((Object)item.getValidUpload());
            }
            case "lastDialedOn": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getLastDialedOn()));
            }
            case "leadUploadDate": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getLeadUploadDate()));
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappings.put("abandoned", "Abandoned");
        columnMappings.put("answered", "Answered");
        columnMappings.put("campaign", "Campaign");
        columnMappings.put("campaignId", "CampaignId");
        columnMappings.put("dialPending", "Dial Pending");
        columnMappings.put("dnCl", "DNCL");
        columnMappings.put("duplicate", "Duplicate");
        columnMappings.put("upload", "Upload");
        columnMappings.put("validUpload", "Valid Upload");
        columnMappings.put("lastDialedOn", "Last Dialed On");
        columnMappings.put("leadUploadDate", "Lead Upload Date");
    }
}

