/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.IVRLanguage.service;

import com.coraltele.db.coralapps.callcenter.entity.IVRLanguage;
import com.coraltele.db.coralapps.callcenter.repository.IVRLanguageRepository;
import com.coraltele.db.coralapps.callcenter.specification.IVRLanguageSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.FileModel;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.IVRLanguage.model.IVRLanguageModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class IVRLanguageService {
    private static final Logger logger = LogManager.getLogger(IVRLanguageService.class);
    @Autowired
    IVRLanguageRepository ivrLanguageRepository;
    private static final String DIRECTORY_PATH = "/etc/coraltele/forms/mediaCenter.json";

    public List<IVRLanguage> getByIsPrimaryTrue() {
        return this.ivrLanguageRepository.findByIsPrimaryIsTrueOrderByLanguageNameAsc();
    }

    public RequestResponse createData(IVRLanguageModel data) {
        logger.debug("Create New IVR : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            IVRLanguage ivr = new IVRLanguage();
            ivr.setLanguageName(data.getLanguageName());
            ivr.setIsPrimary(data.getIsPrimary());
            this.ivrLanguageRepository.save((Object)ivr);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("IVRLanguage Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create IVRLanguage");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(IVRLanguageModel data) {
        logger.debug("Update IVR {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional ivr = this.ivrLanguageRepository.findById((Object)data.getId());
        if (!ivr.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("IVR Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getLanguageName() != null) {
            ((IVRLanguage)ivr.get()).setLanguageName(data.getLanguageName());
        }
        if (data.getIsPrimary() != null) {
            ((IVRLanguage)ivr.get()).setIsPrimary(data.getIsPrimary());
        }
        this.ivrLanguageRepository.save(ivr.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("IVR Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteIVRLanguageById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional ivrLanguage = this.ivrLanguageRepository.findById((Object)ids);
            if (ivrLanguage.isPresent()) {
                addValue.add(ivrLanguage.get());
                this.ivrLanguageRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllLanguage(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = IVRLanguageSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "languageName" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "languageName" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.ivrLanguageRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.ivrLanguageRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getIvrLanguages() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        List languages = this.ivrLanguageRepository.findAll();
        if (languages.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("List Is Empty");
            logger.error("Empty List Found");
        } else {
            languages.forEach(element -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("language", element.getLanguageName());
                map.put("isDefault", element.getIsDefault());
                addValue.add(map);
            });
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List Of Data");
            returnValue.setData(addValue);
            logger.info("List Has Been Found");
        }
        return returnValue;
    }

    public RequestResponse deleteFile(FileModel data) {
        RequestResponse returnValue = new RequestResponse();
        String pathToUpload = "/usr/local/freeswitch/sounds/" + data.getLanguage();
        Path filePath = Paths.get(pathToUpload, data.getFileName());
        if (!Files.exists(filePath, new LinkOption[0])) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File not found");
            returnValue.setMessageDetail("The specified file does not exist at the path.");
            logger.error(returnValue.getMessageDetail() + ": " + filePath.toString());
            return returnValue;
        }
        try {
            Files.delete(filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File deleted successfully.");
            returnValue.setMessageDetail("The file has been deleted from the specified path.");
            logger.info(returnValue.getMessageDetail() + ": " + filePath.toString());
            return returnValue;
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File deletion failed");
            returnValue.setMessageDetail("An error occurred while trying to delete the file.");
            logger.error(returnValue.getMessageDetail() + ": " + e.getMessage());
            return returnValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse uploadWavMP3File(MultipartFile musicFile, String language) {
        Throwable throwable;
        RequestResponse returnValue = new RequestResponse();
        if (musicFile == null || !musicFile.getOriginalFilename().endsWith(".wav") && !musicFile.getOriginalFilename().endsWith(".mp3")) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid file format. Only .wav and .mp3 files are allowed.");
            returnValue.setMessageDetail("Empty file or invalid file selected.");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        String pathToUpload = "/usr/local/freeswitch/sounds/" + language;
        Path uploadPath = Paths.get(pathToUpload, new String[0]);
        if (!Files.exists(uploadPath, new LinkOption[0])) {
            try {
                Files.createDirectories(uploadPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Directory creation failed");
                returnValue.setMessageDetail("Path does not exist for uploading the file.");
                logger.error(returnValue.getMessageDetail() + " " + e.getMessage());
                return returnValue;
            }
        }
        try {
            throwable = null;
            try (Stream<Path> files = Files.list(uploadPath);){
                files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        Files.delete(file);
                        logger.info("Deleted existing file: " + file);
                    }
                    catch (IOException e) {
                        logger.error("Failed to delete file: " + file + " " + e.getMessage());
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error deleting existing files");
            returnValue.setMessageDetail("Could not delete existing files before uploading the new one.");
            logger.error(returnValue.getMessageDetail() + " " + e.getMessage());
            return returnValue;
        }
        try {
            throwable = null;
            try (InputStream inputStream = musicFile.getInputStream();){
                String fileName = musicFile.getOriginalFilename().trim();
                Path filePath = uploadPath.resolve(fileName);
                Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
                returnValue.setData((Object)fileName);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("File uploaded successfully.");
                RequestResponse requestResponse = returnValue;
                return requestResponse;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("File upload failed");
            returnValue.setMessageDetail("Failed to upload the file due to an error.");
            logger.error(returnValue.getMessageDetail() + " " + e.getMessage());
            return returnValue;
        }
    }

    public RequestResponse saveMediaCenterJson(Object config) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(DIRECTORY_PATH);
        try {
            file.getParentFile().mkdirs();
            if (file.exists()) {
                boolean deleted = file.delete();
                if (!deleted) {
                    throw new IOException("Failed to delete existing file: /etc/coraltele/forms/mediaCenter.json");
                }
                logger.info("Existing JSON file deleted successfully at: /etc/coraltele/forms/mediaCenter.json");
            }
            objectMapper.writeValue(file, config);
            logger.info("JSON file created successfully at: /etc/coraltele/forms/mediaCenter.json");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("JSON created successfully");
        }
        catch (IOException e) {
            logger.error("Error occurred while writing JSON file: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to create config JSON");
            throw e;
        }
        return returnValue;
    }

    public RequestResponse getMediaCenterJson() {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(DIRECTORY_PATH);
        try {
            if (!file.exists()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Config file does not exist: /etc/coraltele/forms/mediaCenter.json");
                return returnValue;
            }
            Object jsonData = objectMapper.readValue(file, Object.class);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData(jsonData);
        }
        catch (IOException e) {
            logger.error("Error occurred while reading JSON file: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to retrieve config JSON");
        }
        return returnValue;
    }
}

