/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.voiceLogger.controller;

import com.coraltele.db.billing.main.entity.view.VoiceLoggerView;
import com.coraltele.db.billing.main.repository.VoiceLoggerRepository;
import com.coraltele.db.billing.main.repository.VoiceLoggerRepositoryView;
import com.coraltele.db.billing.main.specification.VoiceLoggerViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.billing.main.voiceLogger.model.VoiceLoggerDeleteModel;
import com.coraltele.service.billing.main.voiceLogger.model.VoiceLoggerZipModel;
import com.coraltele.service.billing.main.voiceLogger.service.VoiceLoggerService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/voiceLogger"})
@RestController
public class VoiceLoggerController {
    private static final Logger logger = LogManager.getLogger(VoiceLoggerService.class);
    @Autowired
    VoiceLoggerService voiceLoggerService;
    @Autowired
    VoiceLoggerRepositoryView voiceLoggerRepository;
    @Autowired
    VoiceLoggerRepository voiceLoggerRepo;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllBilling(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.voiceLoggerService.getVoiceLogger(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/recordingTypeList"})
    public ResponseEntity<RequestResponse> getAllRecordingTypeList() {
        RequestResponse returnValue = this.voiceLoggerService.getVoiceLoggerRecordingTypeList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/createTar"})
    public ResponseEntity<RequestResponse> createBackup(@RequestBody VoiceLoggerZipModel data) throws IOException {
        RequestResponse returnValue = this.voiceLoggerService.createBackupFileAsync(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteFiles"})
    public ResponseEntity<RequestResponse> deleteFiles(@RequestBody VoiceLoggerDeleteModel data) {
        RequestResponse returnValue = this.voiceLoggerService.deleteFiles(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for vPicker--");
            Specification filters = VoiceLoggerViewSpecification.generateFilters((SearchRequest)searchRequestData, (Principal)principal);
            Sort sort = null;
            if (searchRequestData.getSortDirection().equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
            } else if (searchRequestData.getSortDirection().equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.voiceLoggerRepository.findAll(filters, sort) : this.voiceLoggerRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (VoiceLoggerView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for alertHistory", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading alertHistory CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(VoiceLoggerView item, String columnName) {
        switch (columnName) {
            case "location": {
                return this.checkNull((Object)item.getLocation());
            }
            case "direction": {
                return this.checkNull((Object)item.getDirection());
            }
            case "coralApp": {
                return this.checkNull((Object)item.getCoralApp());
            }
            case "callerName": {
                return this.checkNull((Object)item.getCallerName());
            }
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "destName": {
                return this.checkNull((Object)item.getDestName());
            }
            case "startTime": {
                return item.getStartTime() == null || item.getStartTime().equals("0") ? null : DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)item.getStartTime());
            }
            case "endTime": {
                return item.getEndTime() == null || item.getEndTime().equals("0") ? null : DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)item.getEndTime());
            }
            case "duration": {
                return this.checkNull((Object)item.getDuration());
            }
            case "billsec": {
                return this.checkNull((Object)item.getBillsec());
            }
            case "fileTime": {
                return item.getFileTime() == null || item.getFileTime().equals("0") ? null : DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)item.getFileTime());
            }
            case "answerTime": {
                return item.getAnswerTime() == null || item.getAnswerTime().equals("0") ? null : DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)item.getAnswerTime());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
            case "rtpJitterMinVariance": {
                return this.checkNull((Object)item.getRtpJitterMinVariance());
            }
            case "rtpJitterMaxVariance": {
                return this.checkNull((Object)item.getRtpJitterMaxVariance());
            }
            case "rtpJitterLossRate": {
                return this.checkNull((Object)item.getRtpJitterLossRate());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
        }
        return null;
    }

    private Object checkNull(Object value) {
        return value != null ? value : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappings.put("location", "Location");
        columnMappings.put("direction", "Direction");
        columnMappings.put("coralApp", "Recording Type");
        columnMappings.put("callerName", "Caller Name");
        columnMappings.put("callerIdNumber", "Caller");
        columnMappings.put("destinationNumber", "Destination Number");
        columnMappings.put("destName", "Destination Name");
        columnMappings.put("answerTime", "Answer Time");
        columnMappings.put("startTime", "Start Time");
        columnMappings.put("endTime", "End Time");
        columnMappings.put("duration", "Duration");
        columnMappings.put("billsec", "Talk Time");
        columnMappings.put("fileTime", "File Time");
        columnMappings.put("mos", "MOS");
        columnMappings.put("rtpJitterMinVariance", "RTPJitterMinVariance");
        columnMappings.put("rtpJitterMaxVariance", "RTPJitterMaxVariance");
        columnMappings.put("rtpJitterLossRate", "RTPJitterLossRate");
        columnMappings.put("status", "Status");
    }
}

