/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.authFiles.controller;

import com.coraltele.service.pbx.extension.model.PlayFileModel;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/file"})
@RestController
public class FileStream {
    private static final Logger logger = LogManager.getLogger(FileStream.class);
    private static final String UPLOAD_DIR = "/tmp/";
    @Autowired
    private ExtensionsService extensionsService;

    @PostMapping(value={"/upload"})
    public ResponseEntity<String> uploadFile(@RequestParam(value="file") MultipartFile file) {
        if (file.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)"File is empty");
        }
        try {
            Path uploadPath = Paths.get(UPLOAD_DIR, new String[0]);
            if (!Files.exists(uploadPath, new LinkOption[0])) {
                Files.createDirectories(uploadPath, new FileAttribute[0]);
            }
            String originalFilename = file.getOriginalFilename();
            Path filePath = uploadPath.resolve(originalFilename);
            Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
            return ResponseEntity.ok((Object)filePath.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error uploading file");
        }
    }

    @GetMapping(value={"/download"})
    public ResponseEntity<Resource> downloadTarByFilePath(@RequestParam(value="filePath") String tarFilePath, @RequestHeader HttpHeaders headers) {
        Path filePath = Paths.get(tarFilePath.trim(), new String[0]);
        try {
            UrlResource resource = new UrlResource(filePath.toUri());
            if (!resource.exists()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            long fileSize = Files.size(filePath);
            List ranges = headers.getRange();
            if (ranges.isEmpty()) {
                return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + resource.getFilename() + "\""})).header("Content-Length", new String[]{String.valueOf(fileSize)})).body((Object)resource);
            }
            HttpRange range = (HttpRange)ranges.get(0);
            long start = range.getRangeStart(fileSize);
            long end = range.getRangeEnd(fileSize);
            byte[] data = Files.readAllBytes(filePath.subpath((int)start, (int)end + 1));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.PARTIAL_CONTENT).header("Content-Disposition", new String[]{"attachment; filename=\"" + resource.getFilename() + "\""})).header("Content-Range", new String[]{"bytes " + start + "-" + end + "/" + fileSize})).header("Content-Length", new String[]{String.valueOf(data.length)})).body((Object)resource);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(path={"/upload-recordings"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> uploadForm(Principal principal, @RequestPart(value="file") MultipartFile file, @RequestParam(required=false) Map<String, String> allParams) {
        try {
            String finalName;
            Path target;
            String original;
            Path destinationFolder = Paths.get("/home/coralswitch/recorded-messages", new String[0]);
            Files.createDirectories(destinationFolder, new FileAttribute[0]);
            if (file == null || file.isEmpty()) {
                return ResponseEntity.badRequest().body(Collections.singletonMap("error", "No file provided"));
            }
            String base = original = file.getOriginalFilename();
            String ext = "";
            int dot = original.lastIndexOf(46);
            if (dot > 0) {
                base = original.substring(0, dot);
                ext = original.substring(dot).toLowerCase();
            }
            if (!".mp3".equals(ext)) {
                ext = ".mp3";
            }
            if (!(target = destinationFolder.resolve(finalName = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss-SSS").format(LocalDateTime.now()) + "-" + base + ext).normalize()).startsWith(destinationFolder)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(Collections.singletonMap("error", "Invalid path"));
            }
            try (InputStream in = file.getInputStream();){
                Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
            }
            PlayFileModel playFileModel = new PlayFileModel();
            playFileModel.setWavFile(finalName);
            playFileModel.setDepartment(allParams.get("department"));
            playFileModel.setAnnouncementType("live-announcement");
            this.extensionsService.playFileForDepartment1(principal, playFileModel);
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("filename", finalName);
            body.put("size", file.getSize());
            return ResponseEntity.ok(body);
        }
        catch (IOException ex) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonMap("error", "Failed to save file"));
        }
    }
}

