/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.db.telephony.archiving.entity.BillingCdrHistorical;
import com.coraltele.db.telephony.billing.entity.Department;
import com.coraltele.db.telephony.complaint.entity.ComplaintDetail;
import com.coraltele.db.telephony.main.entity.NodeCluster;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.entity.InboundCos;
import com.coraltele.db.telephony.pbx.entity.Manufacturer;
import com.coraltele.db.telephony.pbx.entity.ModelDetail;
import com.coraltele.db.telephony.pbx.entity.OutboundCos;
import com.coraltele.db.telephony.pbx.entity.TenantMaster;
import com.coraltele.db.telephony.pbx.entity.VipMaster;
import com.coraltele.db.telephony.uc.entity.UserData;
import com.coraltele.db.telephony.uc.entity.view.PhoneBook;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.coraltele.db.telephony.pbx.repository", "com.coraltele.db.telephony.main.repository", "com.coraltele.db.telephony.uc.repository", "com.coraltele.db.telephony.archiving.repository", "com.coraltele.db.telephony.complaint.repository", "com.coraltele.db.telephony.billing.repository"}, entityManagerFactoryRef="switchEntityManagerFactory", transactionManagerRef="switchTransactionManager")
public class SwitchDataSourceConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.switch")
    public DataSourceProperties switchDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public DataSource switchDataSource(@Qualifier(value="switchDataSourceProperties") DataSourceProperties switchDataSourceProperties) {
        return this.switchDataSourceProperties().initializeDataSourceBuilder().build();
    }

    @Bean(name={"switchEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean switchEntityManagerFactory(@Qualifier(value="switchDataSource") DataSource switchDataSource, EntityManagerFactoryBuilder builder) {
        return builder.dataSource(switchDataSource).packages(new Class[]{Extension.class, ExtensionsServices.class, InboundCos.class, OutboundCos.class, TenantMaster.class, ModelDetail.class, DidMapping.class, Manufacturer.class, UserData.class, PhoneBook.class, NodeCluster.class, ComplaintDetail.class, Department.class, VipMaster.class, BillingCdrHistorical.class}).build();
    }

    @Bean
    public PlatformTransactionManager switchTransactionManager(@Qualifier(value="switchEntityManagerFactory") LocalContainerEntityManagerFactoryBean entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory.getObject());
    }

    @Bean(name={"switchJdbcTemplate"})
    public JdbcTemplate telemetryJdbcTemplate(@Qualifier(value="switchDataSource") DataSource switchDataSource) {
        return new JdbcTemplate(switchDataSource);
    }
}

