CREATE OR REPLACE VIEW public.v_channels_v1
 AS
 SELECT 
 a.callid,
 a.dialunansweredcall,
 a.cc_agent,
 a.coral_rlucode,
 a.coral_gatewayname,
 a.coral_gateway,
 a.transfertype AS type,
 a.caller_id_number,
 a.caller_id_name,
 a.operator_a,
 a.operator_name,
 a.did_number,
 a.dod_number,
 a.direction,
 a.initial_dest,
 a.destination_number,
 a.destination_name,
 a.start_stamp,
 a.answer_stamp,
 a.end_stamp,
 CASE
 WHEN a.answer_stamp IS NOT NULL THEN date_part('epoch'::text, a.end_stamp::timestamp without time zone - a.answer_stamp)::numeric
 ELSE 0::numeric
 END AS billsec,
 CASE
 WHEN a.answer_stamp IS NOT NULL THEN date_part('epoch'::text, a.end_stamp::timestamp without time zone - a.start_stamp)::numeric
 ELSE 0::numeric
 END AS duration,
 a.status,
 a.call_type,
 a.pulse,
 (ceiling(COALESCE(
 CASE
 WHEN a.answer_stamp IS NOT NULL THEN date_part('epoch'::text, a.end_stamp::timestamp without time zone - a.answer_stamp)::numeric
 ELSE 0::numeric
 END, 0::numeric) /
 CASE
 WHEN COALESCE(a.pulse, 60::numeric) = 0::numeric THEN 60::numeric
 ELSE COALESCE(a.pulse, 60::numeric)
 END) * (COALESCE(a.pulserate, 0::numeric) / 100::numeric))::numeric(10,2) AS call_cost,
 a.featurecodename,
 a.servercode,
 a.transfertype,
 a.transferredby,
 a.transferredto,
 a.company,
 a.department,
 a.designation,
 a.accountcode,
 a.id,
 a.epoch,
 a.uuid,
 a.hungupcause AS hangup_cause,
 a.coral_inboundgateway,
 a.coral_inboundgatewayname,
 ''::text AS coral_accountcode,
 0 AS nooftry,
 ''::text AS column14,
 false AS sendsms,
 0::numeric AS pdd_ms,
 0::numeric AS rtp_audio_in_mos,
 ''::text AS billaccount,
 ''::text AS oc_group,
 ''::text AS coral_op_oc_ext,
 ''::text AS cc_queue,
 ''::text AS cc_member_uuid,
 '1970-01-01 00:00:00'::timestamp without time zone AS agent_answer_stamp,
 0::numeric AS cc_queue_joined_epoch,
 ''::text AS cc_agent_type,
 ''::text AS trfr_by_contact,
 a.operator_a AS trfr_by_agent,
 ''::text AS trfr_from_queue,
 a.recording_file AS cc_record_filename,
 ''::text AS cc_campaign,
 ''::text AS last_app,
 ''::text AS vm_filepath,
 a.ucvm AS isvoicemail,
 a.ucfax AS isfax,
 a.ucmissedcall AS ismissedcall,
 0 AS iscallcentercall,
 0 AS isoccall,
 a.uccallback AS iscallback,
 ''::text AS digits_dialed,
 a.sourceip AS remote_caller_ip,
 a.destinationip AS remote_callee_ip,
 a.call_type AS coral_call_type,
 ''::text AS column1,
 ''::text AS column2,
 a.start_stamp AS coral_startstamp,
 a.end_stamp::timestamp without time zone AS coral_endstamp,
 a.start_epoch,
 a.end_epoch,
 a.extensiontype,
 a.billing_uuid,
 a.calltrace,
 a.isdatasynced,
 a.pulserate,
 a.rtp_audio_in_jitter_loss_rate,
 a.rtp_audio_in_jitter_max_variance,
 a.rtp_audio_in_jitter_min_variance,
 case when a.mos is null then 4.3 else a.mos end as mos
 FROM ( SELECT 
 channels.callid,
 channels.dialunansweredcall,
 channels.pulserate,
 (channels.ringepoch / 1000)::numeric AS start_epoch,
 (channels.endepoch / 1000)::numeric AS end_epoch,
 channels.sourceip::text AS sourceip,
 channels.destinationip::text AS destinationip,
 channels.uccallback,
 channels.ucvm,
 channels.ucfax,
 channels.ucmissedcall,
 channels.recording_file,
 channels.inboundgateway,
 channels.outboundgateway,
 channels.hungupcause,
 channels.uuid::text AS uuid,
 channels.id,
 channels.epoch,
 ''::text AS cc_agent,
 channels.location::text AS coral_rlucode,
 channels.coral_inboundgateway,
 channels.coral_inboundgatewayname,
 channels.coral_gatewayname,
 channels.coral_gateway,
 '0'::numeric AS duration,
 ''::text AS type,
 COALESCE(channels.actuallocaluser, channels.localuser)::text AS caller_id_number,
 channels.localname::text AS caller_id_name,
 channels.callassistedby::text AS operator_a,
 ''::text AS operator_name,
 channels.did_number,
 channels.dod_number,
 COALESCE(channels.calldirection, channels.calldirection)::text AS direction,
 COALESCE(channels.actualremoteuser, channels.remoteuser)::text AS initial_dest,
 COALESCE(channels.actualremoteuser, channels.remoteuser)::text AS destination_number,
 channels.remotename::text as destination_name,

 to_char(to_timestamp((channels.ringepoch / 1000)::double precision), 'YYYY-MM-DD HH24:MI:SS'::text)::timestamp without time zone AS start_stamp,
 CASE
 WHEN channels.answerepoch = '0'::bigint THEN NULL::timestamp without time zone
 ELSE to_char(to_timestamp((channels.answerepoch / 1000)::double precision), 'YYYY-MM-DD HH24:MI:SS'::text)::timestamp without time zone
 END AS answer_stamp,
 to_char(to_timestamp((channels.endepoch / 1000)::double precision), 'YYYY-MM-DD HH24:MI:SS'::text) AS end_stamp,
 CASE
 WHEN channels.answerepoch > 0 THEN ceiling((channels.endepoch - channels.answerepoch)::double precision / 1000::double precision)::numeric
 ELSE 0::numeric
 END AS billsec,
 CASE
 WHEN channels.answerepoch > 0 THEN 'Answered'::text
 ELSE 'Unanswered'::text
 END AS status,
 channels.call_type,
 channels.pulse::numeric AS pulse,
 0::numeric AS call_cost,
 channels.featuretype::text AS featurecodename,
 channels.servercode::text AS servercode,
 CASE
 WHEN channels.transfertype::text = 'A'::text THEN 'Attendant Transfer'::text
 WHEN channels.transfertype::text = 'B'::text THEN 'Blind Transfer'::text
 ELSE ''::text
 END AS transfertype,
 channels.transferredby::text AS transferredby,
 channels.transferredto::text AS transferredto,
 channels.extensiontype,
 channels.company::text AS company,
 channels.department::text AS department,
 channels.designation::text AS designation,
 channels.accountcode::text AS accountcode,
 channels.billing_uuid,
 channels.calltrace,
 channels.isdatasynced,
 call_mos.rtp_audio_in_jitter_loss_rate,
 call_mos.rtp_audio_in_jitter_max_variance,
 call_mos.rtp_audio_in_jitter_min_variance,
 call_mos.mos
 FROM channels
 -- LEFT JOIN call_mos ON channels.callid::text = call_mos.callid::text
 LEFT JOIN call_mos ON call_mos.callid::text=
 case when channels.linkcallid::text is not null then channels.linkcallid
 when channels.linkcallid::text is null then channels.callid end
 WHERE channels.calltrace = true) a;