/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.service;

import com.coraltele.db.users.main.entity.Menu;
import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserRole;
import com.coraltele.db.users.main.entity.UserRoleMenu;
import com.coraltele.db.users.main.repository.MenuRepository;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleMenuRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.user.model.MenuGroupModel;
import com.coraltele.service.user.model.MenuModel;
import com.coraltele.service.user.model.MenuSubGroupModel;
import com.coraltele.service.user.model.UserRoleMenuModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserRoleMenuService {
    private static final Logger logger = LogManager.getLogger(UserRoleMenuService.class);
    @Autowired
    private UserRoleMenuRepository userRoleMenuRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private MenuRepository menuRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;

    public List<MenuGroupModel> menusForRolesOfParticularUser(String username) {
        RequestResponse returnData = new RequestResponse();
        ArrayList<MenuGroupModel> returnValue = new ArrayList<MenuGroupModel>();
        ArrayList<Role> listRole = new ArrayList<Role>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List userRole = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRoleTraverse : userRole) {
                listRole.add(userRoleTraverse.getRole());
            }
            List listUserRoleMenus = this.userRoleMenuRepository.findAllByRoleIn(listRole);
            MenuSubGroupModel currentSubGroup = null;
            MenuGroupModel currentGroup = null;
            for (UserRoleMenu userRoleMenu : listUserRoleMenus) {
                boolean subGroupFound = false;
                currentSubGroup = null;
                boolean groupFound = false;
                currentGroup = null;
                for (MenuGroupModel menuGroup : returnValue) {
                    if (!menuGroup.getName().equals(userRoleMenu.getMenu().getMenuSubGroup().getMenuGroup().getName())) continue;
                    groupFound = true;
                    currentGroup = menuGroup;
                }
                if (!groupFound) {
                    currentGroup = new MenuGroupModel();
                    currentGroup.setGMenuSeq(userRoleMenu.getMenu().getMenuSubGroup().getMenuGroup().getGMenuSeq());
                    currentGroup.setName(userRoleMenu.getMenu().getMenuSubGroup().getMenuGroup().getName());
                    currentGroup.setIconName(userRoleMenu.getMenu().getMenuSubGroup().getMenuGroup().getIcon());
                    returnValue.add(currentGroup);
                }
                if (currentGroup == null) continue;
                for (MenuSubGroupModel menuSubGroupModel : currentGroup.getSubGroups()) {
                    if (!menuSubGroupModel.getName().equals(userRoleMenu.getMenu().getMenuSubGroup().getName())) continue;
                    subGroupFound = true;
                    currentSubGroup = menuSubGroupModel;
                    break;
                }
                if (!subGroupFound) {
                    currentSubGroup = new MenuSubGroupModel();
                    currentGroup.getSubGroups().add(currentSubGroup);
                    currentSubGroup.setSGMenuSeq(userRoleMenu.getMenu().getMenuSubGroup().getSGMenuSeq());
                    currentSubGroup.setName(userRoleMenu.getMenu().getMenuSubGroup().getName());
                    currentSubGroup.setIconName(userRoleMenu.getMenu().getMenuSubGroup().getIcon());
                }
                if (currentSubGroup == null) continue;
                MenuModel menu = new MenuModel();
                menu.setSMenuSeq(userRoleMenu.getMenu().getSMenuSeq());
                menu.setMenuName(userRoleMenu.getMenu().getMenuName());
                menu.setIconName(userRoleMenu.getMenu().getIcon());
                menu.setMenuId(userRoleMenu.getMenu().getId().intValue());
                menu.setUrlPath(userRoleMenu.getMenu().getUrlPath());
                menu.setMenuDetail(userRoleMenu.getMenu().getDescription());
                currentSubGroup.getMenus().add(menu);
                Collections.sort(currentSubGroup.getMenus());
            }
        }
        Collections.sort(returnValue);
        returnData.setStatus(Constants.Error.OK);
        returnData.setMessage("List of Data");
        logger.info(returnData.getMessage());
        return returnValue;
    }

    public List<String> rolesOfParticularUser(String username) {
        ArrayList<String> returnValue = new ArrayList<String>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List userRole = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRoleTraverse : userRole) {
                returnValue.add(userRoleTraverse.getRole().getShortCode());
            }
        }
        return returnValue;
    }

    public RequestResponse createUserRoleMenu(UserRoleMenuModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findById(data.getUserId());
            Optional role = this.roleRepository.findById(data.getRoleId());
            Optional menu = this.menuRepository.findById(data.getMenuEId());
            UserRoleMenu userRoleMenu = new UserRoleMenu();
            if (user.isPresent() && role.isPresent() && menu.isPresent()) {
                userRoleMenu.setUser((User)user.get());
                userRoleMenu.setRole((Role)role.get());
                userRoleMenu.setMenu((Menu)menu.get());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Unable to find user or role");
                logger.info(returnValue.getMessage());
            }
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                this.userRoleMenuRepository.save((Object)userRoleMenu);
                returnValue.setMessage("userRoleMenu registered");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setMessage("Unable to register userRole");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to register this userRole");
            returnValue.setMessageDetail("Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }
}

