/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.service;

import com.coraltele.db.users.main.entity.Menu;
import com.coraltele.db.users.main.repository.MenuRepository;
import com.coraltele.db.users.main.specification.MenuSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.ReturnField;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.user.model.MenuModel;
import com.coraltele.service.user.model.MenuUpdateModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class MenuService {
    private static final Logger logger = LogManager.getLogger(MenuService.class);
    @Autowired
    private MenuRepository menuRepository;

    public RequestResponse createMenu(MenuModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Menu menu = new Menu();
            menu.setDescription(data.getMenuDetail());
            menu.setMenuName(data.getMenuName());
            menu.setUrlPath(data.getUrlPath());
            this.menuRepository.save((Object)menu);
            ReturnField field = new ReturnField();
            field.setId(menu.getId().intValue());
            field.setDescription(menu.getDescription());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Menu Registered");
            returnValue.setData((Object)field);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("unable to create menu");
            returnValue.setMessageDetail("Contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getMenuById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional menu = this.menuRepository.findById(id);
            if (menu.isPresent()) {
                MenuModel data = new MenuModel();
                data.setMenuDetail(((Menu)menu.get()).getDescription());
                data.setMenuName(((Menu)menu.get()).getMenuName());
                data.setUrlPath(((Menu)menu.get()).getUrlPath());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Menu Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.menuRepository.findAll();
        ArrayList<MenuModel> addValue = new ArrayList<MenuModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Menu menu : list) {
            MenuModel data = new MenuModel();
            data.setMenuDetail(menu.getDescription());
            data.setMenuName(menu.getMenuName());
            data.setUrlPath(menu.getUrlPath());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMenu(int id, MenuModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional menu = this.menuRepository.findById(id);
            if (menu.isPresent()) {
                ((Menu)menu.get()).setMenuName(data.getMenuName());
                ((Menu)menu.get()).setDescription(data.getMenuDetail());
                ((Menu)menu.get()).setUrlPath(data.getUrlPath());
                this.menuRepository.save(menu.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("Menu Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("menu not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update menu");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteMenu(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional menu = this.menuRepository.findById(id);
            if (menu.isPresent()) {
                this.menuRepository.deleteById((Object)id);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Record deleted successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete menu");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = MenuSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "menuName" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "menuName" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.menuRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.menuRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMenuById(MenuUpdateModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            for (Integer id : data.getId()) {
                Optional optionalMenu = this.menuRepository.findById((Object)id);
                if (optionalMenu.isPresent()) {
                    Menu menu = (Menu)optionalMenu.get();
                    menu.setIsActive(data.getIsActive());
                    this.menuRepository.save((Object)menu);
                    continue;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Menu with ID " + id + " not found");
                return returnValue;
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("Menu updated successfully");
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Error while updating Menu");
            returnValue.setMessageDetail(e.getMessage());
            logger.error("Error while updating Menu", (Throwable)e);
        }
        return returnValue;
    }
}

