/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.rluLocation.service;

import com.coraltele.db.users.main.entity.RluLocation;
import com.coraltele.db.users.main.repository.RluLocationRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.user.rluLocation.model.RluLocationModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RluLocationService {
    private static final Logger logger = LogManager.getLogger(RluLocationService.class);
    @Autowired
    RluLocationRepository rluLocationRepository;

    public RequestResponse getIP() {
        ArrayList<RluLocationModel> addValue = new ArrayList<RluLocationModel>();
        RequestResponse returnValue = new RequestResponse();
        List list = this.rluLocationRepository.findAll();
        for (RluLocation row : list) {
            RluLocationModel data = new RluLocationModel();
            logger.info("Command to execute domain: {}", (Object)row.getDomainName());
            String os = System.getProperty("os.name").toLowerCase();
            String command = os.contains("win") ? String.format("ping -n 1 %s", row.getDomainName()) : String.format("ping -c 1 %s", row.getDomainName());
            logger.info("Executing command: {}", (Object)command);
            try {
                String line;
                Process process = Runtime.getRuntime().exec(command);
                if (!process.waitFor(3L, TimeUnit.SECONDS)) {
                    process.destroy();
                    logger.warn("Ping command timed out for domain: {}", (Object)row.getDomainName());
                    continue;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String ipAddress = null;
                Pattern pattern = Pattern.compile("\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b");
                while ((line = reader.readLine()) != null) {
                    logger.info("Ping Output: {}", (Object)line);
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    ipAddress = matcher.group();
                    break;
                }
                reader.close();
                int exitCode = process.exitValue();
                if (exitCode != 0) {
                    logger.error("Ping command failed for domain: {} with exit code {}", (Object)row.getDomainName(), (Object)exitCode);
                    continue;
                }
                if (ipAddress != null) {
                    data.setId(row.getId());
                    data.setDomainName(row.getDomainName());
                    data.setIp(ipAddress);
                    if (StringUtils.hasText((String)row.getLocalServerIp()) && ipAddress.equals(row.getLocalServerIp())) {
                        data.setServer("Local");
                    } else if (StringUtils.hasText((String)row.getMainServerIp()) && ipAddress.equals(row.getMainServerIp())) {
                        data.setServer("Main");
                    } else {
                        data.setServer("Unknown");
                    }
                    addValue.add(data);
                    continue;
                }
                logger.warn("Failed to retrieve IP for {}", (Object)row.getDomainName());
            }
            catch (IOException | InterruptedException e) {
                logger.error("Error executing ping command for domain: {}", (Object)row.getDomainName(), (Object)e);
            }
        }
        if (addValue.isEmpty()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No IP addresses retrieved.");
        } else {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("IP addresses retrieved successfully.");
            returnValue.setData(addValue);
        }
        return returnValue;
    }
}

