/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.passwordConfig.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.billing.main.agentStatus.model.AgentStatusModel;
import com.coraltele.service.user.passwordConfig.model.PasswordConfigModel;
import com.coraltele.service.user.passwordConfig.service.PasswordConfigService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/passwordConfig"})
@RestController
public class PasswordConfigController {
    private static final Logger logger = LogManager.getLogger(PasswordConfigController.class);
    @Autowired
    PasswordConfigService passwordConfigService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody PasswordConfigModel data, Principal principal) {
        RequestResponse returnValue = this.passwordConfigService.createData(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.passwordConfigService.getAll();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/logout"})
    public ResponseEntity<RequestResponse> create(@RequestBody AgentStatusModel data) {
        RequestResponse returnValue = this.passwordConfigService.updateLogout(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

