/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.taskDetails.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.main.taskDetails.model.TaskDetailsCreateModel;
import com.coraltele.service.telemetry.main.taskDetails.model.TaskDetailsModel;
import com.coraltele.service.telemetry.main.taskDetails.service.TaskDetailsService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/taskDetails"})
public class TaskDetailsController {
    private static final Logger logger = LogManager.getLogger(TaskDetailsController.class);
    @Autowired
    private TaskDetailsService taskDetailsService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createTaskDetail(@RequestBody TaskDetailsCreateModel taskDetailsModel, Principal principal) {
        RequestResponse returnValue = this.taskDetailsService.createTaskDetail(taskDetailsModel, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllTaskDetails() {
        RequestResponse returnValue = this.taskDetailsService.getAllTaskDetails();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/{taskId}"})
    public ResponseEntity<RequestResponse> getByTaskId(@PathVariable(value="taskId") Integer taskId) {
        RequestResponse returnValue = this.taskDetailsService.getByTaskId(taskId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateTaskDetails(@RequestBody TaskDetailsModel taskDetailsModel, Principal principal) {
        RequestResponse returnValue = this.taskDetailsService.updateTaskDetails(taskDetailsModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteTaskDetails(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.taskDetailsService.deleteTaskDetails(id);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getFilterTaskDetails(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.taskDetailsService.getFilterTaskDetails(searchRequest);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

