/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extensionView.service;

import com.coraltele.db.telephony.pbx.entity.view.ExtensionPropertiesView;
import com.coraltele.db.telephony.pbx.repository.ExtensionPropertiesViewRepository;
import com.coraltele.db.telephony.pbx.specification.ExtensionPropertiesViewSpecification;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.extensionView.model.ExtensionPropertiesViewModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ExtensionPropertiesViewService {
    private static final Logger logger = LogManager.getLogger(ExtensionPropertiesViewService.class);
    @Autowired
    ExtensionPropertiesViewRepository extensionViewRepository;

    public RequestResponse getAllExtensionViewByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionPropertiesViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.extensionViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extensionViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ExtensionPropertiesViewModel> entityToModelConversion(List<ExtensionPropertiesView> extensionView) {
        ArrayList<ExtensionPropertiesViewModel> addValue = new ArrayList<ExtensionPropertiesViewModel>();
        for (ExtensionPropertiesView row : extensionView) {
            ExtensionPropertiesViewModel data = new ExtensionPropertiesViewModel();
            if (row.getDnd() == 1L) {
                data.setDnd("Yes");
            } else {
                data.setDnd("No");
            }
            data.setExtFwdAll(row.getExtFwdAll());
            data.setExtFwdBusy(row.getExtFwdBusy());
            data.setExtFwdNoAns(row.getExtFwdNoAns());
            data.setExtension(row.getExtension());
            data.setExtensionType(row.getExtensionType());
            data.setFwdAll(row.getFwdAll());
            data.setFwdBusy(row.getFwdBusy());
            data.setFwdNoAns(row.getFwdNoAns());
            data.setGroupType(row.getGroupType());
            if (row.getIntercom() == 1L) {
                data.setIntercom("Yes");
            } else {
                data.setIntercom("No");
            }
            if (row.getIsd() == 1L) {
                data.setIsd("Yes");
            } else {
                data.setIsd("No");
            }
            if (row.getLocal() == 1L) {
                data.setLocal("Yes");
            } else {
                data.setLocal("No");
            }
            data.setName(row.getName());
            if (row.getStd() == 1L) {
                data.setStd("Yes");
            } else {
                data.setStd("No");
            }
            if (row.getVm() == 1L) {
                data.setVm("Yes");
            } else {
                data.setVm("No");
            }
            addValue.add(data);
        }
        return addValue;
    }
}

