/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.main.whatsAppHistory.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.coralApps.main.whatsAppHistory.model.AgentMsgModel;
import com.coraltele.service.coralApps.main.whatsAppHistory.model.CustomerMsgModel;
import com.coraltele.service.coralApps.main.whatsAppHistory.service.WhatsAppHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/sendMsg"})
@RestController
public class SendMessageController {
    @Autowired
    WhatsAppHistoryService whatsAppHistoryService;

    @PostMapping(value={"/byCustomer"})
    public ResponseEntity<RequestResponse> sentByCustomer(@RequestBody CustomerMsgModel data) {
        RequestResponse returnValue = this.whatsAppHistoryService.msgByCustomer(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/byAgent"})
    public ResponseEntity<RequestResponse> sendByAgent(@RequestBody AgentMsgModel data) {
        RequestResponse returnValue = this.whatsAppHistoryService.msgByAgent(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/close/{agentId}"})
    public ResponseEntity<RequestResponse> closedById(@PathVariable(value="agentId") String agentId) {
        RequestResponse returnValue = this.whatsAppHistoryService.sessionClose(agentId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

