/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.shift.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.shift.model.ShiftModel;
import com.coraltele.service.coralApps.callcenter.shift.service.ShiftService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/shift"})
public class ShiftController {
    private static final Logger logger = LogManager.getLogger(ShiftController.class);
    @Autowired
    private ShiftService shiftService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createData(@RequestBody ShiftModel data) {
        RequestResponse returnValue = this.shiftService.createShift(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateData(@RequestBody ShiftModel data) {
        RequestResponse returnValue = this.shiftService.updateShift(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.shiftService.deleteShift(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllExtensionView(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.shiftService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("queueTL list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting queueTL list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

