/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.leadSummaryInternalView.service;

import com.coraltele.db.coralapps.callcenter.entity.DialOut;
import com.coraltele.db.coralapps.callcenter.entity.UploadLeadData;
import com.coraltele.db.coralapps.callcenter.entity.view.LeadSummaryView;
import com.coraltele.db.coralapps.callcenter.repository.DialOutRepository;
import com.coraltele.db.coralapps.callcenter.repository.LeadSummaryViewRepository;
import com.coraltele.db.coralapps.callcenter.repository.UploadLeadDataRepository;
import com.coraltele.db.coralapps.callcenter.specification.LeadSummaryViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.leadSummaryInternalView.model.LeadSummaryViewModel;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LeadSummaryViewService {
    private static final Logger logger = LogManager.getLogger(LeadSummaryViewService.class);
    @Autowired
    LeadSummaryViewRepository leadSummaryViewRepository;
    @Autowired
    UploadLeadDataRepository uploadLeadDataRepository;
    @Autowired
    DialOutRepository dialOutRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = LeadSummaryViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.leadSummaryViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.leadSummaryViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateInDialOut(LeadSummaryViewModel data) {
        logger.debug("Update user {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        List uploadLeadDataOptional = this.uploadLeadDataRepository.findByUuid(data.getUniqueLeadUpload());
        if (!uploadLeadDataOptional.isEmpty()) {
            for (UploadLeadData uploadLeadData : uploadLeadDataOptional) {
                Optional dialOutOptional = this.dialOutRepository.findByUploadLeadDataId(uploadLeadData.getId());
                if (dialOutOptional.isPresent()) {
                    DialOut dialOut = (DialOut)dialOutOptional.get();
                    dialOut.setIsDisabled(Boolean.valueOf(true));
                    dialOut.setDeleteLeadMark(Integer.valueOf(1));
                    this.dialOutRepository.save((Object)dialOut);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Cancelled");
                    returnValue.setMessageDetail("Lead Cancelled Successfully");
                    logger.info(returnValue.getMessage());
                    continue;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Update failed");
                returnValue.setMessageDetail("DialOut record not found for the given UploadLeadData ID");
                logger.info(returnValue.getMessageDetail());
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Update failed");
            returnValue.setMessageDetail("UploadLeadData record not found for the given UUID");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public String getFile(String uniqueLeadUpload) {
        Optional list = this.leadSummaryViewRepository.findByUniqueLeadUpload(uniqueLeadUpload);
        if (list.isPresent()) {
            return ((LeadSummaryView)list.get()).getFilepath();
        }
        return null;
    }
}

