/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.cliServices.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.cliServices.services.CliServerCommandServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/commandApproval"})
public class CliServerCommandController {
    @Autowired
    private CliServerCommandServices cliServerCommandServices;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllCommandsToApproveOrReject(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.cliServerCommandServices.getAllApprovalCommands(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/approve"})
    public ResponseEntity<RequestResponse> approveCommand(@RequestBody InputIdModel input) {
        RequestResponse response = this.cliServerCommandServices.approveCommand(input);
        if (response.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)response);
        }
        return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/reject"})
    public ResponseEntity<RequestResponse> rejectCommand(@RequestBody InputIdModel input) {
        RequestResponse response = this.cliServerCommandServices.rejectCommand(input);
        if (response.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)response);
        }
        return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }
}

