/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.systemInfo.model.PortValidatorModel;
import com.coraltele.service.systemInfo.model.SystemInfoModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BashCmd {
    private static final Logger logger = LogManager.getLogger(BashCmd.class);
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    ControlRluServerService controlRluServerService;

    public String executeCommand(String command) {
        StringBuilder output;
        block6: {
            output = new StringBuilder();
            try {
                String line;
                ProcessBuilder pb = new ProcessBuilder("bash", "-c", "sudo " + command);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) {
                        logger.info("Command executed successfully");
                        break block6;
                    }
                    logger.info("Command execution failed with exit code: " + exitCode);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return output.toString();
    }

    public RequestResponse getUptime() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> arrayData = new ArrayList<SystemInfoModel>();
        SystemInfoModel data = new SystemInfoModel();
        try {
            Process process = new ProcessBuilder("uptime").start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = reader.readLine();
            if (output != null) {
                String[] tokens = output.split(" ");
                String uptime = tokens[5] != null || !tokens[5].isEmpty() ? tokens[3] + " " + tokens[4] + " " + tokens[5] : tokens[3] + " " + tokens[4];
                if (uptime.endsWith(",")) {
                    uptime = uptime.substring(0, uptime.length() - 1);
                }
                data.setAttributeName("uptime");
                data.setAttributeValue(uptime);
                data.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data);
                reader.close();
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("data fetched successfully");
                returnValue.setData(arrayData);
                logger.info("up-time command execute successfully");
            }
        }
        catch (IOException e) {
            logger.info(e.getMessage());
            e.printStackTrace();
        }
        return returnValue;
    }

    public RequestResponse getLoadAverages() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> arrayData = new ArrayList<SystemInfoModel>();
        try {
            SystemInfoModel data = new SystemInfoModel();
            Process process = new ProcessBuilder("uptime").start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = reader.readLine();
            if (output != null) {
                String[] tokens = output.split(" ");
                String loadAvg1Min = tokens[tokens.length - 3];
                String loadAvg5Min = tokens[tokens.length - 2];
                String loadAvg15Min = tokens[tokens.length - 1];
                if (loadAvg1Min.endsWith(",")) {
                    loadAvg1Min = loadAvg1Min.substring(0, loadAvg1Min.length() - 1);
                }
                if (loadAvg5Min.endsWith(",")) {
                    loadAvg5Min = loadAvg5Min.substring(0, loadAvg5Min.length() - 1);
                }
                data.setAttributeName("Load Average (1 min)");
                data.setAttributeValue(loadAvg1Min);
                data.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data);
                SystemInfoModel data1 = new SystemInfoModel();
                data1.setAttributeName("Load Average (5 min)");
                data1.setAttributeValue(loadAvg5Min);
                data1.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data1.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data1);
                SystemInfoModel data2 = new SystemInfoModel();
                data2.setAttributeName("Load Average (15 min)");
                data2.setAttributeValue(loadAvg15Min);
                data2.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data2.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data2);
                reader.close();
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("data fetched successfully");
                returnValue.setData(arrayData);
                logger.info("load-average command execute successfully");
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No output from the 'uptime' command");
            }
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while fetching load averages: " + e.getMessage());
            e.printStackTrace();
        }
        return returnValue;
    }

    public RequestResponse getCPUPercentage() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> arrayData = new ArrayList<SystemInfoModel>();
        SystemInfoModel data = new SystemInfoModel();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("top -bn1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("%Cpu(s)")) continue;
                String[] cpuInfo = line.split(",");
                String cpuUsageLine = cpuInfo[0].substring(cpuInfo[0].indexOf(":") + 1).trim();
                String[] cpuUsageParts = cpuUsageLine.split(" ");
                double cpuUsagePercentage = Double.parseDouble(cpuUsageParts[0]);
                data.setAttributeName("CPU Usage Percentage");
                data.setAttributeValue(Double.toString(cpuUsagePercentage));
                data.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data);
                returnValue.setData((Object)data);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("CPU Usage fetched successfully");
                reader.close();
                return returnValue;
            }
            reader.close();
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching CPU Usage: " + e.getMessage());
            logger.error("Error fetching CPU Usage: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getRealMemory() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> arrayData = new ArrayList<SystemInfoModel>();
        try {
            String memLine;
            Process memProcess = Runtime.getRuntime().exec("free -h");
            BufferedReader memReader = new BufferedReader(new InputStreamReader(memProcess.getInputStream()));
            while ((memLine = memReader.readLine()) != null) {
                if (!memLine.startsWith("Mem:")) continue;
                String[] fields = memLine.split("\\s+");
                String totalRealMemory = fields[1].trim();
                String usedRealMemory = fields[2].trim();
                totalRealMemory = totalRealMemory.replace("Gi", "");
                usedRealMemory = usedRealMemory.replace("Gi", "");
                SystemInfoModel data1 = new SystemInfoModel();
                data1.setAttributeName("Total Real Memory (GB)");
                data1.setAttributeValue(totalRealMemory);
                data1.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data1.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data1);
                SystemInfoModel data2 = new SystemInfoModel();
                data2.setAttributeName("Used Real Memory (GB)");
                data2.setAttributeValue(usedRealMemory);
                data2.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data2.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data2);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Real Memory data fetched successfully");
                returnValue.setData(arrayData);
                return returnValue;
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Real Memory data: " + e.getMessage());
            logger.error("Error fetching Real Memory data: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getVirtualMemory() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> arrayData = new ArrayList<SystemInfoModel>();
        try {
            String virtualMemLine;
            Process virtualMemProcess = Runtime.getRuntime().exec("free -h");
            BufferedReader virtualMemReader = new BufferedReader(new InputStreamReader(virtualMemProcess.getInputStream()));
            while ((virtualMemLine = virtualMemReader.readLine()) != null) {
                if (!virtualMemLine.startsWith("Swap:")) continue;
                String[] fields = virtualMemLine.split("\\s+");
                String totalVirtualMemory = fields[1].trim();
                String usedVirtualMemory = fields[2].trim();
                totalVirtualMemory = totalVirtualMemory.replace("Gi", "");
                usedVirtualMemory = usedVirtualMemory.replace("Gi", "");
                SystemInfoModel data1 = new SystemInfoModel();
                data1.setAttributeName("Total Virtual Memory (GB)");
                data1.setAttributeValue(totalVirtualMemory);
                data1.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data1.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data1);
                SystemInfoModel data2 = new SystemInfoModel();
                data2.setAttributeName("Used Virtual Memory (GB)");
                data2.setAttributeValue(usedVirtualMemory);
                data2.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data2.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data2);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Virtual Memory data fetched successfully");
                returnValue.setData(arrayData);
                return returnValue;
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Virtual Memory data: " + e.getMessage());
            logger.error("Error fetching Virtual Memory data: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getTotalRunningProcess() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> arrayData = new ArrayList<SystemInfoModel>();
        SystemInfoModel data = new SystemInfoModel();
        try {
            Process process = Runtime.getRuntime().exec("ps aux");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int processCount = 0;
            while (reader.readLine() != null) {
                ++processCount;
            }
            data.setAttributeName("Total Running Processes");
            data.setAttributeValue(Integer.toString(--processCount));
            data.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            data.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            arrayData.add(data);
            returnValue.setData(arrayData);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Total Running Processes fetched successfully");
            reader.close();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Total Running Processes: " + e.getMessage());
            logger.error("Error fetching Total Running Processes: " + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getDiskSpace() {
        String[] logField;
        String logLine;
        BufferedReader logReader;
        Process logProcess;
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> arrayData = new ArrayList<SystemInfoModel>();
        try {
            String diskLine;
            Process diskProcess = Runtime.getRuntime().exec("df /");
            BufferedReader diskReader = new BufferedReader(new InputStreamReader(diskProcess.getInputStream()));
            while ((diskLine = diskReader.readLine()) != null) {
                if (diskLine.contains("Filesystem")) continue;
                String[] fields = diskLine.split("\\s+");
                long totalDiskSize = this.convertToGB(fields[1]);
                long usedDiskSize = this.convertToGB(fields[2]);
                long freeDiskSize = this.convertToGB(fields[3]);
                SystemInfoModel data2 = new SystemInfoModel();
                data2.setAttributeName("Total Disk Size (GB)");
                data2.setAttributeValue(String.valueOf(totalDiskSize));
                data2.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data2.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data2);
                SystemInfoModel data3 = new SystemInfoModel();
                data3.setAttributeName("Used Disk Size (GB)");
                data3.setAttributeValue(String.valueOf(usedDiskSize));
                data3.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data3.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data3);
                SystemInfoModel data4 = new SystemInfoModel();
                data4.setAttributeName("Free Disk Size (GB)");
                data4.setAttributeValue(String.valueOf(freeDiskSize));
                data4.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data4.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data4);
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Disk Space data: " + e.getMessage());
            logger.error("Error fetching Disk Space data: " + e.getMessage());
            return returnValue;
        }
        try {
            logProcess = Runtime.getRuntime().exec("du -s /var/log");
            logReader = new BufferedReader(new InputStreamReader(logProcess.getInputStream()));
            while ((logLine = logReader.readLine()) != null) {
                logField = logLine.split("\\s+");
                long totalLogSize = this.convertToGB(logField[0]);
                SystemInfoModel data7 = new SystemInfoModel();
                data7.setAttributeName("Total Log Size (GB)");
                data7.setAttributeValue(String.valueOf(totalLogSize));
                data7.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data7.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data7);
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Total Log Size data: " + e.getMessage());
            logger.error("Error fetching Total Log Size data: " + e.getMessage());
        }
        try {
            logProcess = Runtime.getRuntime().exec("du -s /var/log/coralswitch/softswitch");
            logReader = new BufferedReader(new InputStreamReader(logProcess.getInputStream()));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(logProcess.getErrorStream()));
            String errorMsg = errorReader.readLine();
            if (errorMsg != null && !errorMsg.isEmpty()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Error fetching Coral Log Size data: " + errorMsg);
                logger.error("Error fetching Coral Log Size data: " + errorMsg);
            } else {
                String logLine2;
                while ((logLine2 = logReader.readLine()) != null) {
                    String[] logField2 = logLine2.split("\\s+");
                    long totalCoralLogSize = this.convertToGB(logField2[0]);
                    SystemInfoModel data = new SystemInfoModel();
                    data.setAttributeName("Coral Log Size (GB)");
                    data.setAttributeValue(String.valueOf(totalCoralLogSize));
                    data.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                    data.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                    arrayData.add(data);
                }
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Coral Log Size data: " + e.getMessage());
            logger.error("Error fetching Coral Log Size data: " + e.getMessage());
        }
        try {
            logProcess = Runtime.getRuntime().exec("du -s /var/tmp");
            logReader = new BufferedReader(new InputStreamReader(logProcess.getInputStream()));
            while ((logLine = logReader.readLine()) != null) {
                logField = logLine.split("\\s+");
                long totalDumpLogSize = this.convertToGB(logField[0]);
                SystemInfoModel data = new SystemInfoModel();
                data.setAttributeName("Total Dump Size (GB)");
                data.setAttributeValue(String.valueOf(totalDumpLogSize));
                data.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data);
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Total Dump Size data: " + e.getMessage());
            logger.error("Error fetching Total Dump Size data: " + e.getMessage());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Disk Space data fetched successfully");
        returnValue.setData(arrayData);
        return returnValue;
    }

    public RequestResponse getAdditionalInformation() {
        Object data5;
        BufferedReader reader;
        Object process;
        String command;
        BufferedReader reader2;
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> arrayData = new ArrayList<SystemInfoModel>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE, MMMM d, yyyy h:mm a");
        try {
            Process process2 = new ProcessBuilder("uptime", "-p").start();
            BufferedReader reader3 = new BufferedReader(new InputStreamReader(process2.getInputStream()));
            String output = reader3.readLine();
            if (output != null) {
                String uptime = output.replace("up ", "").trim();
                SystemInfoModel uptimeData = new SystemInfoModel();
                uptimeData.setAttributeName("System Uptime");
                uptimeData.setAttributeValue(uptime);
                uptimeData.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                uptimeData.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(uptimeData);
            }
        }
        catch (IOException e) {
            logger.error("Error fetching uptime: " + e.getMessage());
        }
        String formattedDate = dateFormat.format(new Date());
        SystemInfoModel data = new SystemInfoModel();
        data.setAttributeName("Current Date and Time");
        data.setAttributeValue(formattedDate);
        data.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
        data.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
        arrayData.add(data);
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        SystemInfoModel data1 = new SystemInfoModel();
        data1.setAttributeName("Operating System Name");
        data1.setAttributeValue(osName);
        data1.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
        data1.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
        arrayData.add(data1);
        SystemInfoModel data2 = new SystemInfoModel();
        data2.setAttributeName("OS Version");
        data2.setAttributeValue(osVersion);
        data2.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
        data2.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
        arrayData.add(data2);
        try {
            reader2 = new BufferedReader(new FileReader("/etc/os-release"));
            Throwable throwable = null;
            try {
                String line;
                while ((line = reader2.readLine()) != null) {
                    if (line.startsWith("ID=")) {
                        String distName = line.substring(3).replaceAll("\"", "");
                        SystemInfoModel data3 = new SystemInfoModel();
                        data3.setAttributeName("OS Distribution");
                        data3.setAttributeValue(distName);
                        data3.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                        data3.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                        arrayData.add(data3);
                    }
                    if (!line.startsWith("VERSION_ID=")) continue;
                    String distVersion = line.substring(11).replaceAll("\"", "");
                    SystemInfoModel data4 = new SystemInfoModel();
                    data4.setAttributeName("OS Distribution Version");
                    data4.setAttributeValue(distVersion);
                    data4.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                    data4.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                    arrayData.add(data4);
                }
            }
            catch (Throwable line) {
                throwable = line;
                throw line;
            }
            finally {
                if (reader2 != null) {
                    if (throwable != null) {
                        try {
                            reader2.close();
                        }
                        catch (Throwable line) {
                            throwable.addSuppressed(line);
                        }
                    } else {
                        reader2.close();
                    }
                }
            }
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching OS information: " + e.getMessage());
            logger.error("Error fetching OS information: " + e.getMessage());
            return returnValue;
        }
        try {
            command = "dpkg-query -W -f=${Version} coralapplications ";
            process = Runtime.getRuntime().exec(command);
            reader = new BufferedReader(new InputStreamReader(((Process)process).getInputStream()));
            String output = reader.readLine();
            int exitCode = ((Process)process).waitFor();
            if (exitCode == 0) {
                data5 = new SystemInfoModel();
                data5.setAttributeName("Coral Installed Package version");
                data5.setAttributeValue(output);
                data5.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data5.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add((SystemInfoModel)data5);
            } else {
                data5 = new SystemInfoModel();
                data5.setAttributeName("Coral Installed Package version");
                data5.setAttributeValue("");
                data5.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data5.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add((SystemInfoModel)data5);
            }
        }
        catch (IOException | InterruptedException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Coral package version: " + e.getMessage());
            logger.error("Error fetching Coral package version: " + e.getMessage());
        }
        try {
            reader2 = new BufferedReader(new FileReader("/etc/hostname"));
            process = null;
            try {
                String hostname = reader2.readLine().trim();
                SystemInfoModel data6 = new SystemInfoModel();
                data6.setAttributeName("System HostName");
                data6.setAttributeValue(hostname);
                data6.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data6.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data6);
                try {
                    BufferedReader reader1 = new BufferedReader(new FileReader("/etc/hosts"));
                    data5 = null;
                    try {
                        String line;
                        while ((line = reader1.readLine()) != null) {
                            String[] parts = line.trim().split("\\s+");
                            if (parts.length <= 2 || !parts[2].equals(hostname)) continue;
                            SystemInfoModel data8 = new SystemInfoModel();
                            data8.setAttributeName("System IP Address");
                            data8.setAttributeValue(parts[0]);
                            data8.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                            data8.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                            arrayData.add(data8);
                            SystemInfoModel data7 = new SystemInfoModel();
                            data7.setAttributeName("System Mapped Domain Entry");
                            data7.setAttributeValue(parts[1]);
                            data7.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                            data7.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                            arrayData.add(data7);
                        }
                    }
                    catch (Throwable line) {
                        data5 = line;
                        throw line;
                    }
                    finally {
                        if (reader1 != null) {
                            if (data5 != null) {
                                try {
                                    reader1.close();
                                }
                                catch (Throwable line) {
                                    ((Throwable)data5).addSuppressed(line);
                                }
                            } else {
                                reader1.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Error fetching System IP Address and Mapped Domain Entry: " + e.getMessage());
                    logger.error("Error fetching System IP Address and Mapped Domain Entry: " + e.getMessage());
                }
            }
            catch (Throwable hostname) {
                process = hostname;
                throw hostname;
            }
            finally {
                if (reader2 != null) {
                    if (process != null) {
                        try {
                            reader2.close();
                        }
                        catch (Throwable hostname) {
                            ((Throwable)process).addSuppressed(hostname);
                        }
                    } else {
                        reader2.close();
                    }
                }
            }
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching System HostName: " + e.getMessage());
            logger.error("Error fetching System HostName: " + e.getMessage());
        }
        try {
            String line;
            command = "lscpu";
            process = Runtime.getRuntime().exec(command);
            reader = new BufferedReader(new InputStreamReader(((Process)process).getInputStream()));
            String modelName = null;
            String totalCore = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Model name:")) {
                    modelName = line.substring(line.indexOf(58) + 1).trim();
                    SystemInfoModel data9 = new SystemInfoModel();
                    data9.setAttributeName("Model Name");
                    data9.setAttributeValue(modelName);
                    data9.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                    data9.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                    arrayData.add(data9);
                }
                if (!line.startsWith("CPU(s):")) continue;
                totalCore = line.substring(line.indexOf(58) + 1).trim();
                SystemInfoModel data10 = new SystemInfoModel();
                data10.setAttributeName("Total CPU(s)");
                data10.setAttributeValue(totalCore);
                data10.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data10.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data10);
            }
            SystemInfoModel data11 = new SystemInfoModel();
            data11.setAttributeName("Processor Information");
            data11.setAttributeValue(modelName + "," + totalCore + " Cores");
            data11.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            data11.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            arrayData.add(data11);
            reader.close();
            int exitCode = ((Process)process).waitFor();
            if (exitCode != 0) {
                SystemInfoModel data12 = new SystemInfoModel();
                data12.setAttributeName("Processor Information");
                data12.setAttributeValue("");
                data12.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                data12.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                arrayData.add(data12);
            }
        }
        catch (IOException | InterruptedException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Processor Information: " + e.getMessage());
            logger.error("Error fetching Processor Information: " + e.getMessage());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Additional Information fetched successfully");
        returnValue.setData(arrayData);
        return returnValue;
    }

    public RequestResponse ioMonitor() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SystemInfoModel> networkDataList = new ArrayList<SystemInfoModel>();
        try {
            List interfaceList = BashCmd.getPhysicalNetworkInterfaces();
            for (String iface : interfaceList) {
                long incomingTraffic = BashCmd.getNetworkTraffic((String)("/sys/class/net/" + iface + "/statistics/rx_bytes"));
                long outgoingTraffic = BashCmd.getNetworkTraffic((String)("/sys/class/net/" + iface + "/statistics/tx_bytes"));
                SystemInfoModel networkData = new SystemInfoModel();
                networkData.setAttributeName("Interface");
                networkData.setAttributeValue(iface);
                networkData.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                networkData.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                SystemInfoModel incomingData = new SystemInfoModel();
                incomingData.setAttributeName("Total incoming traffic");
                incomingData.setAttributeValue(String.valueOf(incomingTraffic));
                incomingData.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                incomingData.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                SystemInfoModel outgoingData = new SystemInfoModel();
                outgoingData.setAttributeName("Total outgoing traffic");
                outgoingData.setAttributeValue(String.valueOf(outgoingTraffic));
                outgoingData.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                outgoingData.setReceivedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                networkDataList.add(networkData);
                networkDataList.add(incomingData);
                networkDataList.add(outgoingData);
                logger.info(networkData.getAttributeName() + ": " + networkData.getAttributeValue());
                logger.info(incomingData.getAttributeName() + ": " + incomingData.getAttributeValue() + " bytes");
                logger.info(outgoingData.getAttributeName() + ": " + outgoingData.getAttributeValue() + " bytes");
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Network data fetched successfully");
            returnValue.setData(networkDataList);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error while monitoring network data: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while monitoring network data: " + e.getMessage());
        }
        return returnValue;
    }

    private static List<String> getPhysicalNetworkInterfaces() throws IOException {
        String line;
        Process process = Runtime.getRuntime().exec("ls /sys/class/net/");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ArrayList<String> interfaceList = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            File virtualDir = new File("/sys/devices/virtual/net/" + line);
            if (virtualDir.exists()) continue;
            interfaceList.add(line);
        }
        return interfaceList;
    }

    private static long getNetworkTraffic(String filePath) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec("cat " + filePath);
        process.waitFor();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        return Long.parseLong(reader.readLine().trim());
    }

    private long convertToGB(String size) {
        try {
            double bytes = Double.parseDouble(size);
            double gigabytes = bytes / 1048576.0;
            return Math.round(gigabytes);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public RequestResponse portAvailabilityChecker(PortValidatorModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Socket socket = new Socket(data.getIpAddress(), (int)data.getPortNumber());
            socket.close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Port is available");
            logger.info(returnValue.getMessage());
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Port is not available");
            logger.info(returnValue.getMessage());
            logger.error(e.getMessage());
        }
        return returnValue;
    }

    public String dialString(String extNumber) {
        Optional extRecord = this.extensionsRepository.findByExtensionAndExtensionType(extNumber, "phone");
        if (extRecord.isPresent()) {
            Optional rluData;
            Extension extension = (Extension)extRecord.get();
            if (Boolean.TRUE.equals(extension.getSgwUser())) {
                logger.info("dialString for cmd is:{}", (Object)("user/" + extNumber));
                return "user/" + extNumber;
            }
            String rluCode = extension.getRluCode();
            if (StringUtils.hasText((String)rluCode) && (rluData = this.controlRluServerRepository.findByRluCode(rluCode)).isPresent()) {
                return this.formatDialString("internal_" + ((ControlRluServer)rluData.get()).getRluCode(), extNumber, ((ControlRluServer)rluData.get()).getVirtualIp());
            }
        }
        return this.getDefaultDialString(extNumber);
    }

    public String dialString1(String extNumber) {
        Optional extRecord = this.extensionsRepository.findByExtensionAndExtensionType(extNumber, "phone");
        if (extRecord.isPresent()) {
            Extension extension = (Extension)extRecord.get();
            if (Boolean.TRUE.equals(extension.getSgwUser())) {
                logger.info("dialString for cmd is:{}", (Object)("user/" + extNumber));
                return "user/" + extNumber;
            }
            String rluCode = this.controlRluServerService.getRluCodeFinal(extNumber);
            String rluIP = this.controlRluServerService.getVirtualIp(rluCode);
            String featurePort = Constants.FEATURE_USERS_PORT;
            logger.info("rluCode:{},rluIP:{},featurePort:{}", (Object)rluCode, (Object)rluIP, (Object)featurePort);
            if (StringUtils.hasText((String)rluCode)) {
                return this.formatDialString1("internal", extNumber, rluIP, featurePort);
            }
            return this.getDefaultDialString1(extNumber, featurePort);
        }
        return null;
    }

    private String formatDialString1(String rluCode, String extNumber, String ip, String port) {
        logger.info("dialString for cmd is:{}", (Object)("sofia/" + rluCode + "/" + extNumber + "@" + ip + ":" + port));
        return "sofia/" + rluCode + "/" + extNumber + "@" + ip + ":" + port;
    }

    private String formatDialString(String rluCode, String extNumber, String ip) {
        logger.info("dialString for cmd is:{}", (Object)("sofia/" + rluCode + "/" + extNumber + "@" + ip));
        return "sofia/" + rluCode + "/" + extNumber + "@" + ip;
    }

    String getDefaultDialString(String extNumber) {
        List listRluServer = this.controlRluServerRepository.findAllByOrderByIdAsc();
        if (!listRluServer.isEmpty()) {
            ControlRluServer rluServer = (ControlRluServer)listRluServer.get(0);
            return this.formatDialString("internal", extNumber, rluServer.getVirtualIp());
        }
        logger.info("dialString for cmd is:{}", (Object)"blank no any rlu present");
        return "";
    }

    String getDefaultDialString1(String extNumber, String remotePort) {
        List listRluServer = this.controlRluServerRepository.findAllByOrderByIdAsc();
        if (!listRluServer.isEmpty()) {
            ControlRluServer rluServer = (ControlRluServer)listRluServer.get(0);
            logger.info("virtualIp:{}", (Object)rluServer.getVirtualIp());
            return this.formatDialString1("internal", extNumber, rluServer.getVirtualIp(), remotePort);
        }
        logger.info("dialString for cmd is:{}", (Object)"blank no any rlu present");
        return "";
    }

    public String getServerCode() {
        Properties prop = new Properties();
        FileInputStream input = null;
        String serverCode = "";
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        try {
            input = new FileInputStream(fileName);
            prop.load(input);
            if (prop.getProperty("servercode") != null && prop.getProperty("servercode").length() > 0) {
                serverCode = prop.getProperty("servercode");
                logger.info("server code for recording:{}", (Object)serverCode);
            }
        }
        catch (Exception e) {
            logger.error("Unable to find ServerCode");
        }
        return serverCode.trim();
    }

    public String getIpFromDomainName(String domainName) {
        try {
            InetAddress inetAddress = InetAddress.getByName(domainName);
            String ipAddress = inetAddress.getHostAddress();
            return ipAddress;
        }
        catch (UnknownHostException e) {
            logger.error("Cannot resolve domain name: " + e.getMessage());
            return "";
        }
    }
}

