/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.billing.main.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import lombok.Generated;
import org.springframework.util.StringUtils;

@Entity
@Table(name="t_userstatus")
public class AgentStatus {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    private String username;
    private String status;
    @Column(name="curr_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime currentTime;
    @Column(name="previous_time")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime previousTime;
    private String shift;
    private UUID uuid;
    @Column(name="extensionno")
    private String extensionNo;
    @Column(name="userfullname")
    private String userFullname;
    @Column(name="showinreport", columnDefinition="VARCHAR(1) DEFAULT 'Y'")
    private String showInReport;
    @Column(name="curr_timeepoch")
    private Long currentTimeEpoch;
    @Column(name="previous_timeepoch")
    private Long previousTimeEpoch;
    @Column(name="isdatasynced", columnDefinition="int default 0")
    private Integer isDataSynced;
    @Column(name="callcenter_version", columnDefinition="VARCHAR(255) DEFAULT 'N'")
    private String callCenterVersion;

    @PrePersist
    private void setValue() {
        if (this.isDataSynced == null) {
            this.isDataSynced = 0;
        }
        if (!StringUtils.hasText((String)this.callCenterVersion)) {
            this.callCenterVersion = "N";
        }
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public LocalDateTime getCurrentTime() {
        return this.currentTime;
    }

    @Generated
    public LocalDateTime getPreviousTime() {
        return this.previousTime;
    }

    @Generated
    public String getShift() {
        return this.shift;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getExtensionNo() {
        return this.extensionNo;
    }

    @Generated
    public String getUserFullname() {
        return this.userFullname;
    }

    @Generated
    public String getShowInReport() {
        return this.showInReport;
    }

    @Generated
    public Long getCurrentTimeEpoch() {
        return this.currentTimeEpoch;
    }

    @Generated
    public Long getPreviousTimeEpoch() {
        return this.previousTimeEpoch;
    }

    @Generated
    public Integer getIsDataSynced() {
        return this.isDataSynced;
    }

    @Generated
    public String getCallCenterVersion() {
        return this.callCenterVersion;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setCurrentTime(LocalDateTime currentTime) {
        this.currentTime = currentTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setPreviousTime(LocalDateTime previousTime) {
        this.previousTime = previousTime;
    }

    @Generated
    public void setShift(String shift) {
        this.shift = shift;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setExtensionNo(String extensionNo) {
        this.extensionNo = extensionNo;
    }

    @Generated
    public void setUserFullname(String userFullname) {
        this.userFullname = userFullname;
    }

    @Generated
    public void setShowInReport(String showInReport) {
        this.showInReport = showInReport;
    }

    @Generated
    public void setCurrentTimeEpoch(Long currentTimeEpoch) {
        this.currentTimeEpoch = currentTimeEpoch;
    }

    @Generated
    public void setPreviousTimeEpoch(Long previousTimeEpoch) {
        this.previousTimeEpoch = previousTimeEpoch;
    }

    @Generated
    public void setIsDataSynced(Integer isDataSynced) {
        this.isDataSynced = isDataSynced;
    }

    @Generated
    public void setCallCenterVersion(String callCenterVersion) {
        this.callCenterVersion = callCenterVersion;
    }

    @Generated
    public AgentStatus() {
    }

    @Generated
    public AgentStatus(Integer id, String username, String status, LocalDateTime currentTime, LocalDateTime previousTime, String shift, UUID uuid, String extensionNo, String userFullname, String showInReport, Long currentTimeEpoch, Long previousTimeEpoch, Integer isDataSynced, String callCenterVersion) {
        this.id = id;
        this.username = username;
        this.status = status;
        this.currentTime = currentTime;
        this.previousTime = previousTime;
        this.shift = shift;
        this.uuid = uuid;
        this.extensionNo = extensionNo;
        this.userFullname = userFullname;
        this.showInReport = showInReport;
        this.currentTimeEpoch = currentTimeEpoch;
        this.previousTimeEpoch = previousTimeEpoch;
        this.isDataSynced = isDataSynced;
        this.callCenterVersion = callCenterVersion;
    }
}

