/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.CLIServerCommandLogRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.telephony.uc.entity.CustomerAccount;
import com.coraltele.db.telephony.uc.repository.CustomerAccountRepository;
import com.coraltele.db.telephony.uc.specification.CustomerAccountSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.messaging.MessagingService;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.extension_service.service.ExtensionsServicesService;
import com.coraltele.service.uc.model.CustomerAccountModel;
import com.coraltele.service.uc.model.CustomerAccountProfileModel;
import com.coraltele.service.uc.model.CustomerAccountServiceCode;
import com.coraltele.service.uc.model.UserStatusModel;
import com.coraltele.service.uc.model.search.CustomerAccountSearchRequest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CustomerAccountService {
    private static final Logger logger = LogManager.getLogger(CustomerAccountService.class);
    @Autowired
    CustomerAccountRepository customerAccountRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    ExtensionsServicesRepository ExtensionsServicesRepository;
    @Autowired
    private ExtensionsServicesService extensionsServicesService;
    @Autowired
    UserRepository userRepository;
    @Autowired
    MessagingService messagingService;
    @Autowired
    CLIServerCommandLogRepository cLIServerCommandLogRepository;
    @Autowired
    BashCmd bashCmd;
    private static long lastAccessTime = 0L;

    public RequestResponse create(CustomerAccountServiceCode data, Principal authentication) {
        String phoneNumber = data.getCustomerAccount().getExtension().toString();
        RequestResponse returnValue = new RequestResponse();
        Optional extension = this.extensionsRepository.findByExtensionAndExtensionType(phoneNumber, "phone");
        if (extension.isPresent()) {
            String checkAvailExt = ((Extension)extension.get()).getAssignedUser();
            if (checkAvailExt == null || !StringUtils.hasLength((String)checkAvailExt)) {
                Optional customer = this.customerAccountRepository.findByExtension(Long.valueOf(Long.parseLong(((Extension)extension.get()).getExtension())));
                if (!customer.isPresent()) {
                    Optional extensionData;
                    Optional userData;
                    CustomerAccount customerAccount = new CustomerAccount();
                    customerAccount.setIsDisabled(data.getCustomerAccount().getIsDisabled());
                    customerAccount.setExtension(Long.valueOf(Long.parseLong(((Extension)extension.get()).getExtension())));
                    customerAccount.setCreatedOn(LocalDateTime.now());
                    customerAccount.setProfilePicUrl(data.getCustomerAccount().getProfilePicUrl());
                    customerAccount.setCompany(data.getCustomerAccount().getCompany());
                    customerAccount.setDesignation(data.getCustomerAccount().getDesignation());
                    customerAccount.setServiceType(data.getCustomerAccount().getServiceType());
                    customerAccount.setDistrictId(data.getCustomerAccount().getDistrictId());
                    customerAccount.setCityId(data.getCustomerAccount().getCityId());
                    customerAccount.setStateId(data.getCustomerAccount().getStateId());
                    customerAccount.setCountryId(data.getCustomerAccount().getCountryId());
                    customerAccount.setMobileNumber(data.getCustomerAccount().getMobileNumber());
                    customerAccount.setFaxNumber(data.getCustomerAccount().getFaxNumber());
                    customerAccount.setPhoneHome(data.getCustomerAccount().getPhoneHome());
                    customerAccount.setPhoneOffice(data.getCustomerAccount().getPhoneOffice());
                    customerAccount.setEmailId(data.getCustomerAccount().getEmailId());
                    customerAccount.setFirstName(data.getCustomerAccount().getFirstName());
                    customerAccount.setLastName(data.getCustomerAccount().getLastName());
                    customerAccount.setZipPostalCode(data.getCustomerAccount().getZipPostalCode());
                    customerAccount.setAddressOne(data.getCustomerAccount().getAddressOne());
                    customerAccount.setAddressTwo(data.getCustomerAccount().getAddressTwo());
                    customerAccount.setAccountNo(data.getCustomerAccount().getAccountNo());
                    customerAccount.setProfileId(authentication.getName());
                    customerAccount.setDescription(data.getCustomerAccount().getDescription());
                    customerAccount.setStatus(data.getCustomerAccount().getStatus());
                    this.customerAccountRepository.save((Object)customerAccount);
                    int i = customerAccount.getExtension().intValue();
                    if (data.getExtensionRange() != null) {
                        this.extensionsServicesService.deleteAllExtension(String.valueOf(i));
                        this.extensionsServicesService.createSingleExtensionService(data.getExtensionRange(), i);
                    }
                    if ((userData = this.userRepository.findByUsername(authentication.getName())).isPresent()) {
                        ((User)userData.get()).setContactNo(data.getCustomerAccount().getExtension().toString());
                        this.userRepository.save(userData.get());
                    }
                    if ((extensionData = this.extensionsRepository.findByExtension(data.getCustomerAccount().getExtension().toString())).isPresent()) {
                        ((Extension)extensionData.get()).setAssignedUser(authentication.getName());
                        this.extensionsRepository.save(extensionData.get());
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("CustomerAccount  created");
                    returnValue.setMessageDetail("created successfully");
                    logger.info(returnValue.getMessage());
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Customer already exist of this extension");
                    logger.info(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Selected extension already have assigned user");
                returnValue.setMessageDetail("Select different extension");
                logger.info(returnValue.getMessage());
            }
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("selected extension not having extensionType 'phone' ");
            returnValue.setMessageDetail("please enter different extension");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateNew(CustomerAccountServiceCode data, Principal authentication) {
        String oldFaxNo;
        String phoneNumber = data.getCustomerAccount().getExtension() != null ? data.getCustomerAccount().getExtension().toString() : null;
        String faxNumber = data.getCustomerAccount().getFaxNumber() != null ? data.getCustomerAccount().getFaxNumber().toString() : null;
        RequestResponse returnValue = new RequestResponse();
        Optional customerAccountOpt = this.customerAccountRepository.findById((Object)data.getCustomerAccount().getId());
        if (!customerAccountOpt.isPresent()) {
            returnValue = this.create(data, authentication);
            this.logResponse(returnValue);
            return returnValue;
        }
        CustomerAccount existingAccount = (CustomerAccount)customerAccountOpt.get();
        String oldExtNo = existingAccount.getExtension() != null ? existingAccount.getExtension().toString() : null;
        String string = oldFaxNo = existingAccount.getFaxNumber() != null ? existingAccount.getFaxNumber().toString() : null;
        if (phoneNumber != null && !phoneNumber.equals(oldExtNo)) {
            Optional phoneExtensionOpt = this.extensionsRepository.findByExtensionAndExtensionType(phoneNumber, "phone");
            if (!phoneExtensionOpt.isPresent()) {
                return this.buildErrorResponse(Constants.Error.ERROR, "Extension not having extensionType 'phone'", "Please enter a different extension");
            }
            Extension phoneExtension = (Extension)phoneExtensionOpt.get();
            if (StringUtils.hasText((String)phoneExtension.getAssignedUser())) {
                return this.buildErrorResponse(Constants.Error.ERROR, "Selected extension already has an assigned user", "Select a different extension");
            }
        }
        this.updateCustomerAccount(existingAccount, data);
        this.handleExtensionAndFaxUpdates(existingAccount, phoneNumber, faxNumber, oldExtNo, oldFaxNo, authentication);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("CustomerAccount updated");
        returnValue.setMessageDetail("Updated successfully");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    private RequestResponse handleExtensionAndFaxUpdates(CustomerAccount account, String phoneNumber, String faxNumber, String oldExtNo, String oldFaxNo, Principal authentication) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Extension and Fax updated successfully");
        returnValue.setMessageDetail("Updates completed successfully");
        Optional userData = this.userRepository.findByUsername(authentication.getName());
        if (userData.isPresent()) {
            ((User)userData.get()).setContactNo(phoneNumber);
            this.userRepository.save(userData.get());
        }
        if (phoneNumber != null && !phoneNumber.equals(oldExtNo)) {
            Optional phoneExtensionOpt = this.extensionsRepository.findByExtension(phoneNumber);
            if (phoneExtensionOpt.isPresent()) {
                Extension extension = (Extension)phoneExtensionOpt.get();
                if (!StringUtils.hasText((String)extension.getAssignedUser())) {
                    extension.setAssignedUser(authentication.getName());
                    this.extensionsRepository.save((Object)extension);
                } else {
                    logger.warn("Extension {} is already assigned to another user. Update skipped.", (Object)phoneNumber);
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Extension already assigned");
                    returnValue.setMessageDetail(String.format("Extension %s is already assigned to another user. Update skipped.", phoneNumber));
                    return returnValue;
                }
            }
            if (StringUtils.hasText((String)oldExtNo)) {
                this.extensionsRepository.findByExtension(oldExtNo).ifPresent(oldExtension -> {
                    oldExtension.setAssignedUser(null);
                    this.extensionsRepository.save(oldExtension);
                });
            }
        }
        if (faxNumber != null && !faxNumber.equals(oldFaxNo)) {
            Optional faxExtensionOpt = this.extensionsRepository.findByExtension(faxNumber);
            if (faxExtensionOpt.isPresent()) {
                Extension fax = (Extension)faxExtensionOpt.get();
                if (!StringUtils.hasText((String)fax.getAssignedUser())) {
                    this.updateUserOfFax(faxNumber, authentication.getName());
                } else {
                    logger.warn("Fax {} is already assigned to another user. Update skipped.", (Object)faxNumber);
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Fax already assigned");
                    returnValue.setMessageDetail(String.format("Fax %s is already assigned to another user. Update skipped.", faxNumber));
                    return returnValue;
                }
            }
            if (StringUtils.hasText((String)oldFaxNo)) {
                this.extensionsRepository.findByExtension(oldFaxNo).ifPresent(oldFax -> {
                    oldFax.setAssignedUser(null);
                    this.extensionsRepository.save(oldFax);
                });
            }
        }
        return returnValue;
    }

    private void updateCustomerAccount(CustomerAccount existingAccount, CustomerAccountServiceCode data) {
        CustomerAccountModel newAccountData = data.getCustomerAccount();
        if (newAccountData.getIsDisabled() != null) {
            existingAccount.setIsDisabled(newAccountData.getIsDisabled());
        }
        if (newAccountData.getPhoneOffice() != null) {
            existingAccount.setPhoneOffice(newAccountData.getPhoneOffice());
        }
        if (newAccountData.getEmailId() != null) {
            existingAccount.setEmailId(newAccountData.getEmailId());
        }
        if (newAccountData.getFirstName() != null) {
            existingAccount.setFirstName(newAccountData.getFirstName());
        }
        if (newAccountData.getLastName() != null) {
            existingAccount.setLastName(newAccountData.getLastName());
        }
        if (newAccountData.getZipPostalCode() != null) {
            existingAccount.setZipPostalCode(newAccountData.getZipPostalCode());
        }
        if (newAccountData.getAddressOne() != null) {
            existingAccount.setAddressOne(newAccountData.getAddressOne());
        }
        if (newAccountData.getAddressTwo() != null) {
            existingAccount.setAddressTwo(newAccountData.getAddressTwo());
        }
        if (newAccountData.getAccountNo() != null) {
            existingAccount.setAccountNo(newAccountData.getAccountNo());
        }
        if (newAccountData.getDescription() != null) {
            existingAccount.setDescription(newAccountData.getDescription());
        }
        if (newAccountData.getPhoneHome() != null) {
            existingAccount.setPhoneHome(newAccountData.getPhoneHome());
        }
        if (newAccountData.getFaxNumber() != null) {
            existingAccount.setFaxNumber(newAccountData.getFaxNumber());
        }
        if (newAccountData.getMobileNumber() != null) {
            existingAccount.setMobileNumber(newAccountData.getMobileNumber());
        }
        if (newAccountData.getCountryId() != null) {
            existingAccount.setCountryId(newAccountData.getCountryId());
        }
        if (newAccountData.getStateId() != null) {
            existingAccount.setStateId(newAccountData.getStateId());
        }
        if (newAccountData.getCityId() != null) {
            existingAccount.setCityId(newAccountData.getCityId());
        }
        if (newAccountData.getDistrictId() != null) {
            existingAccount.setDistrictId(newAccountData.getDistrictId());
        }
        if (newAccountData.getServiceType() != null) {
            existingAccount.setServiceType(newAccountData.getServiceType());
        }
        if (newAccountData.getDesignation() != null) {
            existingAccount.setDesignation(newAccountData.getDesignation());
        }
        if (newAccountData.getCompany() != null) {
            existingAccount.setCompany(newAccountData.getCompany());
        }
        if (newAccountData.getProfilePicUrl() != null) {
            existingAccount.setProfilePicUrl(newAccountData.getProfilePicUrl());
        }
        if (newAccountData.getStatus() != null) {
            existingAccount.setStatus(newAccountData.getStatus());
        }
        existingAccount.setExtension(newAccountData.getExtension());
        existingAccount.setUpdatedOn(LocalDateTime.now());
        this.customerAccountRepository.save((Object)existingAccount);
        int i = existingAccount.getExtension().intValue();
        if (data.getExtensionRange() != null) {
            this.extensionsServicesService.createSingleExtensionService2(data.getExtensionRange(), i);
        }
    }

    private RequestResponse buildErrorResponse(Constants.Error status, String message, String messageDetail) {
        RequestResponse response = new RequestResponse();
        response.setStatus(status);
        response.setMessage(message);
        response.setMessageDetail(messageDetail);
        logger.info(message);
        return response;
    }

    private void logResponse(RequestResponse response) {
        logger.info("Status: {}, Message: {}, Detail: {}", (Object)response.getStatus(), (Object)response.getMessage(), (Object)response.getMessageDetail());
    }

    public void updateExtensionFax(String newFax, String assignedUser) {
        Optional extension = this.extensionsRepository.findByAssignedUserAndExtensionType(assignedUser, "softfax");
        if (extension.isPresent()) {
            ((Extension)extension.get()).setExtension(newFax);
            this.extensionsRepository.save(extension.get());
        }
    }

    public void updateUserOfFax(String newFax, String assignedUser) {
        Optional extension = this.extensionsRepository.findByExtension(newFax);
        if (extension.isPresent()) {
            ((Extension)extension.get()).setAssignedUser(assignedUser);
            this.extensionsRepository.save(extension.get());
        }
    }

    public RequestResponse getList(CustomerAccountSearchRequest searchRequestData, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CustomerAccountSpecification.generateFilters((CustomerAccountSearchRequest)searchRequestData, (String)authentication.getName());
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.customerAccountRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.customerAccountRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("filtered list");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getByLoggedInUser(String userName) {
        RequestResponse returnValue = new RequestResponse();
        Optional data = this.customerAccountRepository.findByProfileId(userName);
        if (data.isPresent()) {
            CustomerAccount customerAccount = (CustomerAccount)data.get();
            CustomerAccountServiceCode returnData = new CustomerAccountServiceCode();
            CustomerAccountModel modelData = new CustomerAccountModel();
            modelData.setId(customerAccount.getId());
            modelData.setCreatedBy(customerAccount.getCreatedBy());
            modelData.setIsDisabled(customerAccount.getIsDisabled());
            modelData.setExtension(customerAccount.getExtension());
            modelData.setCreatedOn(customerAccount.getCreatedOn());
            modelData.setUpdatedOn(customerAccount.getUpdatedOn());
            modelData.setProfilePicUrl(customerAccount.getProfilePicUrl());
            modelData.setCompany(customerAccount.getCompany());
            modelData.setDesignation(customerAccount.getDesignation());
            modelData.setServiceType(customerAccount.getServiceType());
            modelData.setDistrictId(customerAccount.getDistrictId());
            modelData.setCityId(customerAccount.getCityId());
            modelData.setStateId(customerAccount.getStateId());
            modelData.setCountryId(customerAccount.getCountryId());
            modelData.setMobileNumber(customerAccount.getMobileNumber());
            modelData.setFaxNumber(customerAccount.getFaxNumber());
            modelData.setPhoneHome(customerAccount.getPhoneHome());
            modelData.setPhoneOffice(customerAccount.getPhoneOffice());
            modelData.setEmailId(customerAccount.getEmailId());
            modelData.setLastName(customerAccount.getLastName());
            modelData.setFirstName(customerAccount.getFirstName());
            modelData.setZipPostalCode(customerAccount.getZipPostalCode());
            modelData.setAddressOne(customerAccount.getAddressOne());
            modelData.setAddressTwo(customerAccount.getAddressTwo());
            modelData.setAccountNo(customerAccount.getAccountNo());
            modelData.setProfileId(customerAccount.getProfileId());
            modelData.setDescription(customerAccount.getDescription());
            modelData.setStatus(customerAccount.getStatus());
            returnData.setCustomerAccount(modelData);
            returnData.setServiceCodeModel(this.extensionsServicesService.getCheckedServiceCode(Long.toString(customerAccount.getExtension())));
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List of Data:");
            returnValue.setData((Object)returnData);
            logger.info(returnValue.getMessage());
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to return data");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getUnLoggedUser(String userName, String extensionType) {
        RequestResponse returnValue = new RequestResponse();
        List list = this.extensionsRepository.findByExtensionType(extensionType);
        ArrayList<CustomerAccountProfileModel> addValue = new ArrayList<CustomerAccountProfileModel>();
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not found");
            returnValue.setMessageDetail("Unable to return data");
            logger.info(returnValue.getMessage());
        } else {
            for (Extension row : list) {
                if (row.getAssignedUser() == null || row.getAssignedUser().equals(userName)) continue;
                CustomerAccountProfileModel data = new CustomerAccountProfileModel();
                data.setProfileId(row.getAssignedUser());
                data.setExtension(row.getExtension());
                data.setId(row.getId());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Found");
            returnValue.setMessageDetail("List of Data");
            returnValue.setData(addValue);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateUserStatus(UserStatusModel data) {
        logger.debug("update userStatus:{}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional profileId = this.customerAccountRepository.findByProfileId(data.getUsername());
        if (!profileId.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("username not found to update user status");
            logger.error(returnValue.getMessageDetail());
        } else {
            if (data.getUserStatus() != null) {
                ((CustomerAccount)profileId.get()).setUserStatus(data.getUserStatus());
            }
            this.customerAccountRepository.save(profileId.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("updated");
            returnValue.setMessageDetail("userStatus updated successfully");
            logger.info(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public CustomerAccount getCustomData(Authentication authentication) {
        Optional data = this.customerAccountRepository.findByProfileId(authentication.getName());
        if (data.isPresent()) {
            return (CustomerAccount)data.get();
        }
        return null;
    }

    public RequestResponse userExist(Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        Optional data = this.customerAccountRepository.findByProfileId(authentication.getName());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (data.isPresent()) {
            map.put("id", 1);
            map.put("profileStatus", 0);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("profile already saved");
            returnValue.setData(map);
            logger.info(returnValue.getMessage());
        } else {
            map.put("id", 1);
            map.put("profileStatus", 1);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("profile not saved");
            returnValue.setMessageDetail("first save the profile");
            returnValue.setData(map);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public String getEmail(String email) {
        Optional data = this.customerAccountRepository.findByEmailId(email);
        if (data.isPresent()) {
            return ((CustomerAccount)data.get()).getEmailId();
        }
        return null;
    }

    public String getProfileId(String email) {
        Optional data = this.customerAccountRepository.findByEmailId(email);
        if (data.isPresent()) {
            return ((CustomerAccount)data.get()).getProfileId();
        }
        return null;
    }

    protected String encryptCliServiceContains(String keyvalue) {
        String rtrVal = "";
        if (!keyvalue.isEmpty()) {
            String privatekey;
            MessageDigest sha = null;
            String passwordkey = privatekey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
            try {
                byte[] key = passwordkey.getBytes("UTF-8");
                sha = MessageDigest.getInstance("SHA-1");
                key = sha.digest(key);
                key = Arrays.copyOf(key, 16);
                SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, secretKey);
                byte[] rtv = cipher.doFinal(keyvalue.getBytes("UTF-8"));
                rtrVal = Base64.getEncoder().encodeToString(rtv);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return rtrVal;
    }

    public synchronized void cliServerCommandLog2(CLIServerCommandLog cliServerCommandLog) {
        try {
            long currentTime = System.currentTimeMillis();
            if (currentTime == lastAccessTime) {
                Thread.sleep(1L);
                logger.info("Time conflict comes but handled");
            }
            lastAccessTime = System.currentTimeMillis();
            String ip = CustomerAccountService.getLocalIPAddress();
            Long epochValue = lastAccessTime;
            String serverCode = this.bashCmd.getServerCode();
            String fileName = epochValue + "-" + serverCode;
            CLIServerCommandLog cliServerCommandLog2 = new CLIServerCommandLog();
            cliServerCommandLog2.setRecordCreatedBy(CustomerAccountService.getCurrentUsername());
            cliServerCommandLog2.setOutputFileName(fileName);
            cliServerCommandLog2.setOutputFilePath("");
            cliServerCommandLog2.setCLICommand(this.encryptCliServiceContains(cliServerCommandLog.getCLICommand()));
            cliServerCommandLog2.setServerCode(serverCode);
            cliServerCommandLog2.setCommandExecutedByClientIP(ip);
            cliServerCommandLog2.setCommandExecutedOnServerIP(ip);
            cliServerCommandLog2.setRemarks("");
            this.cLIServerCommandLogRepository.save((Object)cliServerCommandLog2);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println("Thread was interrupted: " + e.getMessage());
        }
    }

    public static String getCurrentUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return authentication.getName();
        }
        return null;
    }

    public static String getLocalIPAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean getClickToCall() {
        String coralFilePath = "/etc/default/coral";
        try {
            Profile.Section cluster;
            Ini ini;
            File file = new File(coralFilePath);
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CLUSTER") && (cluster = (Profile.Section)ini.get((Object)"CLUSTER")).containsKey((Object)"IS-DATA-SYNC")) {
                String value = ((String)cluster.get((Object)"IS-DATA-SYNC")).trim();
                return value.equalsIgnoreCase("true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

