/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.lastNAgentCDR.service;

import com.coraltele.db.telemetry.main.entity.LastNAgentCDR;
import com.coraltele.db.telemetry.main.repository.LastNAgentCDRRepository;
import com.coraltele.db.telemetry.main.specification.LastNAgentCDRSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.lastNAgentCDR.model.LastNAgentCDRModel;
import com.coraltele.service.telemetry.main.lastNAgentCDR.service.LastNAgentCDRPdf;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LastNAgentCDRService {
    private static final Logger logger = LogManager.getLogger(LastNAgentCDRPdf.class);
    @Autowired
    LastNAgentCDRRepository lastNAgentCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = LastNAgentCDRSpecification.generateFilters((SearchRequest)searchRequestData, (Principal)principal);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "agentName" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "agentName" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.lastNAgentCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.lastNAgentCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<LastNAgentCDRModel> entityToModelConversion(List<LastNAgentCDR> lastAgent) {
        ArrayList<LastNAgentCDRModel> addValue = new ArrayList<LastNAgentCDRModel>();
        for (LastNAgentCDR row : lastAgent) {
            LastNAgentCDRModel data = new LastNAgentCDRModel();
            data.setUuid(row.getUuid());
            if (row.getAnswerTime() != null) {
                data.setAnswerTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerTime()));
            }
            data.setBridgeUUID(row.getBridgeUUID());
            data.setCallId(row.getCallId());
            if (row.getEndTime() != null) {
                data.setEndTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getEndTime()));
            }
            data.setLeadName(row.getLeadName());
            data.setPulse(row.getPulse());
            data.setPulseRate(row.getPulseRate());
            data.setQueue(row.getQueue());
            data.setQueueType(row.getQueueType());
            data.setRecordGroup(row.getRecordGroup());
            data.setRecordType(row.getRecordType());
            data.setRecordingFile(row.getRecordingFile());
            data.setSecond10(row.getSecond10());
            data.setSecond20(row.getSecond20());
            data.setSecond30(row.getSecond30());
            data.setSecond40(row.getSecond40());
            data.setSecond50(row.getSecond50());
            data.setSecond60(row.getSecond60());
            data.setAgentName(row.getAgentName());
            data.setCampaignName(row.getCampaignName());
            data.setCustomerNumber(row.getCustomerNumber());
            data.setHangupCause(row.getHangupCause());
            data.setQueueName(row.getQueueName());
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getStartTime()));
            }
            if (row.getTalkDuration() != null) {
                data.setTalkDuration(row.getTalkDuration());
            }
            data.setCallDirection(row.getCallDirection());
            data.setCost(row.getCost());
            data.setFullName(row.getFullName());
            if (row.getIsMissed() != null) {
                data.setIsMissed(row.getIsMissed());
            } else {
                data.setIsMissed(Boolean.valueOf(false));
            }
            data.setAgentTalkedTo(row.getAgentTalkedTo());
            addValue.add(data);
        }
        return addValue;
    }

    public String getFile(String uuid) {
        Optional list = this.lastNAgentCDRRepository.findById((Object)uuid);
        if (list.isPresent()) {
            return ((LastNAgentCDR)list.get()).getRecordingFile();
        }
        return null;
    }
}

