/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.extensionCDRDetal.service;

import com.coraltele.db.telemetry.main.entity.BillingCDR;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.specification.ExtensionCDRSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.extensionCDRDetal.model.ExtensionCDRModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ExtensonCDRService {
    private static final Logger logger = LogManager.getLogger(ExtensonCDRService.class);
    @Autowired
    BillingCDRRepository billingCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionCDRSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.billingCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.billingCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ExtensionCDRModel> entityToModelConversion(List<BillingCDR> billingCDR) {
        ArrayList<ExtensionCDRModel> addValue = new ArrayList<ExtensionCDRModel>();
        for (BillingCDR row : billingCDR) {
            ExtensionCDRModel data = new ExtensionCDRModel();
            data.setAnswerEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerEpoch()));
            if (row.getCallConnected() != null) {
                if (row.getCallConnected().booleanValue()) {
                    data.setCallConnected("Yes");
                } else {
                    data.setCallConnected("No");
                }
            } else {
                data.setCallConnected("No");
            }
            data.setCallerIdNumber(row.getCallerIdNumber());
            data.setCoralCallDirection("INT");
            data.setDestinationNumber(row.getDestinationNumber());
            data.setDuration(DateFormatUtility.findLocalTime((Long)row.getDuration()));
            data.setEndEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getEndEpoch()));
            data.setId(row.getId());
            data.setStartEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getStartEpoch()));
            data.setStartDate((Object)this.dateFormatUtility.epochToLocalDate(row.getStartEpoch()));
            if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                data.setMos(BigDecimal.valueOf(4.3));
            } else {
                data.setMos(row.getMos());
            }
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration()));
            data.setCallerName(row.getCallerName());
            data.setDestinationName(row.getDestinationName());
            data.setDIDNumber(row.getDIDNumber());
            data.setDODNumber(row.getDODNumber());
            data.setCallType("INTERCOM");
            data.setDuration(row.getDuration().toString());
            data.setCoralFeatureCode(row.getCoralFeatureCode());
            addValue.add(data);
        }
        return addValue;
    }
}

