/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentPerformanceSummary.service;

import com.coraltele.db.telemetry.main.entity.AgentPerformanceSummary;
import com.coraltele.db.telemetry.main.repository.AgentPerformanceSummaryRepository;
import com.coraltele.db.telemetry.main.specification.AgentPerformanceSummarySpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.model.DailyPerformanceReportModel;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AgentPerformanceSummaryService {
    private static final Logger logger = LogManager.getLogger(AgentPerformanceSummaryService.class);
    @Autowired
    AgentPerformanceSummaryRepository agentPerformanceSummaryRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;

    public RequestResponse getAllByFilterForDailyPerformanceOfSummary(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean teamLeaderUser = false;
        boolean managerUser = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        } else if (this.userService.checkManagerUser(principal.getName())) {
            managerUser = true;
        }
        Specification filters = AgentPerformanceSummarySpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
        Sort sort = "asc".equalsIgnoreCase(searchRequestData.getSortDirection()) ? Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "totalAnswered" : searchRequestData.getSortBy()}).ascending() : ("desc".equalsIgnoreCase(searchRequestData.getSortDirection()) ? Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "totalAnswered" : searchRequestData.getSortBy()}).descending() : Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "totalAnswered" : searchRequestData.getSortBy()}).descending());
        List allFilteredData = this.agentPerformanceSummaryRepository.findAll(filters, sort);
        List allUniqueRecords = this.entityToModelConversionForDailyPerformance(allFilteredData, searchRequestData.getSortDirection());
        List summarizedData = this.groupAndSummarizeAgentData(allUniqueRecords);
        if (searchRequestData.getSortDirection() != null && !searchRequestData.getSortDirection().isEmpty()) {
            if ("asc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
                summarizedData.sort(Comparator.comparing(DailyPerformanceReportModel::getAgentName));
            } else if ("desc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
                summarizedData.sort(Comparator.comparing(DailyPerformanceReportModel::getAgentName).reversed());
            } else {
                summarizedData.sort(Comparator.comparing(DailyPerformanceReportModel::getAgentName));
            }
        } else {
            summarizedData.sort(Comparator.comparing(DailyPerformanceReportModel::getAgentName));
        }
        int totalUniqueRecords = summarizedData.size();
        int pageSize = searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize();
        int currentPage = searchRequestData.getCurrentPage();
        int startItem = currentPage * pageSize;
        int toIndex = Math.min(startItem + pageSize, totalUniqueRecords);
        List paginatedList = startItem < totalUniqueRecords ? summarizedData.subList(startItem, toIndex) : new ArrayList();
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(currentPage > totalUniqueRecords / pageSize ? 0L : (long)currentPage);
        responseData.setPageSize((long)pageSize);
        responseData.setTotalPages((long)((int)Math.ceil((double)totalUniqueRecords / (double)pageSize)));
        responseData.setTotalRecords((long)totalUniqueRecords);
        responseData.setCurrentPageData(paginatedList);
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<DailyPerformanceReportModel> entityToModelConversionForDailyPerformance(List<AgentPerformanceSummary> agentSummary, String direction) {
        ArrayList<DailyPerformanceReportModel> addValue = new ArrayList<DailyPerformanceReportModel>();
        for (AgentPerformanceSummary row : agentSummary) {
            DailyPerformanceReportModel data = new DailyPerformanceReportModel();
            data.setAgentName(row.getAgentName());
            data.setAverageTalkDuration(row.getAverageTalkDuration() != null ? DateFormatUtility.findLocalTime((Long)row.getAverageTalkDuration()) : "00:00:00");
            data.setTotalAnswered(Integer.valueOf(row.getTotalAnswered() + row.getTotalConnected()));
            data.setTotalNoAnswered(Integer.valueOf(row.getTotalNoAnswered() + row.getTotalNotConnected()));
            data.setTotalOffered(row.getTotalOffered());
            data.setTotalDialed(row.getTotalDialed());
            data.setTotalTalkDuration(row.getTotalTalkDuration() != null ? DateFormatUtility.findLocalTime((Long)row.getTotalTalkDuration()) : "00:00:00");
            data.setTotalAcwDuration(row.getTotalAcwDuration() != null ? DateFormatUtility.findLocalTime((Long)row.getTotalAcwDuration().longValue()) : "00:00:00");
            data.setSecond10(row.getSecond10());
            data.setSecond20(row.getSecond20());
            data.setSecond30(row.getSecond30());
            data.setSecond40(row.getSecond40());
            data.setSecond50(row.getSecond50());
            data.setSecond60(row.getSecond60());
            data.setFullname(row.getFullname());
            data.setStartDate(this.dateFormatUtility.epochToLocalDateForLocalTimeZone(row.getStartDate()));
            int totalAnswered = row.getTotalAnswered() + row.getTotalConnected();
            long totalTalkSeconds = this.getDurationOrZero(row.getTotalTalkDuration());
            data.setAverageTalkDuration(totalAnswered > 0 ? DateFormatUtility.findLocalTime((Long)(totalTalkSeconds / (long)totalAnswered)) : "00:00:00");
            data.setTotalConnectedCalls(Integer.valueOf(totalAnswered));
            data.setTotalTalkDurationInSeconds(Long.valueOf(totalTalkSeconds));
            Duration totalLoginDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalLoginDuration().longValue())));
            Duration unServiceDuration = Duration.ZERO;
            Duration totalRingDuration = Duration.ZERO;
            Duration totalTalkDuration = Duration.ZERO;
            Duration totalAcwDuration = Duration.ZERO;
            Duration totalBreakDuration = Duration.ZERO;
            Duration totalIdleDuration = Duration.ZERO;
            if (row.getLoginTime() == null && row.getLogoutTime() == null) {
                data.setNetLoginTime("00:00:00");
                data.setUnServiceDuration("00:00:00");
                data.setTotalLoginDuration("00:00:00");
                data.setTotalIdleDuration("00:00:00");
                data.setTotalBreakDuration("00:00:00");
                data.setTotalRingDuration("00:00:00");
            } else {
                if (row.getLoginTime() != null && row.getLogoutTime() == null) {
                    Duration totalLogin = Duration.between(row.getLoginTime(), LocalDateTime.now());
                    totalLoginDuration = totalLoginDuration.plus(totalLogin);
                }
                data.setNetLoginTime(DateFormatUtility.findLocalTime((Long)totalLoginDuration.getSeconds()));
                Duration totalUnServiceDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getUnServiceDuration().longValue())));
                if (row.getStartCallTime() == null && row.getUnLoginTime() != null) {
                    unServiceDuration = Duration.between(row.getUnLoginTime(), LocalDateTime.now());
                    unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                } else {
                    unServiceDuration = totalUnServiceDuration;
                }
                data.setUnServiceDuration(DateFormatUtility.findLocalTime((Long)unServiceDuration.getSeconds()));
                Duration realTotalDialedDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getRealTotalDialedDuration().longValue())));
                totalTalkDuration = Duration.ofSeconds(this.getDurationOrZero(row.getTotalTalkDuration()));
                totalRingDuration = Duration.ofSeconds(this.getDurationOrZero(row.getTotalRingDuration()));
                totalAcwDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalAcwDuration().longValue())));
                totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalBreakDuration().longValue())));
                if (row.getBreakTime() != null && row.getLogoutTime() == null) {
                    Duration totalBreakTime = Duration.between(row.getBreakTime(), LocalDateTime.now());
                    totalBreakDuration = totalBreakDuration.plus(totalBreakTime);
                }
                data.setTotalBreakDuration(DateFormatUtility.findLocalTime((Long)totalBreakDuration.getSeconds()));
                Duration netRingDuration = totalRingDuration.plus(realTotalDialedDuration);
                totalIdleDuration = totalLoginDuration.minus(netRingDuration).minus(totalAcwDuration).minus(totalTalkDuration).minus(totalBreakDuration).minus(unServiceDuration);
                data.setTotalIdleDuration(DateFormatUtility.findLocalTime((Long)totalIdleDuration.getSeconds()));
                Duration totalTime = totalLoginDuration.minus(totalBreakDuration).minus(unServiceDuration);
                data.setTotalLoginDuration(DateFormatUtility.findLocalTime((Long)totalTime.getSeconds()));
                data.setTotalRingDuration(DateFormatUtility.findLocalTime((Long)netRingDuration.getSeconds()));
            }
            addValue.add(data);
        }
        return addValue;
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    private List<DailyPerformanceReportModel> groupAndSummarizeAgentData(List<DailyPerformanceReportModel> agentSummaries) {
        HashMap<String, DailyPerformanceReportModel> summarizedDataMap = new HashMap<String, DailyPerformanceReportModel>();
        for (DailyPerformanceReportModel summary : agentSummaries) {
            summarizedDataMap.compute(summary.getAgentName(), (key, existingSummary) -> {
                if (existingSummary == null) {
                    summary.setNumberOfDays(1);
                    return summary;
                }
                existingSummary.setNumberOfDays(existingSummary.getNumberOfDays() + 1);
                existingSummary.setTotalAnswered(Integer.valueOf(existingSummary.getTotalAnswered() + summary.getTotalAnswered()));
                existingSummary.setTotalNoAnswered(Integer.valueOf(existingSummary.getTotalNoAnswered() + summary.getTotalNoAnswered()));
                existingSummary.setTotalOffered(Integer.valueOf(existingSummary.getTotalOffered() + summary.getTotalOffered()));
                existingSummary.setTotalDialed(Integer.valueOf(existingSummary.getTotalDialed() + summary.getTotalDialed()));
                existingSummary.setSecond10(Integer.valueOf(existingSummary.getSecond10() + summary.getSecond10()));
                existingSummary.setSecond20(Integer.valueOf(existingSummary.getSecond20() + summary.getSecond20()));
                existingSummary.setSecond30(Integer.valueOf(existingSummary.getSecond30() + summary.getSecond30()));
                existingSummary.setSecond40(Integer.valueOf(existingSummary.getSecond40() + summary.getSecond40()));
                existingSummary.setSecond50(Integer.valueOf(existingSummary.getSecond50() + summary.getSecond50()));
                existingSummary.setSecond60(Integer.valueOf(existingSummary.getSecond60() + summary.getSecond60()));
                existingSummary.setTotalLoginDuration(this.sumDurations(existingSummary.getTotalLoginDuration(), summary.getTotalLoginDuration()));
                existingSummary.setTotalRingDuration(this.sumDurations(existingSummary.getTotalRingDuration(), summary.getTotalRingDuration()));
                existingSummary.setTotalIdleDuration(this.sumDurations(existingSummary.getTotalIdleDuration(), summary.getTotalIdleDuration()));
                existingSummary.setTotalBreakDuration(this.sumDurations(existingSummary.getTotalBreakDuration(), summary.getTotalBreakDuration()));
                existingSummary.setNetLoginTime(this.sumDurations(existingSummary.getNetLoginTime(), summary.getNetLoginTime()));
                existingSummary.setTotalTalkDuration(this.sumDurations(existingSummary.getTotalTalkDuration(), summary.getTotalTalkDuration()));
                existingSummary.setTotalAcwDuration(this.sumDurations(existingSummary.getTotalAcwDuration(), summary.getTotalAcwDuration()));
                existingSummary.setUnServiceDuration(this.sumDurations(existingSummary.getUnServiceDuration(), summary.getUnServiceDuration()));
                existingSummary.setRealTotalDialedDuration(this.sumDurations(existingSummary.getRealTotalDialedDuration(), summary.getRealTotalDialedDuration()));
                existingSummary.setTotalTalkDurationInSeconds(Long.valueOf(existingSummary.getTotalTalkDurationInSeconds() + summary.getTotalTalkDurationInSeconds()));
                existingSummary.setTotalConnectedCalls(Integer.valueOf(existingSummary.getTotalConnectedCalls() + summary.getTotalConnectedCalls()));
                if (existingSummary.getTotalConnectedCalls() > 0) {
                    long avg = existingSummary.getTotalTalkDurationInSeconds() / (long)existingSummary.getTotalConnectedCalls().intValue();
                    existingSummary.setAverageTalkDuration(DateFormatUtility.findLocalTime((Long)avg));
                } else {
                    existingSummary.setAverageTalkDuration("00:00:00");
                }
                existingSummary.setInAnswer(summary.getInAnswer());
                existingSummary.setInNoAnswer(summary.getInNoAnswer());
                existingSummary.setInRingDuration(summary.getInRingDuration());
                existingSummary.setInTalkDuration(summary.getInTalkDuration());
                existingSummary.setInAvgTalkDuration(summary.getInAvgTalkDuration());
                existingSummary.setOutAnswer(summary.getOutAnswer());
                existingSummary.setOutNoAnswer(summary.getOutNoAnswer());
                existingSummary.setOutRingDuration(summary.getOutRingDuration());
                existingSummary.setOutTalkDuration(summary.getOutTalkDuration());
                existingSummary.setOutAvgTalkDuration(summary.getOutAvgTalkDuration());
                return existingSummary;
            });
        }
        return new ArrayList<DailyPerformanceReportModel>(summarizedDataMap.values());
    }

    private String sumDurations(String duration1, String duration2) {
        long totalSeconds1 = this.parseDuration(duration1);
        long totalSeconds2 = this.parseDuration(duration2);
        long totalSeconds = totalSeconds1 + totalSeconds2;
        return DateFormatUtility.findLocalTime((Long)totalSeconds);
    }

    private long parseDuration(String duration) {
        if (duration == null || duration.isEmpty()) {
            return 0L;
        }
        String[] parts = duration.split(":");
        if (parts.length != 3) {
            return 0L;
        }
        long hours = Long.parseLong(parts[0]);
        long minutes = Long.parseLong(parts[1]);
        long seconds = Long.parseLong(parts[2]);
        return hours * 3600L + minutes * 60L + seconds;
    }
}

