/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.syncData.service;

import com.coraltele.db.telephony.main.entity.SyncLog;
import com.coraltele.db.telephony.main.repository.SyncLogRepository;
import com.coraltele.db.telephony.pbx.repository.SystemConfigRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.systemConfig.service.SystemConfigService;
import com.coraltele.service.syncData.model.BackupVersionModel;
import com.coraltele.service.syncData.model.LastBackUpModel;
import com.coraltele.service.syncData.model.SyncDataLogsModel;
import com.coraltele.service.syncData.model.UnifiedBackupVersionModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostgresBackupService {
    private static final Logger logger = LogManager.getLogger(PostgresBackupService.class);
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    SystemConfigRepository systemConfigRepository;
    @Autowired
    private SyncLogRepository syncLogsRepository;
    private final String BACKUP_BASE_PATH = "/tmp/db/backups";
    private final String POSTGRES_USER = "postgres";
    private final String HOST = "127.0.0.1";
    private final int MAX_BACKUP_VERSIONS = 5;

    public RequestResponse performBackup() {
        RequestResponse returnValue = new RequestResponse();
        try {
            Long newVersion = 1L;
            Optional lastLog = this.syncLogsRepository.findTopByOrderByIdDesc();
            newVersion = !lastLog.isPresent() ? Long.valueOf(1L) : Long.valueOf(((SyncLog)lastLog.get()).getVersion() + 1L);
            long currentTime = System.currentTimeMillis() / 1000L;
            logger.info("=== Starting backup process for all databases ===");
            this.systemConfigRepository.updateSyncIdFromUpdateId();
            this.backupDatabase(Long.valueOf(currentTime), newVersion, "users", false, null);
            this.backupDatabase(Long.valueOf(currentTime), newVersion, "switch", false, null);
            this.backupDatabase(Long.valueOf(currentTime), newVersion, "coralapps", true, Arrays.asList("public.agents", "public.members", "public.tiers"));
            logger.info("=== Backup process completed for all databases ===");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Backup completed successfully");
            returnValue.setMessageDetail("/tmp/db/backups");
            returnValue.setData((Object)newVersion);
        }
        catch (Exception ex) {
            logger.error("performBackup: Exception during backup - " + ex.getMessage(), (Throwable)ex);
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Error occurred during database backup.");
            returnValue.setMessageDetail(ex.getMessage());
            returnValue.setData(null);
        }
        return returnValue;
    }

    private void backupDatabase(Long currentTime, Long newVersion, String dbName, boolean isPartial, List<String> tables) throws IOException, InterruptedException {
        logger.info("Initiating backup for database: '{}'", (Object)dbName);
        if (isPartial) {
            logger.info("Partial backup enabled. Tables to include: {}", tables);
        }
        SyncLog syncLog = new SyncLog();
        try {
            String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String fileName = isPartial ? dbName + "_partial_" + timestamp + ".backup" : dbName + "_" + timestamp + ".backup";
            syncLog.setBackUpFileName(fileName);
            syncLog.setDbName(dbName);
            syncLog.setVersion(newVersion);
            syncLog.setBackUpTime(currentTime);
            Path dbFolder = Paths.get("/tmp/db/backups", dbName);
            Files.createDirectories(dbFolder, new FileAttribute[0]);
            logger.info("Ensured backup directory exists at: {}", (Object)dbFolder);
            Path backupFilePath = dbFolder.resolve(fileName);
            logger.info("Backup file will be created at: {}", (Object)backupFilePath);
            ArrayList<String> command = new ArrayList<String>(Arrays.asList("pg_dump", "-U", "postgres", "-h", "127.0.0.1", "-F", "c", "-f", backupFilePath.toString(), dbName));
            if (isPartial && tables != null) {
                tables.forEach(t -> {
                    command.add("-t");
                    command.add((String)t);
                });
            }
            logger.info("Executing pg_dump command: {}", (Object)String.join((CharSequence)" ", command));
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.environment().put("PGPASSWORD", "Pgadmin@123");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            logger.info("Started pg_dump process for database: {}", (Object)dbName);
            this.printProcessOutput(process);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                logger.error("Backup failed for database '{}'. Exit code: {}", (Object)dbName, (Object)exitCode);
                syncLog.setStatus("failed");
                syncLog.setIsSuccess(Boolean.valueOf(false));
                this.syncLogsRepository.save((Object)syncLog);
                throw new RuntimeException("Backup failed for DB: " + dbName);
            }
            syncLog.setStatus("Backup Completed");
            syncLog.setIsSuccess(Boolean.valueOf(true));
            this.syncLogsRepository.save((Object)syncLog);
            logger.info("Backup successful for database '{}'. File created: {}", (Object)dbName, (Object)backupFilePath);
            this.cleanupOldBackups(dbFolder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cleanupOldBackups(Path dbFolder) throws IOException {
        logger.info("Checking for old backups to clean in: {}", (Object)dbFolder);
        try (Stream<Path> files = Files.list(dbFolder);){
            List sortedBackups = files.filter(f -> f.toString().endsWith(".backup")).sorted(Comparator.comparingLong(f -> f.toFile().lastModified()).reversed()).collect(Collectors.toList());
            if (sortedBackups.size() <= 5) {
                logger.info("No old backups to delete. Total backups: {}", (Object)sortedBackups.size());
                return;
            }
            for (int i = 5; i < sortedBackups.size(); ++i) {
                Files.deleteIfExists((Path)sortedBackups.get(i));
                logger.info("Deleted old backup: {}", (Object)((Path)sortedBackups.get(i)).getFileName());
            }
        }
    }

    private void printProcessOutput(Process process) throws IOException {
        logger.debug("Reading pg_dump process output...");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            reader.lines().forEach(line -> logger.debug("[pg_dump] {}", line));
        }
    }

    public RequestResponse getList(String ip) {
        RequestResponse response = new RequestResponse();
        ArrayList<LastBackUpModel> groupedBackups = new ArrayList<LastBackUpModel>();
        List latestBackupTimes = this.syncLogsRepository.findTop5DistinctBackUpTimeDesc();
        if (latestBackupTimes == null || latestBackupTimes.isEmpty()) {
            response.setMessage("No backup times found.");
            return response;
        }
        for (Long backupTime : latestBackupTimes) {
            List logs;
            if (backupTime == null || (logs = this.syncLogsRepository.findAllByBackUpTimeAndFromServer(backupTime, ip)) == null || logs.isEmpty()) continue;
            List logModels = logs.stream().map(log -> {
                SyncDataLogsModel model = new SyncDataLogsModel();
                model.setVersion(log.getVersion());
                model.setServers(log.getServers());
                model.setStatus(log.getStatus());
                model.setBackUpFileName(log.getBackUpFileName());
                model.setBackUpTime(log.getBackUpTime());
                return model;
            }).collect(Collectors.toList());
            LastBackUpModel lastBackUpModel = new LastBackUpModel();
            lastBackUpModel.setTime(DateFormatUtility.epochToLocalDateTime((Long)backupTime));
            lastBackUpModel.setVersion("V-" + (((SyncLog)logs.get(0)).getVersion() != null ? ((SyncLog)logs.get(0)).getVersion() : "Unknown"));
            lastBackUpModel.setLastBackUpModel2s(logModels);
            groupedBackups.add(lastBackUpModel);
        }
        response.setData(groupedBackups);
        response.setMessage("Latest backups fetched successfully.");
        return response;
    }

    public RequestResponse getLastFiveBackupVersionList(String ip) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<UnifiedBackupVersionModel> backupVersionList = new ArrayList<UnifiedBackupVersionModel>();
        try {
            List latestBackupTimes = this.syncLogsRepository.findTop5DistinctBackUpTimeDesc();
            if (latestBackupTimes != null) {
                for (Long backupTime : latestBackupTimes) {
                    List logs;
                    if (backupTime == null || (logs = this.syncLogsRepository.findAllByBackUpTimeAndFromServer(backupTime, ip)) == null || logs.isEmpty()) continue;
                    String versionId = "V-" + (((SyncLog)logs.get(0)).getVersion() != null ? ((SyncLog)logs.get(0)).getVersion() : "N/A");
                    LocalDateTime backupTimeFormatted = DateFormatUtility.epochToLocalDateTime((Long)backupTime);
                    ArrayList<BackupVersionModel> files = new ArrayList<BackupVersionModel>();
                    for (SyncLog log : logs) {
                        if (log == null) continue;
                        String database = log.getDbName() != null ? log.getDbName() : "unknown";
                        String fileName = log.getBackUpFileName() != null ? log.getBackUpFileName() : "unknown.bak";
                        String path = "/tmp/db/backups/" + database + "/" + fileName;
                        String size = "N/A";
                        try {
                            Path filePath = Paths.get(path, new String[0]);
                            if (Files.exists(filePath, new LinkOption[0])) {
                                long bytes = Files.size(filePath);
                                size = this.formatSize(bytes);
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("Could not get size for file: " + path, (Throwable)ex);
                        }
                        BackupVersionModel file = new BackupVersionModel();
                        file.setDbName(database);
                        file.setPath(path);
                        file.setSize(size);
                        files.add(file);
                    }
                    UnifiedBackupVersionModel versionModel = new UnifiedBackupVersionModel();
                    versionModel.setId(((SyncLog)logs.get(0)).getVersion());
                    versionModel.setVersionId(versionId);
                    versionModel.setBackupTime(backupTimeFormatted != null ? backupTimeFormatted.toString() : "N/A");
                    versionModel.setFiles(files);
                    backupVersionList.add(versionModel);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Last 5 Backup Versions Retrieved");
            returnValue.setData(backupVersionList);
        }
        catch (Exception e) {
            logger.error("Error while fetching last 5 backup version list: ", (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while retrieving list");
            returnValue.setMessageDetail("Contact Administrator");
        }
        return returnValue;
    }

    private String formatSize(long sizeInBytes) {
        if (sizeInBytes < 1024L) {
            return sizeInBytes + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(sizeInBytes)) / 10;
        return String.format("%.1f %sB", (double)sizeInBytes / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }
}

