/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.shift.service;

import com.coraltele.db.coralapps.callcenter.entity.Shift;
import com.coraltele.db.coralapps.callcenter.repository.ShiftRepository;
import com.coraltele.db.coralapps.callcenter.specification.ShiftSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.shift.model.ShiftModel;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ShiftService {
    private static final Logger logger = LogManager.getLogger(ShiftService.class);
    @Autowired
    private ShiftRepository shiftRepository;

    public RequestResponse createShift(ShiftModel shiftModel) {
        String shiftName;
        RequestResponse response = new RequestResponse();
        String string = shiftName = shiftModel.getShiftName() != null ? shiftModel.getShiftName().trim() : "";
        if (shiftName.isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Shift name cannot be empty.");
            return response;
        }
        Optional optionalShift = this.shiftRepository.findByShiftName(shiftName);
        if (optionalShift.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Shift name '" + shiftName + "' already exists.");
            return response;
        }
        LocalTime fromTime = DateFormatUtility.stringToLocalTime((String)shiftModel.getFromTime());
        LocalTime toTime = DateFormatUtility.stringToLocalTime((String)shiftModel.getToTime());
        if (fromTime == null || toTime == null) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Invalid time format for 'fromTime' or 'toTime'. Expected format: HH:mm:ss");
            return response;
        }
        Shift shift = new Shift();
        shift.setShiftName(shiftName);
        shift.setFromTime(fromTime);
        shift.setToTime(toTime);
        this.shiftRepository.save((Object)shift);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Shift saved successfully.");
        return response;
    }

    public RequestResponse updateShift(ShiftModel shiftModel) {
        String newShiftName;
        RequestResponse response = new RequestResponse();
        Optional optionalShift = this.shiftRepository.findById((Object)shiftModel.getId());
        if (!optionalShift.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Shift not found.");
            return response;
        }
        String string = newShiftName = shiftModel.getShiftName() != null ? shiftModel.getShiftName().trim() : "";
        if (newShiftName.isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Shift name cannot be empty.");
            return response;
        }
        Optional existingShiftWithSameName = this.shiftRepository.findByShiftName(newShiftName);
        if (existingShiftWithSameName.isPresent() && !((Shift)existingShiftWithSameName.get()).getId().equals(shiftModel.getId())) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Another shift with name '" + newShiftName + "' already exists.");
            return response;
        }
        LocalTime fromTime = DateFormatUtility.stringToLocalTime((String)shiftModel.getFromTime());
        LocalTime toTime = DateFormatUtility.stringToLocalTime((String)shiftModel.getToTime());
        if (fromTime == null || toTime == null) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Invalid time format. Expected format: HH:mm:ss");
            return response;
        }
        Shift shiftToUpdate = (Shift)optionalShift.get();
        shiftToUpdate.setShiftName(newShiftName);
        shiftToUpdate.setFromTime(fromTime);
        shiftToUpdate.setToTime(toTime);
        this.shiftRepository.save((Object)shiftToUpdate);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Shift updated successfully.");
        return response;
    }

    public RequestResponse deleteShift(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional shift = this.shiftRepository.findById((Object)ids);
            if (shift.isPresent()) {
                addValue.add(shift.get());
                this.shiftRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ShiftSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.shiftRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.shiftRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ShiftModel> entityToModelConversion(List<Shift> shifts) {
        ArrayList<ShiftModel> addValue = new ArrayList<ShiftModel>();
        for (Shift row : shifts) {
            ShiftModel data = new ShiftModel();
            data.setId(row.getId());
            data.setShiftName(row.getShiftName());
            data.setToTime(DateFormatUtility.localTimeToString((LocalTime)row.getToTime()));
            data.setFromTime(DateFormatUtility.localTimeToString((LocalTime)row.getFromTime()));
            addValue.add(data);
        }
        return addValue;
    }
}

