/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.leadMaster.service;

import com.coraltele.db.coralapps.callcenter.entity.Campaign;
import com.coraltele.db.coralapps.callcenter.entity.LeadMaster;
import com.coraltele.db.coralapps.callcenter.repository.CampaignRepository;
import com.coraltele.db.coralapps.callcenter.repository.LeadMasterRepository;
import com.coraltele.db.coralapps.callcenter.specification.LeadMasterSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.leadMaster.model.LeadMasterModel;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LeadMasterService {
    private static final Logger logger = LogManager.getLogger(LeadMasterService.class);
    @Autowired
    LeadMasterRepository leadMasterRepository;
    @Autowired
    CampaignRepository campaignRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Long campaignId) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = LeadMasterSpecification.generateFilters((SearchRequest)searchRequestData, (Long)campaignId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.leadMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.leadMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<LeadMasterModel> entityToModelConversion(List<LeadMaster> leadMaster) {
        ArrayList<LeadMasterModel> addValue = new ArrayList<LeadMasterModel>();
        for (LeadMaster row : leadMaster) {
            LeadMasterModel data = new LeadMasterModel();
            data.setId(row.getId());
            data.setCampaignId(row.getCampaignId());
            Optional campaignOptional = this.campaignRepository.findById(row.getCampaignId());
            data.setCampaignName(((Campaign)campaignOptional.get()).getDescription());
            data.setFilename(row.getFilename());
            data.setFilepath(row.getFilepath());
            data.setPhoneNumber(row.getPhoneNumber());
            data.setRecordCreatedBy(row.getRecordCreatedBy());
            data.setRecordCreatedOn(row.getRecordCreatedOn());
            data.setRecordLastModifiedBy(row.getRecordLastModifiedBy());
            data.setUniqueLeadUpload(row.getUniqueLeadUpload());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllLeadMasterByQueue(Long queue) {
        List list = this.campaignRepository.findByQueue(queue);
        List leadMaster = this.leadMasterRepository.findByCampaignId((Long)list.stream().map(Campaign::getId).findFirst().orElse(null));
        ArrayList<LeadMasterModel> addValue = new ArrayList<LeadMasterModel>();
        RequestResponse returnValue = new RequestResponse();
        for (LeadMaster row : leadMaster) {
            LeadMasterModel data = new LeadMasterModel();
            data.setId(row.getId());
            data.setCampaignId(row.getCampaignId());
            Optional campaignOptional = this.campaignRepository.findById(row.getCampaignId());
            data.setCampaignName((String)campaignOptional.map(Campaign::getDescription).orElse(null));
            data.setFilename(row.getFilename());
            data.setFilepath(row.getFilepath());
            data.setPhoneNumber(row.getPhoneNumber());
            data.setRecordCreatedBy(row.getRecordCreatedBy());
            data.setRecordCreatedOn(row.getRecordCreatedOn());
            data.setRecordLastModifiedBy(row.getRecordLastModifiedBy());
            data.setUniqueLeadUpload(row.getUniqueLeadUpload());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse convertCsvToJsonByUuid(String uuid) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<Map> jsonDataList = new ArrayList<Map>();
        Optional leadMasterOptional = this.leadMasterRepository.findByUniqueLeadUpload(uuid);
        if (leadMasterOptional.isPresent()) {
            String csvFilePath = ((LeadMaster)leadMasterOptional.get()).getFilepath();
            try (FileReader reader = new FileReader(csvFilePath);
                 CSVParser csvParser = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse((Reader)reader);){
                for (CSVRecord csvRecord : csvParser) {
                    Map recordMap = this.convertCsvRecordToMap(csvRecord, csvParser.getHeaderMap());
                    jsonDataList.add(recordMap);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("Data Retrieved Successfully");
                returnValue.setData(jsonDataList);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    private Map<String, String> convertCsvRecordToMap(CSVRecord csvRecord, Map<String, Integer> headerMap) {
        HashMap<String, String> recordMap = new HashMap<String, String>();
        for (Map.Entry<String, Integer> entry : headerMap.entrySet()) {
            String header = entry.getKey();
            int columnIndex = entry.getValue();
            recordMap.put(header, csvRecord.get(columnIndex));
        }
        return recordMap;
    }

    public RequestResponse getAllLeadMasterFilterAgainstCampaign(SearchRequest searchRequestData, Long campaignId) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = LeadMasterSpecification.generateFilters((SearchRequest)searchRequestData, (Long)campaignId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.leadMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.leadMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.getAllLeadMasterByCampaignId(page.getContent(), campaignId));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<LeadMasterModel> getAllLeadMasterByCampaignId(List<LeadMaster> leadMasterList, Long campaignId) {
        ArrayList<LeadMasterModel> addValue = new ArrayList<LeadMasterModel>();
        for (LeadMaster row : leadMasterList) {
            LeadMasterModel data = new LeadMasterModel();
            data.setId(row.getId());
            data.setCampaignId(row.getCampaignId());
            data.setFilename(row.getFilename());
            data.setFilepath(row.getFilepath());
            data.setPhoneNumber(row.getPhoneNumber());
            data.setRecordCreatedBy(row.getRecordCreatedBy());
            data.setRecordCreatedOn(row.getRecordCreatedOn());
            data.setRecordLastModifiedBy(row.getRecordLastModifiedBy());
            data.setUniqueLeadUpload(row.getUniqueLeadUpload());
            addValue.add(data);
        }
        return addValue;
    }
}

