/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.cDrsVoicePicker.service;

import com.coraltele.db.billing.main.repository.CDrsVoicePickerRepository;
import com.coraltele.db.billing.main.specification.CDrSVoicePickerSpecification;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CDrSVoicePickerService {
    private static final Logger logger = LogManager.getLogger(CDrSVoicePickerService.class);
    @Autowired
    CDrsVoicePickerRepository cDrsVoicePickerRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;

    public RequestResponse getAllEpVoicePicker(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        List phoneNumbers = new ArrayList();
        for (AdvanceFilter filter : searchRequestData.advancedFilters) {
            if (!filter.getFieldName().equalsIgnoreCase("extGroupCode")) continue;
            phoneNumbers = this.getExtensionList(filter.getValue());
        }
        Specification filters = CDrSVoicePickerSpecification.generateFilters((SearchRequest)searchRequestData, phoneNumbers);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startCall" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startCall" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.cDrsVoicePickerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.cDrsVoicePickerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<String> getExtensionList(String extensionGroupCode) {
        List extensionList = this.extensionsRepository.findByExtGroupCode(extensionGroupCode);
        ArrayList<String> extensions = new ArrayList<String>();
        if (!extensionList.isEmpty()) {
            for (Extension extension : extensionList) {
                extensions.add(extension.getExtension());
            }
        }
        return extensions;
    }
}

