DO $$
BEGIN
    IF NOT EXISTS (
        SELECT FROM pg_tables WHERE schemaname = 'public' AND tablename = 't_sendfaxprogress'
    ) THEN
        CREATE TABLE public.t_sendfaxprogress (
            id integer NOT NULL,
            caller_ani character varying(255),
            caller_callee_id_number character varying(255),
            caller_context character varying(255),
            caller_destination_number character varying(255),
            caller_orig_caller_id_number character varying(255),
            caller_unique_id character varying(255),
            channel_call_uuid character varying(255),
            createdby character varying(255),
            createdon timestamp without time zone,
            destinationucuser character varying(255),
            event_date_local timestamp without time zone,
            event_date_timestamp bigint,
            event_subclass character varying(255),
            fax_bad_rows integer,
            fax_document_total_pages integer,
            fax_document_transferred_pages integer,
            fax_image_resolution character varying(255),
            fax_image_size integer,
            fax_result_code integer,
            fax_result_text character varying(255),
            fax_success integer,
            fax_transfer_rate integer,
            fileid character varying(255),
            isnotified boolean,
            isread boolean,
            mailsent character varying(255) DEFAULT 'NOTSENT'::character varying,
            nooftry integer DEFAULT 0,
            remarks1 character varying(255),
            remarks2 character varying(255),
            sourceucuser character varying(255),
            switch_ipv4 character varying(255),
            variable_call_uuid character varying(255),
            variable_coral_app character varying(255),
            variable_current_application character varying(255),
            variable_current_application_data character varying(255),
            variable_fax_filename character varying(255),
            variable_loopback_leg character varying(255),
            variable_other_loopback_leg_uuid character varying(255)
        );


        ALTER TABLE public.t_sendfaxprogress OWNER TO postgres;

        ALTER TABLE public.t_sendfaxprogress ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
            SEQUENCE NAME public.t_sendfaxprogress_id_seq
            START WITH 1
            INCREMENT BY 1
            NO MINVALUE
            NO MAXVALUE
            CACHE 1
        );

        ALTER TABLE ONLY public.t_sendfaxprogress
            ADD CONSTRAINT t_sendfaxprogress_pkey PRIMARY KEY (id);

    END IF;
END $$;