/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userDepartment.service;

import com.coraltele.db.telephony.billing.entity.Department;
import com.coraltele.db.telephony.billing.repository.DepartmentRepository;
import com.coraltele.db.users.main.entity.UserDepartment;
import com.coraltele.db.users.main.repository.UserDepartmentRepository;
import com.coraltele.db.users.main.specification.UserDepartmentSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.user.model.UserDepartmentModel;
import com.coraltele.service.user.model.UserDepartmentNameModel;
import com.coraltele.service.user.userDepartment.model.CreateUserDepartment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class UserDepartmentService {
    private static final Logger logger = LogManager.getLogger(UserDepartmentService.class);
    @Autowired
    private UserDepartmentRepository userDepartmentRepository;
    @Autowired
    private DepartmentRepository departmentRepository;

    public RequestResponse associateUserDepartment(CreateUserDepartment model) {
        RequestResponse response = new RequestResponse();
        List userNames = model.getUsername();
        List departments = model.getDepartment();
        if (userNames == null || userNames.isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("User names must not be empty");
            return response;
        }
        for (String userName : userNames) {
            this.userDepartmentRepository.deleteByUsername(userName);
        }
        for (String userName : userNames) {
            for (String department : departments) {
                UserDepartment userDepartment = new UserDepartment();
                userDepartment.setUsername(userName);
                userDepartment.setDepartment(department);
                this.userDepartmentRepository.save((Object)userDepartment);
            }
        }
        response.setStatus(Constants.Error.OK);
        response.setMessage("User-department associations updated successfully");
        return response;
    }

    public RequestResponse deleteByUsername(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        for (String ids : data.getStringId()) {
            List userGroup = this.userDepartmentRepository.findByUsername(ids);
            if (!userGroup.isEmpty()) {
                this.userDepartmentRepository.deleteAll((Iterable)userGroup);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
        }
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getGroupedDepartments() {
        List all = this.userDepartmentRepository.findAllUsersWithDepartments();
        Map groupedDepartments = all.stream().collect(Collectors.groupingBy(UserDepartment::getUsername, Collectors.mapping(UserDepartment::getDepartment, Collectors.toList())));
        ArrayList<UserDepartmentModel> result = new ArrayList<UserDepartmentModel>();
        for (Map.Entry entry : groupedDepartments.entrySet()) {
            String username = entry.getKey();
            List departmentCodes = entry.getValue();
            List descriptions = this.departmentRepository.findByCodeIn(departmentCodes).stream().map(Department::getDescription).collect(Collectors.toList());
            result.add(new UserDepartmentModel(username, departmentCodes, descriptions));
        }
        RequestResponse response = new RequestResponse();
        response.setStatus(Constants.Error.OK);
        response.setMessage("Grouped departments fetched successfully");
        response.setData(result);
        return response;
    }

    public RequestResponse getGroupedDepartmentsFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserDepartmentSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        sort = searchRequestData.getSortDirection().equals("asc") ? Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "username" : searchRequestData.getSortBy()}).ascending() : (searchRequestData.getSortDirection().equals("desc") ? Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "username" : searchRequestData.getSortBy()}).descending() : Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "username" : searchRequestData.getSortBy()}).ascending());
        List allFilteredData = this.userDepartmentRepository.findAll(filters, sort);
        List allUniqueRecords = this.entityToModelConversion(allFilteredData);
        int totalUniqueRecords = allUniqueRecords.size();
        int pageSize = searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize();
        int currentPage = searchRequestData.getCurrentPage();
        int startItem = currentPage * pageSize;
        int toIndex = Math.min(startItem + pageSize, totalUniqueRecords);
        List paginatedList = startItem < totalUniqueRecords ? allUniqueRecords.subList(startItem, toIndex) : new ArrayList();
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(currentPage > totalUniqueRecords / pageSize ? 0L : (long)currentPage);
        responseData.setPageSize((long)pageSize);
        responseData.setTotalPages((long)((int)Math.ceil((double)totalUniqueRecords / (double)pageSize)));
        responseData.setTotalRecords((long)totalUniqueRecords);
        responseData.setCurrentPageData(paginatedList);
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<UserDepartmentNameModel> entityToModelConversion(List<UserDepartment> announcement) {
        ArrayList<UserDepartment> all = new ArrayList<UserDepartment>(announcement);
        Map groupedDepartments = all.stream().collect(Collectors.groupingBy(UserDepartment::getUsername, Collectors.mapping(UserDepartment::getDepartment, Collectors.toList())));
        ArrayList<UserDepartmentNameModel> result = new ArrayList<UserDepartmentNameModel>();
        for (Map.Entry entry : groupedDepartments.entrySet()) {
            String username = entry.getKey();
            List departmentCodes = entry.getValue();
            logger.info("Department Codes for {}: {}", (Object)username, departmentCodes);
            List descriptions = this.departmentRepository.findByCodeIn(departmentCodes).stream().map(Department::getDescription).collect(Collectors.toList());
            result.add(new UserDepartmentNameModel(username, departmentCodes, descriptions));
        }
        return result;
    }
}

