/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.service;

import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.users.repository.UsersRepositoryCoralApps;
import com.coraltele.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.db.telemetry.main.entity.Area;
import com.coraltele.db.telemetry.main.entity.EventNotify;
import com.coraltele.db.telemetry.main.entity.FileUpload;
import com.coraltele.db.telemetry.main.entity.UserCoordinate;
import com.coraltele.db.telemetry.main.repository.AreaRepository;
import com.coraltele.db.telemetry.main.repository.EventNotifyRepository;
import com.coraltele.db.telemetry.main.repository.FileUploadRepository;
import com.coraltele.db.telemetry.main.repository.UserCoordinateRepository;
import com.coraltele.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.db.telephony.billing.entity.Department;
import com.coraltele.db.telephony.billing.repository.DepartmentRepository;
import com.coraltele.db.telephony.main.entity.McxDispatcher;
import com.coraltele.db.telephony.main.entity.Subscriber;
import com.coraltele.db.telephony.main.repository.LocationSwitchRepository;
import com.coraltele.db.telephony.main.repository.McxDispatcherRepository;
import com.coraltele.db.telephony.main.repository.SubscriberRepository;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.entity.VipMaster;
import com.coraltele.db.telephony.pbx.repository.DidMappingRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.telephony.pbx.repository.VipMasterRepository;
import com.coraltele.db.telephony.uc.entity.CustomerAccount;
import com.coraltele.db.telephony.uc.repository.CustomerAccountRepository;
import com.coraltele.db.users.main.entity.ChangePassword;
import com.coraltele.db.users.main.entity.PasswordConfig;
import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserDepartment;
import com.coraltele.db.users.main.entity.UserGroup;
import com.coraltele.db.users.main.entity.UserGroupMaster;
import com.coraltele.db.users.main.entity.UserRole;
import com.coraltele.db.users.main.repository.ChangePasswordRepository;
import com.coraltele.db.users.main.repository.PasswordConfigRepository;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserDepartmentRepository;
import com.coraltele.db.users.main.repository.UserGroupMasterRepository;
import com.coraltele.db.users.main.repository.UserGroupRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.db.users.main.specification.UserSpecification;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DecryptCredential;
import com.coraltele.helper.EventNotifyModel;
import com.coraltele.helper.Messaging;
import com.coraltele.helper.PasswordConversion;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.ReturnField;
import com.coraltele.helper.XmlFileGenerator;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.main.service.AgentService;
import com.coraltele.service.coralApps.users.service.UsersService;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.pbx.cos.service.InboundCosService;
import com.coraltele.service.pbx.cos.service.OutboundCosService;
import com.coraltele.service.pbx.department.service.DepartmentService;
import com.coraltele.service.pbx.extension.model.ExtensionDepartmentModel;
import com.coraltele.service.pbx.extension.service.ExtensionSecondaryService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.pbx.extension_service.model.ServiceCodeAttribute;
import com.coraltele.service.pbx.extension_service.service.ExtensionsServicesService;
import com.coraltele.service.pbx.fileConfiguration.defaultConfiguration.service.DefaultConfigurationService;
import com.coraltele.service.telemetry.coralnms.imsi.service.IMSIService;
import com.coraltele.service.user.model.ChangePasswordModel;
import com.coraltele.service.user.model.CoralFileModel;
import com.coraltele.service.user.model.MapConfigModel;
import com.coraltele.service.user.model.UserAccessModel;
import com.coraltele.service.user.model.UserListModel;
import com.coraltele.service.user.model.UserLocationModel;
import com.coraltele.service.user.model.UserModel;
import com.coraltele.service.user.model.UserMultipleUpdateModel;
import com.coraltele.service.user.model.ViewUserModel;
import com.coraltele.service.user.service.UserRoleService;
import com.coraltele.service.user.userGroupMaster.service.UserGroupMasterService;
import com.coraltele.service.user.userRouteShift.userShift.service.UserShiftService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserService {
    private static final Logger logger = LogManager.getLogger(UserService.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    PasswordConversion sipPasswordConversion;
    @Autowired
    private PasswordEncoder bcryptEncoder;
    @Autowired
    UserRoleRepository userRoleRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    ChangePasswordRepository changePasswordRepository;
    @Autowired
    UserGroupMasterRepository userGroupMasterRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    PasswordConfigRepository passwordConfigRepository;
    @Autowired
    UserRoleService userRoleService;
    @Autowired
    ExtensionsService extensionsService;
    @Autowired
    ExtensionsRepository extensionRepository;
    @Autowired
    private InboundCosService inBoundCosService;
    @Autowired
    private OutboundCosService outBoundCosService;
    @Autowired
    ExtensionsServicesRepository extensionsServicesRepository;
    @Autowired
    DidMappingRepository didMappingRepository;
    @Autowired
    DefaultConfigurationService extensionFileConfigurationService;
    @Autowired
    AgentRepository agentRepository;
    @Autowired
    UsersService usersService;
    @Autowired
    ExtensionsServicesService extensionsServicesService;
    @Autowired
    VipMasterRepository vipMasterRepository;
    @Autowired
    ExtensionSecondaryService extensionSecondaryService;
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    UsersRepositoryCoralApps usersRepositoryCoralApps;
    @Autowired
    BashCmd cmd;
    @Autowired
    UserGroupMasterService userGroupMasterService;
    @Autowired
    EventNotifyRepository eventNotifyRepository;
    @Autowired
    AreaRepository areaRepository;
    @Autowired
    DecryptCredential credential;
    @Autowired
    UserShiftService userShiftService;
    @Autowired
    IMSIService imsiService;
    @Autowired
    DepartmentService departmentService;
    @Autowired
    UserCoordinateRepository userCoordinateRepository;
    @Autowired
    UserZoneRepository userZoneRepository;
    @Autowired
    UserDepartmentRepository userDepartmentRepository;
    @Autowired
    FileUploadRepository fileUploadRepository;
    @Autowired
    ControlRluServerService controlRluServerService;
    @Autowired
    McxDispatcherRepository mcxDispatcherRepository;
    @Autowired
    DepartmentRepository departmentRepository;
    @Autowired
    CustomerAccountRepository customerAccountRepository;
    @Autowired
    LocationSwitchRepository locationSwitchRepository;
    @Autowired
    SubscriberRepository subscriberRepository;
    @Autowired
    PasswordConversion passwordConversion;
    @Autowired
    AgentService agentService;

    public RequestResponse createUser(UserModel data, Principal principal) {
        logger.debug("create new user : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Integer conferenceRole;
            String contactNo;
            String username = data.getUsername();
            if (username == null || username.trim().isEmpty()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Login Failed");
                returnValue.setMessageDetail("Username cannot be empty.");
                return returnValue;
            }
            username = username.trim();
            logger.info("Validating username: '{}'", (Object)username);
            String usernameRegex = "^[A-Za-z0-9_.]+$";
            if (!username.matches(usernameRegex)) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Login Failed");
                returnValue.setMessageDetail("User-ID contains invalid special characters. Allowed: letters, numbers, '_' and '.'");
                return returnValue;
            }
            String xmPPServer = this.getXmPPServer();
            if (StringUtils.hasText((String)xmPPServer)) {
                String prosodyStatus = this.checkProsodyStatus();
                try {
                    if (prosodyStatus.contains("Prosody is running")) {
                        this.createXmPPUser(xmPPServer, data.getUsername(), data.getPassword() != null ? data.getPassword() : "1234");
                    } else if (prosodyStatus.contains("Prosody is not running")) {
                        if (this.startProsody()) {
                            this.createXmPPUser(xmPPServer, data.getUsername(), data.getPassword() != null ? data.getPassword() : "1234");
                        } else {
                            logger.warn("Failed to start Prosody server. XMPP user creation skipped.");
                        }
                    } else if (prosodyStatus.contains("Command 'prosodyctl' not found")) {
                        logger.error("Prosody is not installed. Please install Prosody to use XMPP functionality.");
                    }
                }
                catch (Exception e) {
                    logger.error("Unable to configure XMPP server:{}", (Object)e.getMessage());
                }
            }
            if ((contactNo = data.getContactNo()) != null && !contactNo.trim().isEmpty()) {
                contactNo = contactNo.trim();
                boolean existsInUser = this.userRepository.existsByContactNo(contactNo);
                boolean existsInExtension = false;
                if (!"normalUser".equalsIgnoreCase(data.getUserType())) {
                    existsInExtension = this.extensionsRepository.existsByExtension(contactNo);
                }
                if ("normalUser".equalsIgnoreCase(data.getUserType())) {
                    if (existsInUser) {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Unable to create");
                        returnValue.setMessageDetail("Contact number already exists in User");
                        return returnValue;
                    }
                } else if (existsInUser || existsInExtension) {
                    StringBuilder conflictSources = new StringBuilder("Contact number already exists in: ");
                    if (existsInUser) {
                        conflictSources.append("User");
                    }
                    if (existsInUser && existsInExtension) {
                        conflictSources.append(", ");
                    }
                    if (existsInExtension) {
                        conflictSources.append("Extension");
                    }
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Unable to create");
                    returnValue.setMessageDetail(conflictSources.toString());
                    return returnValue;
                }
            }
            ObjectMapper obj = new ObjectMapper();
            User user = new User();
            user.setUsername(data.getUsername());
            if (data.getDefaultPassword() != null && data.getDefaultPassword().booleanValue()) {
                user.setPassword(this.bcryptEncoder.encode((CharSequence)"12345"));
            } else {
                user.setPassword(this.bcryptEncoder.encode((CharSequence)data.getPassword()));
            }
            if (data.getAccountExpired() != null) {
                user.setAccountExpired(data.getAccountExpired());
            }
            if (data.getAccountLocked() != null) {
                user.setAccountLocked(data.getAccountLocked());
            }
            if (data.getCredentialsExpired() != null) {
                user.setCredentialsExpired(data.getCredentialsExpired());
            }
            user.setLastPasswordChange(LocalDate.now());
            user.setLastLogon(LocalDate.now());
            if (data.getEnabled() != null) {
                user.setEnabled(Integer.valueOf(data.getEnabled() != false ? 1 : 0));
            }
            user.setEmailId(data.getEmailId());
            this.departmentService.createOrUpdateUserExtension(user, data);
            user.setDescription(data.getDescription());
            user.setCreatedBy(principal.getName());
            user.setCreatedOn(LocalDateTime.now());
            user.setSipPassword(data.getSipPassword());
            user.setIsOnDemand(data.getIsOnDemand());
            user.setMaxNoAnswer(data.getMaxNoAnswer());
            user.setWrapUpTime(data.getWrapUpTime());
            user.setRejectDelayTime(data.getRejectDelayTime());
            user.setBusyDelayTime(data.getBusyDelayTime());
            user.setNoAnswerDelayTime(data.getNoAnswerDelayTime());
            user.setCallTimeout(data.getCallTimeout());
            user.setAutoAnswer(data.getAutoAnswer());
            user.setLocation(data.getLocation());
            user.setCanSendSms(data.getCanSendSms());
            user.setOutBoundGateway(data.getOutBoundGateway());
            user.setIpAddress(data.getIpAddress());
            user.setAreaId(data.getAreaId());
            user.setRefId(data.getRefId());
            if (data.getRole() != null) {
                user.setRole(obj.writeValueAsString((Object)data.getRole()));
            }
            if (data.getGroup() != null) {
                user.setUserGroup(obj.writeValueAsString((Object)data.getGroup()));
            }
            if (data.getNodeId() != null) {
                user.setNodeId(obj.writeValueAsString((Object)data.getNodeId()));
            }
            if ((conferenceRole = this.getRoleConferenceId()) != null && data.getRole().contains(conferenceRole)) {
                user.setContactNo(data.getUsername());
            }
            user.setVipUser(data.getVip());
            try {
                if (data.getVip() != null && data.getVip().booleanValue()) {
                    VipMaster vipMaster = new VipMaster();
                    vipMaster.setName(data.getVipName());
                    if (this.checkConferenceRoleUser(data.getRole())) {
                        vipMaster.setOfficeExtension(data.getUsername());
                    } else {
                        if (StringUtils.hasText((String)data.getContactNo())) {
                            this.vipMasterRepository.deleteAllByOfficeExtension(data.getContactNo());
                        }
                        vipMaster.setOfficeExtension(data.getContactNo());
                    }
                    vipMaster.setDesignation(data.getDesignation());
                    vipMaster.setPhone(data.getRank());
                    if (this.vipMasterRepository.existsByPhone(data.getRank())) {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Unable to create user");
                        returnValue.setMessageDetail("select unique rank");
                        logger.error(returnValue.getMessageDetail() + ",from vip master list");
                        return returnValue;
                    }
                    this.vipMasterRepository.save((Object)vipMaster);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error on creating vipMaster:{}", (Object)e.getMessage());
            }
            this.userRepository.save((Object)user);
            ChangePassword passwordData = new ChangePassword();
            Optional userData = this.userRepository.findByUsername(data.getUsername());
            if (userData.isPresent()) {
                passwordData.setCreatedBy(principal.getName());
                passwordData.setCreatedOn(LocalDateTime.now());
                passwordData.setPassword(user.getPassword());
                passwordData.setUserId(Long.valueOf(((User)userData.get()).getId().intValue()));
                this.changePasswordRepository.save((Object)passwordData);
            }
            if (data.getRole() != null) {
                for (Integer role : data.getRole()) {
                    Optional roleData = this.roleRepository.findById((Object)role);
                    if (!roleData.isPresent()) continue;
                    UserRole userRole = new UserRole();
                    userRole.setUser((User)userData.get());
                    userRole.setRole((Role)roleData.get());
                    userRole.setCreatedBy(principal.getName());
                    userRole.setCreatedOn(LocalDateTime.now());
                    this.userRoleRepository.save((Object)userRole);
                }
            }
            if (data.getGroup() != null) {
                for (Integer group : data.getRole()) {
                    Optional groupData = this.userGroupMasterRepository.findById((Object)group);
                    if (!groupData.isPresent()) continue;
                    UserGroup userGroup = new UserGroup();
                    userGroup.setUsers(Long.valueOf(((User)userData.get()).getId().intValue()));
                    userGroup.setGroup(Long.valueOf(((UserGroupMaster)groupData.get()).getId().intValue()));
                    userGroup.setCreatedBy(principal.getName());
                    userGroup.setCreatedOn(LocalDateTime.now());
                    this.userGroupRepository.save((Object)userGroup);
                }
            }
            ReturnField field = new ReturnField();
            field.setId(user.getId().intValue());
            field.setDescription(user.getUsername());
            Integer conferenceRoleId = this.getRoleConferenceId();
            if (conferenceRole != null && data.getRole().contains(conferenceRoleId)) {
                Optional extensionData;
                ServiceCodeAttribute extModel = new ServiceCodeAttribute();
                extModel.setFrom(data.getUsername());
                extModel.setTo(data.getUsername());
                RequestResponse extensionResponse = this.createExtensionByUsername(extModel);
                if (extensionResponse.getStatus().equals((Object)Constants.Error.OK) && (extensionData = this.extensionRepository.findByExtension(data.getUsername())).isPresent()) {
                    ((Extension)extensionData.get()).setAssignedUser(data.getUsername());
                    this.extensionRepository.save(extensionData.get());
                }
            }
            this.usersService.createNewUser(data, principal);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("User Registered");
            returnValue.setData((Object)field);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create user");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getUserById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findById(id);
            if (user.isPresent()) {
                ViewUserModel data = new ViewUserModel();
                data.setId(((User)user.get()).getId().intValue());
                data.setUsername(((User)user.get()).getUsername());
                data.setAccountExpired(((User)user.get()).getAccountExpired().booleanValue());
                data.setAccountLocked(((User)user.get()).getAccountLocked().booleanValue());
                data.setCredentialsExpired(((User)user.get()).getCredentialsExpired().booleanValue());
                data.setEnabled(((User)user.get()).getEnabled().intValue());
                data.setEmailId(((User)user.get()).getEmailId());
                data.setContactNo(((User)user.get()).getContactNo());
                data.setDescription(((User)user.get()).getDescription());
                data.setCreatedOn(LocalDateTime.now());
                data.setSipPassword(((User)user.get()).getSipPassword());
                data.setIsOnDemand(((User)user.get()).getIsOnDemand());
                data.setMaxNoAnswer(((User)user.get()).getMaxNoAnswer());
                data.setWrapUpTime(((User)user.get()).getWrapUpTime());
                data.setRejectDelayTime(((User)user.get()).getRejectDelayTime());
                data.setBusyDelayTime(((User)user.get()).getBusyDelayTime());
                data.setNoAnswerDelayTime(((User)user.get()).getNoAnswerDelayTime());
                data.setCallTimeout(((User)user.get()).getCallTimeout());
                data.setAutoAnswer(((User)user.get()).getAutoAnswer());
                data.setLocation(((User)user.get()).getLocation());
                data.setCanSendSms(((User)user.get()).getCanSendSms());
                data.setOutBoundGateway(((User)user.get()).getOutBoundGateway());
                data.setRole(((User)user.get()).getRole());
                data.setAreaId(((User)user.get()).getAreaId());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("user Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateUser(UserModel data, Principal principal) {
        RequestResponse returnValue;
        block50: {
            returnValue = new RequestResponse();
            try {
                Optional user = this.userRepository.findById((Object)data.getId());
                if (user.isPresent()) {
                    List existingUser;
                    String newContact = data.getContactNo();
                    if (!(newContact == null || newContact.trim().isEmpty() || (existingUser = this.userRepository.findByContactNo(newContact = newContact.trim())).isEmpty() || ((User)existingUser.get(0)).getId().equals(((User)user.get()).getId()))) {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Contact number already assigned to another user");
                        returnValue.setMessageDetail("The provided contact number belongs to another user.");
                        return returnValue;
                    }
                    this.departmentService.createOrUpdateUserExtension((User)user.get(), data);
                    if (data.getUsername() != null) {
                        ((User)user.get()).setUsername(data.getUsername());
                    }
                    if (data.getAccountExpired() != null) {
                        ((User)user.get()).setAccountExpired(data.getAccountExpired());
                    }
                    if (data.getAccountLocked() != null) {
                        ((User)user.get()).setAccountLocked(data.getAccountLocked());
                    }
                    if (data.getCredentialsExpired() != null) {
                        ((User)user.get()).setCredentialsExpired(data.getCredentialsExpired());
                    }
                    ((User)user.get()).setLastLogon(LocalDate.now());
                    if (data.getEnabled() != null) {
                        if (data.getEnabled().booleanValue()) {
                            ((User)user.get()).setEnabled(Integer.valueOf(1));
                        } else {
                            ((User)user.get()).setEnabled(Integer.valueOf(0));
                        }
                    }
                    if (data.getEmailId() != null) {
                        ((User)user.get()).setEmailId(data.getEmailId());
                    }
                    if (data.getDescription() != null) {
                        ((User)user.get()).setDescription(data.getDescription());
                    }
                    if (data.getSipPassword() != null) {
                        ((User)user.get()).setSipPassword(data.getSipPassword());
                    }
                    if (data.getIsOnDemand() != null) {
                        ((User)user.get()).setIsOnDemand(data.getIsOnDemand());
                    }
                    if (data.getMaxNoAnswer() != null) {
                        ((User)user.get()).setMaxNoAnswer(data.getMaxNoAnswer());
                    }
                    if (data.getWrapUpTime() != null) {
                        ((User)user.get()).setWrapUpTime(data.getWrapUpTime());
                    }
                    if (data.getRejectDelayTime() != null) {
                        ((User)user.get()).setRejectDelayTime(data.getRejectDelayTime());
                    }
                    if (data.getBusyDelayTime() != null) {
                        ((User)user.get()).setBusyDelayTime(data.getBusyDelayTime());
                    }
                    if (data.getNoAnswerDelayTime() != null) {
                        ((User)user.get()).setNoAnswerDelayTime(data.getNoAnswerDelayTime());
                    }
                    if (data.getCallTimeout() != null) {
                        ((User)user.get()).setCallTimeout(data.getCallTimeout());
                    }
                    if (data.getAutoAnswer() != null) {
                        ((User)user.get()).setAutoAnswer(data.getAutoAnswer());
                    }
                    if (data.getLocation() != null) {
                        ((User)user.get()).setLocation(data.getLocation());
                    }
                    if (data.getCanSendSms() != null) {
                        ((User)user.get()).setCanSendSms(data.getCanSendSms());
                    }
                    if (data.getOutBoundGateway() != null) {
                        ((User)user.get()).setOutBoundGateway(data.getOutBoundGateway());
                    }
                    if (data.getIpAddress() != null) {
                        ((User)user.get()).setIpAddress(data.getIpAddress());
                    }
                    ((User)user.get()).setUpdatedBy(principal.getName());
                    ((User)user.get()).setUpdatedOn(LocalDateTime.now());
                    if (data.getPassword() != null) {
                        ((User)user.get()).setPassword(this.bcryptEncoder.encode((CharSequence)data.getPassword()));
                        ((User)user.get()).setLastPasswordChange(LocalDate.now());
                        if (StringUtils.hasText((String)this.getXmPPServer())) {
                            try {
                                this.updateXmPPUser(this.getXmPPServer(), ((User)user.get()).getUsername(), data.getPassword());
                            }
                            catch (Exception e) {
                                logger.error("Unable to update xmPP user password");
                            }
                        }
                    }
                    if (data.getDispatcherAutoAnswer() != null) {
                        ((User)user.get()).setDispatcherAutoAnswer(data.getDispatcherAutoAnswer());
                    }
                    if (data.getRingAnswerCount() != null) {
                        ((User)user.get()).setRingAnswerCount(data.getRingAnswerCount());
                    }
                    if (data.getPublicEmergencyNumber() != null) {
                        ((User)user.get()).setPublicEmergencyNumber(data.getPublicEmergencyNumber());
                    }
                    if (data.getBroadcastNumber() != null) {
                        ((User)user.get()).setBroadcastNumber(data.getBroadcastNumber());
                    }
                    if (data.getAreaId() != null) {
                        ((User)user.get()).setAreaId(data.getAreaId());
                    }
                    if (data.getRefId() != null) {
                        ((User)user.get()).setRefId(data.getRefId());
                    }
                    try {
                        if (data.getVip().booleanValue()) {
                            if (this.checkConferenceUserByName(data.getUsername())) {
                                this.extensionsServicesService.deleteVipMaster(true, ((User)user.get()).getUsername());
                            } else if (StringUtils.hasText((String)data.getContactNo())) {
                                this.extensionsServicesService.deleteVipMaster(false, ((User)user.get()).getContactNo());
                            }
                            VipMaster vipMaster = new VipMaster();
                            vipMaster.setName(data.getVipName());
                            if (this.checkConferenceUserByName(data.getUsername())) {
                                vipMaster.setOfficeExtension(data.getUsername());
                            } else {
                                if (StringUtils.hasText((String)data.getContactNo())) {
                                    this.extensionsServicesService.deleteVipMaster(false, ((User)user.get()).getContactNo());
                                }
                                vipMaster.setOfficeExtension(data.getContactNo());
                            }
                            vipMaster.setDesignation(data.getDesignation());
                            vipMaster.setPhone(data.getRank().toString());
                            if (this.vipMasterRepository.existsByPhone(data.getRank())) {
                                returnValue.setStatus(Constants.Error.ERROR);
                                returnValue.setMessage("Unable to update user");
                                returnValue.setMessageDetail("select unique rank");
                                logger.error(returnValue.getMessageDetail() + ",from vip master list");
                                return returnValue;
                            }
                            this.vipMasterRepository.save((Object)vipMaster);
                            ((User)user.get()).setVipUser(Boolean.valueOf(true));
                        } else {
                            if (this.checkConferenceUserByName(data.getUsername())) {
                                this.extensionsServicesService.deleteVipMaster(true, ((User)user.get()).getContactNo());
                            } else if (StringUtils.hasText((String)data.getContactNo())) {
                                this.extensionsServicesService.deleteVipMaster(false, ((User)user.get()).getContactNo());
                            }
                            ((User)user.get()).setVipUser(Boolean.valueOf(false));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while updating vipMaster data:{}", (Object)e.getMessage());
                    }
                    this.usersService.updateUser(data, principal);
                    this.userRepository.save(user.get());
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Updated");
                    returnValue.setMessageDetail("User Updated successfully");
                    logger.info(returnValue.getMessage());
                    break block50;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("User not found");
                logger.info(returnValue.getMessage());
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
                returnValue.setMessage("Unable to update user");
                returnValue.setMessageDetail("please Contact to administrator");
                logger.info(returnValue.getMessage());
            }
        }
        return returnValue;
    }

    public RequestResponse deleteUser(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            for (Integer ids : data.getIntId()) {
                Optional user = this.userRepository.findById((Object)ids);
                List userRoleRecords = this.userRoleRepository.findByUser((User)user.get());
                if (user.isPresent()) {
                    Optional customerAccountOptional;
                    String userToDelete = ((User)user.get()).getUsername();
                    if (this.checkConferenceUserByName(((User)user.get()).getUsername())) {
                        this.extensionsServicesService.deleteVipMaster(true, ((User)user.get()).getUsername());
                    } else if (StringUtils.hasText((String)((User)user.get()).getContactNo())) {
                        this.extensionsServicesService.deleteVipMaster(false, ((User)user.get()).getContactNo());
                    }
                    if (this.deleteConferenceRoleExtension((User)user.get())) {
                        this.extensionsService.deleteBySingleExtensionValue(((User)user.get()).getUsername());
                    }
                    if (!userRoleRecords.isEmpty()) {
                        this.userRoleRepository.deleteAll((Iterable)userRoleRecords);
                    }
                    if ((customerAccountOptional = this.customerAccountRepository.findByProfileId(userToDelete)).isPresent()) {
                        this.customerAccountRepository.deleteById((Object)((CustomerAccount)customerAccountOptional.get()).getId());
                        logger.info("User is deleted from customer account with username {}", (Object)userToDelete);
                    }
                    this.deleteExtensionIfExistsByUserId(ids);
                    List extensionList = this.extensionRepository.findByAssignedUserIgnoreCase(userToDelete.trim());
                    if (!extensionList.isEmpty()) {
                        for (Extension e : extensionList) {
                            logger.info("Finding Entity:{} for User:{}", (Object)e.getExtension(), (Object)e.getAssignedUser());
                            e.setAssignedUser("");
                            logger.info("Extension '{}' assigned user cleared for username '{}'", (Object)e.getExtension(), (Object)e.getAssignedUser());
                        }
                        this.extensionRepository.saveAllAndFlush((Iterable)extensionList);
                    }
                    this.userRepository.deleteById((Object)ids);
                    Optional usersCoralAppsOptional = this.usersRepositoryCoralApps.findByUsername(userToDelete);
                    if (usersCoralAppsOptional.isPresent()) {
                        this.usersRepositoryCoralApps.deleteByUsername1(userToDelete);
                    }
                    if (StringUtils.hasLength((String)this.getXmPPServer())) {
                        try {
                            this.deleteXmPPUser(this.getXmPPServer(), userToDelete);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("deleted");
                    returnValue.setMessageDetail("Record deleted successfully");
                    logger.info(returnValue.getMessage());
                    continue;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete user");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public Optional<User> getUserByName(String userName) {
        return this.userRepository.findByUsername(userName);
    }

    public String retrieveUser(String ipAddress, String apiKey) {
        Optional userOptional = this.userRepository.findByKeyValue(apiKey);
        if (userOptional.isPresent() && ((User)userOptional.get()).getIpAddress() != null) {
            User user = (User)userOptional.get();
            return ipAddress.equals(((User)userOptional.get()).getIpAddress()) || ((User)userOptional.get()).getIpAddress().equals("all-ip") ? user.getUsername() : null;
        }
        return null;
    }

    public void createUserAgent(Integer i, Principal principal) {
        String username = "agent";
        User user = new User();
        user.setUsername(String.valueOf(i));
        user.setPassword(this.bcryptEncoder.encode((CharSequence)"1234"));
        user.setEnabled(Integer.valueOf(1));
        user.setDescription(username + i);
        user.setCreatedOn(LocalDateTime.now());
        user.setContactNo(String.valueOf(i));
        user.setLastLogon(LocalDate.now());
        user.setLastPasswordChange(LocalDate.now());
        user.setIsOnDemand(Boolean.valueOf(false));
        Role role = this.getUsersRole("ROLE_AGENT");
        if (role != null) {
            List<Integer> roleIds = Collections.singletonList(role.getId());
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String roleJson = objectMapper.writeValueAsString(roleIds);
                user.setRole(roleJson);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        this.userRepository.save((Object)user);
        UserModel data = new UserModel();
        data.setUsername(String.valueOf(i));
        data.setPassword(this.bcryptEncoder.encode((CharSequence)"1234"));
        data.setEnabled(Boolean.valueOf(true));
        data.setDescription(username + i);
        data.setCreatedOn(LocalDateTime.now());
        data.setContactNo(String.valueOf(i));
        data.setLastLogon(LocalDate.now());
        data.setLastPasswordChange(LocalDate.now());
        data.setIsOnDemand(Boolean.valueOf(false));
        this.usersService.createNewUser(data, principal);
    }

    public RequestResponse getUserByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean apwUser = false;
        boolean cpwUser = false;
        boolean opwUser = false;
        boolean edpUser = false;
        if (this.checkOPWUser(principal.getName())) {
            opwUser = true;
        } else if (this.checkAPWUser(principal.getName())) {
            apwUser = true;
        } else if (this.checkCPWUser(principal.getName())) {
            cpwUser = true;
        } else if (this.checkEDPUser(principal.getName())) {
            edpUser = true;
        } else if (this.checkAdminUser(principal.getName())) {
            adminUser = true;
        }
        Specification filters = UserSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)adminUser, (boolean)apwUser, (boolean)cpwUser, (boolean)opwUser, (boolean)edpUser);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updatePassword(ChangePasswordModel data, Principal userData) {
        RequestResponse returnValue;
        block12: {
            returnValue = new RequestResponse();
            Optional user = this.userRepository.findByUsername(userData.getName());
            if (user.isPresent() && this.bcryptEncoder.matches((CharSequence)data.getOldPassword(), ((User)user.get()).getPassword())) {
                try {
                    if (this.passwordConversion.changePasswordValid(((User)user.get()).getId(), data.getNewPassword())) {
                        if (!this.bcryptEncoder.matches((CharSequence)data.getNewPassword(), ((User)user.get()).getPassword())) {
                            if (data.getNewPassword().equals(data.getConfirmPassword())) {
                                ((User)user.get()).setPassword(this.bcryptEncoder.encode((CharSequence)data.getNewPassword()));
                                ((User)user.get()).setLastPasswordChange(LocalDate.now());
                                this.userRepository.save(user.get());
                                ReturnField field = new ReturnField();
                                field.setId(((User)user.get()).getId().intValue());
                                field.setDescription(((User)user.get()).getUsername());
                                this.checkPasswordChangeHistory(userData.getName());
                                ChangePassword passwordData = new ChangePassword();
                                passwordData.setCreatedBy(userData.getName());
                                passwordData.setCreatedOn(LocalDateTime.now());
                                passwordData.setPassword(this.bcryptEncoder.encode((CharSequence)data.getNewPassword()));
                                passwordData.setUserId(Long.valueOf(((User)user.get()).getId().intValue()));
                                this.changePasswordRepository.save((Object)passwordData);
                                returnValue.setData((Object)field);
                                returnValue.setStatus(Constants.Error.OK);
                                returnValue.setMessage("Successfully Changed Your password");
                                logger.info(returnValue.getMessage());
                                if (StringUtils.hasText((String)this.getXmPPServer())) {
                                    try {
                                        this.updateXmPPUser(this.getXmPPServer(), ((User)user.get()).getUsername(), data.getNewPassword());
                                    }
                                    catch (Exception e) {
                                        logger.error("Unable to update xmPP user password");
                                    }
                                }
                            } else {
                                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                                returnValue.setMessage("Unable to change the password");
                                returnValue.setMessageDetail("newPassword & confirmPassword does not match");
                                logger.info(returnValue.getMessage());
                            }
                        } else {
                            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                            returnValue.setMessage("Unable to change your password");
                            returnValue.setMessageDetail("please enter the different newPassword");
                            logger.info(returnValue.getMessage());
                        }
                        break block12;
                    }
                    returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                    returnValue.setMessage("last three password not be same");
                    returnValue.setMessageDetail("please enter the different newPassword");
                    logger.error(returnValue.getMessage());
                }
                catch (Exception ex) {
                    returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                    returnValue.setMessage("Unable to change password");
                    returnValue.setMessageDetail("Contact with your administrator");
                    logger.info(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Unable to change password");
                returnValue.setMessageDetail("wrong username or oldPassword");
                logger.info(returnValue.getMessage());
            }
        }
        return returnValue;
    }

    public RequestResponse getUsersDropdownList() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<UserListModel> addValue = new ArrayList<UserListModel>();
        List list = this.userRepository.findAllByOrderById();
        for (User user : list) {
            UserListModel data = new UserListModel();
            data.setId(Long.valueOf(user.getId().intValue()));
            data.setUsername(user.getUsername());
            data.setDescription(user.getUsername() + "-" + user.getDescription());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse updateMultipleUser(UserMultipleUpdateModel data, Principal principal) {
        logger.debug("Get user list for update:", (Object)data.getUserId());
        RequestResponse returnValue = new RequestResponse();
        for (Integer user : data.getUserId()) {
            ObjectMapper obj;
            ObjectMapper obj2;
            Optional userDetail = this.userRepository.findById((Object)user);
            if (!userDetail.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.error(returnValue.getMessage());
                return returnValue;
            }
            if (data.getRole() != null && !data.getRole().isEmpty()) {
                List deletePreviousUserRole = this.userRoleRepository.findByUser((User)userDetail.get());
                this.userRoleRepository.deleteAll((Iterable)deletePreviousUserRole);
                obj2 = new ObjectMapper();
                try {
                    ((User)userDetail.get()).setRole(obj2.writeValueAsString((Object)data.getRole()));
                }
                catch (JsonProcessingException e) {
                    logger.error("error while saving role on user creation");
                }
                for (Integer roleId : data.getRole()) {
                    UserRole userRole = new UserRole();
                    Optional roleMaster = this.roleRepository.findById(roleId.intValue());
                    userRole.setUser((User)userDetail.get());
                    userRole.setRole((Role)roleMaster.get());
                    userRole.setCreatedBy(principal.getName());
                    userRole.setCreatedOn(LocalDateTime.now());
                    this.userRoleRepository.save((Object)userRole);
                }
            }
            if (data.getGroup() != null) {
                List deletePreviousGroup = this.userGroupRepository.findByUsers(Long.valueOf(((User)userDetail.get()).getId().intValue()));
                this.userGroupRepository.deleteAll((Iterable)deletePreviousGroup);
                obj2 = new ObjectMapper();
                try {
                    ((User)userDetail.get()).setUserGroup(obj2.writeValueAsString((Object)data.getGroup()));
                }
                catch (JsonProcessingException e) {
                    logger.error("error while saving group on user creation");
                }
                if (data.getGroup().size() >= 0) {
                    for (Integer group : data.getGroup()) {
                        if (group == null) continue;
                        Optional groupData = this.userGroupMasterRepository.findById((Object)group);
                        if (groupData.isPresent()) {
                            UserGroup userGroup = new UserGroup();
                            userGroup.setUsers(Long.valueOf(((User)userDetail.get()).getId().intValue()));
                            userGroup.setGroup(Long.valueOf(((UserGroupMaster)groupData.get()).getId().intValue()));
                            userGroup.setCreatedBy(principal.getName());
                            userGroup.setCreatedOn(LocalDateTime.now());
                            this.userGroupRepository.save((Object)userGroup);
                        }
                        try {
                            if (!StringUtils.hasText((String)this.getXmPPServer())) continue;
                            String xmPPServer = this.getXmPPServer();
                            ArrayList<String> users = new ArrayList<String>();
                            Optional userData = this.userRepository.findById((Object)((User)userDetail.get()).getId());
                            if (userData.isPresent()) {
                                String xmPPUser = ((User)userData.get()).getUsername() + "@" + xmPPServer;
                                users.add(xmPPUser);
                            }
                            if (!groupData.isPresent()) continue;
                            this.userGroupMasterService.updateUserWithGroup(((UserGroupMaster)groupData.get()).getCode(), users);
                            logger.info("xmPP user associated with group:{}", users);
                        }
                        catch (Exception e) {
                            logger.info("Unable to associated xmPP user with group:{}", (Object)e.getMessage());
                        }
                    }
                }
            }
            if (data.getNodeId() != null) {
                obj = new ObjectMapper();
                try {
                    ((User)userDetail.get()).setNodeId(obj.writeValueAsString((Object)data.getNodeId()));
                }
                catch (JsonProcessingException e) {
                    logger.error("error while saving group on user creation");
                }
            }
            if (data.getCanSendSms() != null) {
                ((User)userDetail.get()).setCanSendSms(data.getCanSendSms());
            }
            if (data.getLocation() != null) {
                ((User)userDetail.get()).setLocation(data.getLocation());
            }
            if (data.getOutBoundGateway() != null) {
                ((User)userDetail.get()).setOutBoundGateway(data.getOutBoundGateway());
            }
            if (data.getIsOnDemand() != null) {
                ((User)userDetail.get()).setIsOnDemand(data.getIsOnDemand());
            }
            if (data.getMaxNoAnswer() != null) {
                ((User)userDetail.get()).setMaxNoAnswer(data.getMaxNoAnswer());
            }
            if (data.getWrapUpTime() != null) {
                ((User)userDetail.get()).setWrapUpTime(data.getWrapUpTime());
            }
            if (data.getRejectDelayTime() != null) {
                ((User)userDetail.get()).setRejectDelayTime(data.getRejectDelayTime());
            }
            if (data.getBusyDelayTime() != null) {
                ((User)userDetail.get()).setBusyDelayTime(data.getBusyDelayTime());
            }
            if (data.getNoAnswerDelayTime() != null) {
                ((User)userDetail.get()).setNoAnswerDelayTime(data.getNoAnswerDelayTime());
            }
            if (data.getCallTimeout() != null) {
                ((User)userDetail.get()).setCallTimeout(data.getCallTimeout());
            }
            if (data.getAutoAnswer() != null) {
                ((User)userDetail.get()).setAutoAnswer(data.getAutoAnswer());
            }
            if (data.getZoneId() != null) {
                obj = new ObjectMapper();
                try {
                    ((User)userDetail.get()).setZoneId(obj.writeValueAsString((Object)data.getZoneId()));
                }
                catch (JsonProcessingException e) {
                    logger.error("error while saving role on user creation");
                }
            }
            this.userRepository.save(userDetail.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<UserModel> entityToModelConversion(List<User> user) {
        ArrayList<UserModel> addValue = new ArrayList<UserModel>();
        List group = new ArrayList();
        for (User row : user) {
            ObjectMapper objectMapper;
            UserModel data = new UserModel();
            data.setId(row.getId());
            data.setUserType(row.getUserType());
            data.setUsername(row.getUsername());
            data.setPassword(row.getPassword());
            data.setDescription(row.getDescription());
            data.setEnabled(Boolean.valueOf(row.getEnabled() != 0));
            data.setEmailId(row.getEmailId() != null ? row.getEmailId() : "");
            data.setContactNo(row.getContactNo());
            if (row.getContactNo() != null && StringUtils.hasText((String)row.getContactNo())) {
                Optional ext = this.extensionsRepository.findByExtension(row.getContactNo());
                if (ext.isPresent()) {
                    data.setDepartment(((Extension)ext.get()).getDepartment());
                    data.setDesignation(((Extension)ext.get()).getDesignation());
                } else {
                    data.setDepartment("");
                    data.setDesignation("");
                }
            }
            data.setCreatedBy(row.getCreatedBy());
            data.setCreatedOn(row.getCreatedOn());
            data.setUpdatedBy(row.getUpdatedBy());
            data.setUpdatedOn(row.getUpdatedOn());
            data.setStatus(row.getStatus());
            data.setLastLogon(row.getLastLogon());
            data.setIsOnDemand(row.getIsOnDemand());
            data.setMaxNoAnswer(row.getMaxNoAnswer());
            data.setWrapUpTime(row.getWrapUpTime());
            data.setRejectDelayTime(row.getRejectDelayTime());
            data.setBusyDelayTime(row.getBusyDelayTime());
            data.setNoAnswerDelayTime(row.getNoAnswerDelayTime());
            data.setCallTimeout(row.getCallTimeout());
            data.setAutoAnswer(row.getAutoAnswer());
            data.setDoNotDisturb(row.getDoNotDisturb());
            data.setFailedAttempts(row.getFailedAttempts());
            data.setAccountExpired(row.getAccountExpired());
            data.setAccountLocked(row.getAccountLocked());
            data.setCredentialsExpired(row.getCredentialsExpired());
            data.setLastPasswordChange(row.getLastPasswordChange());
            data.setOutBoundGateway(row.getOutBoundGateway());
            data.setCanSendSms(row.getCanSendSms());
            data.setLocation(row.getLocation());
            data.setUserGroup(row.getUserGroup());
            data.setDispatcherAutoAnswer(row.getDispatcherAutoAnswer());
            data.setRingAnswerCount(row.getRingAnswerCount());
            data.setPublicEmergencyNumber(row.getPublicEmergencyNumber());
            data.setBroadcastNumber(row.getBroadcastNumber());
            data.setAreaId(row.getAreaId());
            data.setLatitude(this.getUserLocation(row.getContactNo()).getLatitude());
            data.setLongitude(this.getUserLocation(row.getContactNo()).getLongitude());
            data.setRouteAssociated(this.userShiftService.getUserRouteAssociation(row.getUsername()));
            data.setColorCode(this.getColor(row.getUsername()));
            data.setRefId(row.getRefId());
            try {
                data.setAvailableRouteShift(this.userShiftService.getUserShiftForRoute(row.getUsername()));
                data.setAvailableZoneShift((Object)this.userShiftService.getUserShiftForZone(row.getUsername()));
            }
            catch (Exception e) {
                logger.error("Unable to return available shift");
            }
            if (StringUtils.hasLength((String)row.getUserGroup())) {
                objectMapper = new ObjectMapper();
                try {
                    group = (List)objectMapper.readValue(row.getUserGroup(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    data.setGroup(group);
                }
                catch (JsonMappingException e) {
                    e.printStackTrace();
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
            data.setRoleOfList(row.getRole());
            data.setAgentShiftId(row.getAgentShiftId());
            try {
                ObjectMapper objectMapper1 = new ObjectMapper();
                List roleData = new ArrayList();
                List userRole = this.userRoleRepository.findByUser(row);
                HashSet<Integer> listOfUserRoleId = new HashSet<Integer>();
                for (UserRole id : userRole) {
                    listOfUserRoleId.add(id.getRole().getId());
                }
                if (StringUtils.hasLength((String)row.getRole())) {
                    roleData = (List)objectMapper1.readValue(row.getRole(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                }
                HashSet<Integer> setValue = new HashSet<Integer>();
                setValue.addAll(listOfUserRoleId);
                setValue.addAll(roleData);
                data.setRole(new ArrayList(setValue));
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            if (StringUtils.hasLength((String)row.getZoneId())) {
                objectMapper = new ObjectMapper();
                try {
                    List zoneList = (List)objectMapper.readValue(row.getZoneId(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    data.setZoneId(zoneList);
                }
                catch (JsonMappingException e) {
                    e.printStackTrace();
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
            if (!group.isEmpty()) {
                ArrayList<String> groupDescList = new ArrayList<String>();
                for (Integer id : group) {
                    Optional userGroup = this.userGroupMasterRepository.findById((Object)id);
                    if (!userGroup.isPresent()) continue;
                    groupDescList.add(((UserGroupMaster)userGroup.get()).getDescription());
                }
                data.setGroupName(groupDescList);
            } else {
                data.setGroupName(Collections.emptyList());
            }
            if (StringUtils.hasLength((String)row.getNodeId())) {
                objectMapper = new ObjectMapper();
                try {
                    List nodeId = (List)objectMapper.readValue(row.getNodeId(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    data.setNodeId(nodeId);
                }
                catch (JsonMappingException e) {
                    e.printStackTrace();
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
            if (row.getVipUser().booleanValue()) {
                data.setVip(row.getVipUser());
                if (this.checkConferenceUserByName(row.getUsername())) {
                    List getVip = this.vipMasterRepository.findByOfficeExtension(data.getUsername());
                    if (!getVip.isEmpty()) {
                        VipMaster vipData = (VipMaster)getVip.get(0);
                        data.setVipName(vipData.getName());
                        data.setRank(vipData.getPhone());
                        data.setDesignation(vipData.getDesignation());
                    } else {
                        List getVip1 = this.vipMasterRepository.findByOfficeExtension(data.getContactNo());
                        if (!getVip1.isEmpty()) {
                            VipMaster vipData = (VipMaster)getVip1.get(0);
                            data.setVipName(vipData.getName());
                            data.setRank(vipData.getPhone());
                            data.setDesignation(vipData.getDesignation());
                        }
                    }
                }
            } else {
                data.setVip(row.getVipUser());
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse createAPIKey(Principal principal) {
        logger.debug("create new API-KEY : {} ");
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                User user = (User)userOptional.get();
                if (user.getKeyValue() == null || user.getKeyValue().isEmpty()) {
                    String key = UUID.randomUUID().toString();
                    user.setKeyValue(key);
                } else {
                    String newKey = UUID.randomUUID().toString();
                    user.setKeyValue(newKey);
                }
                this.userRepository.save((Object)user);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("API-KEY Created Successfully");
                returnValue.setData((Object)user.getKeyValue());
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("User is not present");
                logger.error(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create API-KEY");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public void checkPasswordChangeHistory(String username) {
        List list = this.changePasswordRepository.findAllByCreatedByOrderByIdAsc(username);
        List config = this.passwordConfigRepository.findAll();
        Integer passwordChangeHistoryLimit = ((PasswordConfig)config.get(0)).getPwdChangeHistory();
        if (list.size() == passwordChangeHistoryLimit.intValue()) {
            this.changePasswordRepository.deleteById((Object)((ChangePassword)list.get(0)).getId());
        }
    }

    public RequestResponse getAllUCUsers() {
        Optional role = this.roleRepository.findByShortCode("ROLE_USERS");
        if (!role.isPresent()) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("'ROLE_USERS' not found");
            return returnValue;
        }
        List userRoles = this.userRoleRepository.findByRole((Role)role.get());
        if (userRoles.isEmpty()) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("No users with ROLE_USERS found");
            return returnValue;
        }
        ArrayList<UserListModel> userList = new ArrayList<UserListModel>();
        for (UserRole userRole : userRoles) {
            User user = userRole.getUser();
            UserListModel data = new UserListModel();
            data.setDescription(user.getDescription());
            data.setUsername(user.getUsername());
            data.setId(Long.valueOf(user.getId().intValue()));
            userList.add(data);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(userList);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public boolean checkOPWUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional role = this.roleRepository.findByShortCode("ROLE_OPW_ADMIN");
        return role.isPresent() && rolesOfUser.contains(((Role)role.get()).getId());
    }

    public boolean checkAPWUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional role = this.roleRepository.findByShortCode("ROLE_APW_ADMIN");
        return role.isPresent() && rolesOfUser.contains(((Role)role.get()).getId());
    }

    public boolean checkCPWUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional role = this.roleRepository.findByShortCode("ROLE_CPW_ADMIN");
        return role.isPresent() && rolesOfUser.contains(((Role)role.get()).getId());
    }

    public boolean checkEDPUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional role = this.roleRepository.findByShortCode("ROLE_EDP_ADMIN");
        return role.isPresent() && rolesOfUser.contains(((Role)role.get()).getId());
    }

    public boolean checkAdminUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional adminRole = this.roleRepository.findByShortCode("ROLE_ADMIN");
        return adminRole.isPresent() && rolesOfUser.contains(((Role)adminRole.get()).getId());
    }

    public boolean checkManagerUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional adminRole = this.roleRepository.findByShortCode("ROLE_MANAGER");
        return adminRole.isPresent() && rolesOfUser.contains(((Role)adminRole.get()).getId());
    }

    public boolean checkAgentUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        List<String> roleShortCodes = Arrays.asList("ROLE_AGENT", "ROLE_OCADMIN");
        List roles = this.roleRepository.findByShortCodeIn(roleShortCodes);
        for (Role role : roles) {
            if (!rolesOfUser.contains(role.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean checkGroupAdmin(String userName) {
        logger.info("checking user have groupAdmin role.....");
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional groupAdminRole = this.roleRepository.findByShortCode("ROLE_GROUP_ADMIN");
        return groupAdminRole.isPresent() && rolesOfUser.contains(((Role)groupAdminRole.get()).getId());
    }

    public boolean checkRoleTL(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        List<String> roleShortCodes = Arrays.asList("ROLE_TEAMLEADER");
        List roles = this.roleRepository.findByShortCodeIn(roleShortCodes);
        for (Role role : roles) {
            if (!rolesOfUser.contains(role.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean checkUserHasRole(String userName, List<String> roleShortCodes) {
        List userRoleIds = this.userRoleService.roleIdOfParticularUser(userName);
        List roles = this.roleRepository.findByShortCodeIn(roleShortCodes);
        for (Role role : roles) {
            if (!userRoleIds.contains(role.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean checkRoleTaskManager(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        List<String> roleShortCodes = Arrays.asList("ROLE_TASKMANAGER");
        List roles = this.roleRepository.findByShortCodeIn(roleShortCodes);
        for (Role role : roles) {
            if (!rolesOfUser.contains(role.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean checkRoleDispatcher(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        List<String> roleShortCodes = Arrays.asList("ROLE_RAILWAY_DISPATCHER", "ROLE_MCX_DISPATCHER");
        List roles = this.roleRepository.findByShortCodeIn(roleShortCodes);
        for (Role role : roles) {
            if (!rolesOfUser.contains(role.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean checkRoleMCXUser(String userName) {
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        List<String> roleShortCodes = Arrays.asList("ROLE_ENGINEER");
        List roles = this.roleRepository.findByShortCodeIn(roleShortCodes);
        for (Role role : roles) {
            if (!rolesOfUser.contains(role.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean checkConfModeratorAdmin(String userName) {
        logger.info("checking user have conferenceModerator role.....");
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional confModeratorRole = this.roleRepository.findByShortCode("ROLE_UC_CONFERENCE_MODERATOR");
        return confModeratorRole.isPresent() && rolesOfUser.contains(((Role)confModeratorRole.get()).getId());
    }

    public Integer getRoleConferenceId() {
        Optional roleData = this.roleRepository.findByShortCode("ROLE_CONFERENCE");
        if (roleData.isPresent()) {
            return ((Role)roleData.get()).getId();
        }
        return null;
    }

    public void regenerateSIPCredentials() {
        try {
            File[] files;
            this.subscriberRepository.deleteAllInBatch();
            this.locationSwitchRepository.deleteAllInBatch();
            File subscriberDir = new File("/etc/coraltele/sipserver/conf/directory/default");
            if (subscriberDir.exists() && subscriberDir.isDirectory() && (files = subscriberDir.listFiles()) != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".xml") || file.delete()) continue;
                    logger.warn("Failed to delete file: {}", (Object)file.getAbsolutePath());
                }
            }
            String domain = this.extensionFileConfigurationService.getPBXDomain();
            this.extensionRepository.findAll().forEach(row -> {
                if (row.getExtensionType().equalsIgnoreCase("phone") || row.getExtensionType().equalsIgnoreCase("agent") || row.getExtensionType().equalsIgnoreCase("fax")) {
                    String extension = row.getExtension();
                    String extensionPassword = row.getSipPassword();
                    if (!StringUtils.hasText((String)extensionPassword)) {
                        logger.error("SIP password is empty for extension {}", (Object)extension);
                        return;
                    }
                    try {
                        String sipPassword = this.sipPasswordConversion.decryptContains(extensionPassword);
                        String passwordHA1 = extension + ":" + domain + ":" + sipPassword;
                        String passwordHA1B = extension + "@" + domain + ":" + domain + ":" + sipPassword;
                        String passwordHashHA1 = this.encryptPassword(passwordHA1);
                        String passwordHashHA1B = this.encryptPassword(passwordHA1B);
                        String filePath = "/etc/coraltele/sipserver/conf/directory/default/" + extension + ".xml";
                        try {
                            XmlFileGenerator.generateXmlFile((String)extension, (String)passwordHashHA1, (String)filePath);
                            logger.info("Regenerated SIP credentials for extension {}", (Object)extension);
                        }
                        catch (Exception ex) {
                            logger.error("Error generating XML file for extension {}: {}", (Object)extension, (Object)ex.getMessage());
                        }
                        Subscriber subscriber = new Subscriber();
                        subscriber.setUsername(extension);
                        subscriber.setDomain(domain);
                        subscriber.setPassword(sipPassword);
                        subscriber.setHa1(passwordHashHA1);
                        subscriber.setHa1b(passwordHashHA1B);
                        this.subscriberRepository.save((Object)subscriber);
                        logger.info("Subscriber saved for extension {}", (Object)extension);
                    }
                    catch (Exception e) {
                        logger.error("Error decrypting SIP password for extension {}: {}", (Object)extension, (Object)e.getMessage());
                    }
                }
            });
            this.agentService.reloadXml();
        }
        catch (Exception e) {
            logger.error("Error regenerating SIP credentials", (Throwable)e);
        }
    }

    public RequestResponse createExtensionByUsername(ServiceCodeAttribute extensionRange) {
        RequestResponse returnValue;
        block8: {
            returnValue = new RequestResponse();
            boolean checkOutbound = this.outBoundCosService.checkOutboundCosWithZerosCos();
            boolean checkInbound = this.inBoundCosService.checkInboundCosWithZerosCos();
            boolean checkExtensionRange = this.checkExtensionExist(extensionRange);
            try {
                String extSipPassword = this.extensionFileConfigurationService.getSipPassword();
                if (!checkExtensionRange) {
                    String domain = this.extensionFileConfigurationService.getDomain();
                    if (domain.equals("null") || domain == null || domain.equals("")) {
                        domain = "";
                    }
                    String password = extensionRange.getFrom() + ":" + domain + ":1234";
                    String sippwd = this.encryptPassword(password);
                    String filePath = "/etc/coraltele/sipserver/conf/directory/default/" + extensionRange.getFrom() + ".xml";
                    try {
                        XmlFileGenerator.generateXmlFile((String)extensionRange.getFrom(), (String)sippwd, (String)filePath);
                    }
                    catch (IOException ex) {
                        logger.error("Error generating XML file for extension {}: {}", (Object)extensionRange.getFrom(), (Object)ex.getMessage());
                        throw new RuntimeException("Error generating XML file for extension " + extensionRange.getFrom(), ex);
                    }
                    if (!checkOutbound) {
                        this.outBoundCosService.createOutboundCoswithZerosCos();
                    }
                    if (!checkInbound) {
                        this.inBoundCosService.createInboundCosWithZerosCos();
                    }
                    Extension extensions = new Extension();
                    extensions.setExtension(extensionRange.getFrom());
                    extensions.setExtensionType("phone");
                    extensions.setSipPassword(this.sipPasswordConversion.encryptContains(extSipPassword));
                    extensions.setDayOutboundCos("0");
                    extensions.setDayInboundCos("0");
                    extensions.setNightOutboundCos("0");
                    extensions.setNightInboundCos("0");
                    this.extensionRepository.save((Object)extensions);
                    ExtensionsServices extService = new ExtensionsServices();
                    extService.setServiceCode("dialing-intercom");
                    extService.setExtension(extensionRange.getFrom());
                    ExtensionsServices extService1 = new ExtensionsServices();
                    extService1.setServiceCode("dialing-local");
                    extService1.setExtension(extensionRange.getFrom());
                    this.extensionsServicesRepository.save((Object)extService);
                    this.extensionsServicesRepository.save((Object)extService1);
                    DidMapping didMapping = new DidMapping();
                    didMapping.setExtNumber(extensionRange.getFrom());
                    this.didMappingRepository.save((Object)didMapping);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Extensions created");
                    returnValue.setMessageDetail("All extensions have created successfully");
                    logger.info("Extension saved : {}", (Object)returnValue.getMessage());
                    break block8;
                }
                returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
                returnValue.setMessage("Can't create");
                returnValue.setMessageDetail("Extensions already created");
                logger.error(returnValue.getMessageDetail());
            }
            catch (Exception ex) {
                returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
                returnValue.setMessage("Can't Create ");
                returnValue.setMessageDetail("Extension already present, from given range");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        }
        return returnValue;
    }

    public boolean checkExtensionExist(ServiceCodeAttribute data) {
        Optional ext = this.extensionRepository.findByExtension(data.getFrom());
        return ext.isPresent();
    }

    protected String encryptPassword(String password) {
        StringBuffer sb = null;
        String rtrVal = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());
            byte[] byteData = md.digest();
            sb = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("exception at MD5 encryption:" + e.getMessage());
        }
        if (sb != null) {
            rtrVal = sb.toString().trim();
        }
        return rtrVal;
    }

    public RequestResponse updateByUsername(UserModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findByUsername(data.getUsername());
            if (user.isPresent()) {
                ((User)user.get()).setLastLogon(LocalDate.now());
                if (data.getEmailId() != null) {
                    ((User)user.get()).setEmailId(data.getEmailId());
                }
                if (data.getDescription() != null) {
                    ((User)user.get()).setDescription(data.getDescription());
                }
                if (data.getIsOnDemand() != null) {
                    ((User)user.get()).setIsOnDemand(data.getIsOnDemand());
                }
                if (data.getMaxNoAnswer() != null) {
                    ((User)user.get()).setMaxNoAnswer(data.getMaxNoAnswer());
                }
                if (data.getWrapUpTime() != null) {
                    ((User)user.get()).setWrapUpTime(data.getWrapUpTime());
                }
                if (data.getRejectDelayTime() != null) {
                    ((User)user.get()).setRejectDelayTime(data.getRejectDelayTime());
                }
                if (data.getBusyDelayTime() != null) {
                    ((User)user.get()).setBusyDelayTime(data.getBusyDelayTime());
                }
                if (data.getNoAnswerDelayTime() != null) {
                    ((User)user.get()).setNoAnswerDelayTime(data.getNoAnswerDelayTime());
                }
                if (data.getCallTimeout() != null) {
                    ((User)user.get()).setCallTimeout(data.getCallTimeout());
                }
                if (data.getAutoAnswer() != null) {
                    ((User)user.get()).setAutoAnswer(data.getAutoAnswer());
                }
                if (data.getLocation() != null) {
                    ((User)user.get()).setLocation(data.getLocation());
                }
                if (data.getCanSendSms() != null) {
                    ((User)user.get()).setCanSendSms(data.getCanSendSms());
                }
                if (data.getOutBoundGateway() != null) {
                    ((User)user.get()).setOutBoundGateway(data.getOutBoundGateway());
                }
                if (data.getIpAddress() != null) {
                    ((User)user.get()).setIpAddress(data.getIpAddress());
                }
                ((User)user.get()).setUpdatedBy(principal.getName());
                ((User)user.get()).setUpdatedOn(LocalDateTime.now());
                this.userRepository.save(user.get());
                Optional agent = this.agentRepository.findByName(data.getUsername());
                if (agent.isPresent()) {
                    if (data.getMaxNoAnswer() != null) {
                        ((Agent)agent.get()).setMaxNoAnswer(data.getMaxNoAnswer().intValue());
                    }
                    if (data.getWrapUpTime() != null) {
                        ((Agent)agent.get()).setWrapUpTime(data.getWrapUpTime().intValue());
                    }
                    if (data.getRejectDelayTime() != null) {
                        ((Agent)agent.get()).setRejectDelayTime(data.getRejectDelayTime().intValue());
                    }
                    if (data.getBusyDelayTime() != null) {
                        ((Agent)agent.get()).setBusyDelayTime(data.getBusyDelayTime().intValue());
                    }
                    if (data.getNoAnswerDelayTime() != null) {
                        ((Agent)agent.get()).setNoAnswerDelayTime(data.getNoAnswerDelayTime().intValue());
                    }
                    this.agentRepository.save(agent.get());
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated success user and agent data");
                returnValue.setMessageDetail("Data Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Either agent or user not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update data");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getUserByUsername(String id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findByUsername(id);
            if (user.isPresent()) {
                ViewUserModel data = new ViewUserModel();
                data.setId(((User)user.get()).getId().intValue());
                data.setUsername(((User)user.get()).getUsername());
                data.setAccountExpired(((User)user.get()).getAccountExpired().booleanValue());
                data.setAccountLocked(((User)user.get()).getAccountLocked().booleanValue());
                data.setCredentialsExpired(((User)user.get()).getCredentialsExpired().booleanValue());
                data.setEnabled(((User)user.get()).getEnabled().intValue());
                data.setEmailId(((User)user.get()).getEmailId());
                data.setContactNo(((User)user.get()).getContactNo());
                data.setDescription(((User)user.get()).getDescription());
                data.setCreatedOn(LocalDateTime.now());
                data.setSipPassword(((User)user.get()).getSipPassword());
                data.setIsOnDemand(((User)user.get()).getIsOnDemand());
                data.setMaxNoAnswer(((User)user.get()).getMaxNoAnswer());
                data.setWrapUpTime(((User)user.get()).getWrapUpTime());
                data.setRejectDelayTime(((User)user.get()).getRejectDelayTime());
                data.setBusyDelayTime(((User)user.get()).getBusyDelayTime());
                data.setNoAnswerDelayTime(((User)user.get()).getNoAnswerDelayTime());
                data.setCallTimeout(((User)user.get()).getCallTimeout());
                data.setAutoAnswer(((User)user.get()).getAutoAnswer());
                data.setLocation(((User)user.get()).getLocation());
                data.setCanSendSms(((User)user.get()).getCanSendSms());
                data.setOutBoundGateway(((User)user.get()).getOutBoundGateway());
                data.setRole(((User)user.get()).getRole());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("user Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public List<String> getAgentList() {
        List users = this.userRepository.findAllByOrderById();
        ArrayList<String> agentList = new ArrayList<String>();
        for (User user : users) {
            if (!this.checkAgentUser(user.getUsername())) continue;
            agentList.add(user.getUsername());
        }
        return agentList;
    }

    public boolean deleteConferenceRoleExtension(User userData) {
        Integer conferenceRoleId = this.getRoleConferenceId();
        List checkExistingRole = this.userRoleRepository.findByUser(userData);
        for (UserRole row : checkExistingRole) {
            if (row.getRole().getId() != conferenceRoleId) continue;
            return true;
        }
        return false;
    }

    public RequestResponse getEngineerUser() {
        Optional role = this.roleRepository.findByShortCode("ROLE_ENGINEER");
        if (!role.isPresent()) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("'ROLE ENGINEER' not found");
            return returnValue;
        }
        List userRoles = this.userRoleRepository.findByRole((Role)role.get());
        if (userRoles.isEmpty()) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("No users with ROLE ENGINEER found");
            return returnValue;
        }
        ArrayList<UserListModel> userList = new ArrayList<UserListModel>();
        for (UserRole userRole : userRoles) {
            User user = userRole.getUser();
            UserListModel data = new UserListModel();
            data.setDescription(user.getDescription());
            data.setUsername(user.getUsername());
            data.setId(Long.valueOf(user.getId().intValue()));
            userList.add(data);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("list of engineer");
        returnValue.setData(userList);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public boolean checkConferenceRoleUser(List<Integer> roleId) {
        for (Integer role : roleId) {
            Optional roleData = this.roleRepository.findById((Object)role);
            if (!((Role)roleData.get()).getShortCode().equals("ROLE_CONFERENCE")) continue;
            return true;
        }
        return false;
    }

    public boolean checkConferenceUserByName(String userName) {
        logger.info("checking user have conference role.....");
        List rolesOfUser = this.userRoleService.roleIdOfParticularUser(userName);
        Optional conferenceRole = this.roleRepository.findByShortCode("ROLE_CONFERENCE");
        return conferenceRole.isPresent() && rolesOfUser.contains(((Role)conferenceRole.get()).getId());
    }

    public List<String> getUserByZone(String zone) {
        List extensionList = this.extensionRepository.findByZone(zone);
        List imsiList = this.imsiRepository.findByZone(zone);
        if (extensionList.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, String> extensionMap = new HashMap<String, String>();
        for (IMSI imsi : imsiList) {
            extensionMap.put(imsi.getExtensionNumber(), imsi.getExtensionNumber());
        }
        for (Extension extension : extensionList) {
            extensionMap.putIfAbsent(extension.getExtension(), extension.getExtension());
        }
        ArrayList extensionNumbers = new ArrayList(extensionMap.values());
        List extensions = this.extensionRepository.findByExtensionIn(extensionNumbers);
        ArrayList<String> userList = new ArrayList<String>();
        for (Extension extension : extensions) {
            if (StringUtils.hasText((String)extension.getAssignedUser())) {
                userList.add(extension.getAssignedUser());
                continue;
            }
            userList.add(extension.getExtension());
        }
        return userList;
    }

    public boolean userIsVip(String username) {
        Optional userData = this.userRepository.findByUsername(username);
        return userData.isPresent() && ((User)userData.get()).getVipUser() != false;
    }

    public RequestResponse sendNotification(EventNotifyModel data) {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper obj = new ObjectMapper();
        try {
            EventNotify row = new EventNotify();
            row.setEventId(data.getEventId());
            if (data.getEventUUID() != null) {
                row.setEventUUID(data.getEventUUID());
            } else {
                row.setEventUUID(UUID.randomUUID().toString());
            }
            row.setEventMessage(data.getEventMessage());
            row.setEventSeverity(data.getEventSeverity());
            row.setEventEpoch(data.getEventEpoch());
            row.setEventSource(data.getEventSource());
            row.setEventDestination(data.getEventDestination());
            row.setReadByUser(data.getReadByUser());
            row.setEventData(obj.writeValueAsString(data.getEventData()));
            this.eventNotifyRepository.save((Object)row);
            Messaging.sendAlert((EventNotifyModel)data);
            logger.info("Alert event send successfully to user:{} and data:{}", (Object)data.getEventDestination(), data.getEventData());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Alert send successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Unable to send event to user:{},and error:{}", (Object)data.getEventDestination(), (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to send alert");
            returnValue.setMessageDetail("Contact to Administrator");
        }
        return returnValue;
    }

    public boolean isPhoneUsers(String extension) {
        List phoneExtensions = this.extensionsRepository.findByExtensionType("phone");
        if (phoneExtensions.isEmpty()) {
            return false;
        }
        ArrayList<String> phoneTypeExtensionList = new ArrayList<String>();
        for (Extension ext : phoneExtensions) {
            phoneTypeExtensionList.add(ext.getExtension());
        }
        return phoneTypeExtensionList.contains(extension);
    }

    public boolean isUcUser(Integer userId) {
        Optional ucRole;
        Optional userData = this.userRepository.findById((Object)userId);
        if (userData.isPresent() && (ucRole = this.roleRepository.findByShortCode("ROLE_USERS")).isPresent()) {
            return this.userRoleRepository.existsByRoleAndUser((Role)ucRole.get(), (User)userData.get());
        }
        return false;
    }

    public boolean isConferenceUser(Integer userId) {
        Optional ucRole;
        Optional userData = this.userRepository.findById((Object)userId);
        if (userData.isPresent() && (ucRole = this.roleRepository.findByShortCode("ROLE_CONFERENCE")).isPresent()) {
            return this.userRoleRepository.existsByRoleAndUser((Role)ucRole.get(), (User)userData.get());
        }
        return false;
    }

    public RequestResponse sendUserNotifyToUser(UserAccessModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        String toUsername = "";
        try {
            List userList = this.userRepository.findByContactNo(data.getToUser());
            if (!userList.isEmpty()) {
                toUsername = ((User)userList.get(0)).getUsername();
                logger.info("Alert for user:{}", (Object)toUsername);
            }
            EventNotifyModel dataToSend = new EventNotifyModel();
            dataToSend.setEventMessage("Request for Camera and Mic Access");
            dataToSend.setEventId(Constants.EventStatus.CAMERA_MIC_ACCESS);
            dataToSend.setEventUUID(UUID.randomUUID().toString());
            dataToSend.setEventDestination(toUsername);
            dataToSend.setEventSource(principal.getName());
            dataToSend.setEventSeverity(Integer.valueOf(1));
            dataToSend.setEventEpoch(Long.valueOf(Instant.now().getMillis()));
            dataToSend.setReadByUser(Boolean.valueOf(false));
            dataToSend.setEventData((Object)("Mic and Camera Access by " + principal.getName() + " from " + toUsername));
            this.sendNotifyToSubscriber(dataToSend);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Alert send successfully");
            logger.info("Event send successfully:{}", (Object)dataToSend);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to send alert");
            returnValue.setMessageDetail("Contact to Administrator");
            logger.error(e.getMessage());
        }
        return returnValue;
    }

    private String checkProsodyStatus() throws IOException {
        ProcessBuilder statusCheckBuilder = new ProcessBuilder("sudo", "prosodyctl", "status");
        Process statusCheckProcess = statusCheckBuilder.start();
        StringBuilder prosodyStatus = new StringBuilder();
        logger.info("Executing command: {}", (Object)String.join((CharSequence)" ", statusCheckBuilder.command()));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(statusCheckProcess.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                prosodyStatus.append(line).append("\n");
            }
        }
        return prosodyStatus.toString();
    }

    private boolean startProsody() {
        try {
            ProcessBuilder startBuilder = new ProcessBuilder("sudo", "prosodyctl", "start");
            logger.info("Executing command: {}", (Object)String.join((CharSequence)" ", startBuilder.command()));
            Process startProcess = startBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(startProcess.getInputStream()));){
                String output;
                while ((output = reader.readLine()) != null) {
                    logger.info(output);
                }
            }
            return this.checkProsodyStatus().contains("Prosody is running");
        }
        catch (Exception e) {
            logger.error("Failed to start Prosody server: ", (Throwable)e);
            return false;
        }
    }

    private void createXmPPUser(String server, String username, String password) throws IOException {
        String scriptPath = "/root/adduser.sh";
        try {
            String command = scriptPath + " " + username + " " + server + " " + password;
            logger.info("Command to create xmPP user:{}", (Object)command);
            String cmdOutput = this.cmd.executeCommand(command);
            if (cmdOutput.contains("User " + username + "@" + server + " created successfully")) {
                logger.info(cmdOutput);
            } else if (cmdOutput.contains("That user already exists")) {
                logger.error("User already exist at xmpp server");
            } else {
                logger.error("Error while executing command: {}", (Object)command);
            }
        }
        catch (Exception e) {
            logger.error("Error while reading the process output: {}", (Object)e.getMessage());
        }
    }

    private void updateXmPPUser(String server, String username, String password) throws IOException {
        String scriptPath = "/root/updatepasswd.sh";
        try {
            String command = scriptPath + " " + username + " " + server + " " + password;
            logger.info("Command to update xmPP user:{}", (Object)command);
            String cmdOutput = this.cmd.executeCommand(command);
            if (cmdOutput.contains("User Password " + username + "@" + server + " User Password successfully")) {
                logger.info(cmdOutput);
            } else {
                logger.error("Error while executing command: {}", (Object)command);
            }
        }
        catch (Exception e) {
            logger.error("Error while reading the process output: {}", (Object)e.getMessage());
        }
    }

    private void deleteXmPPUser(String server, String username) throws IOException {
        String scriptPath = "prosodyctl deluser";
        try {
            String command = scriptPath + " " + username + "@" + server;
            logger.info("Command to delete xmPP user:{}", (Object)command);
            String cmdOutput = this.cmd.executeCommand(command);
            logger.info(cmdOutput);
            if (cmdOutput.contains("")) {
                logger.info("xmPP user deleted successfully");
            } else if (cmdOutput.contains("That user does not exist on this server")) {
                logger.error("Error while executing command: {}", (Object)command);
            }
        }
        catch (Exception e) {
            logger.error("Error while reading the process output: {}", (Object)e.getMessage());
        }
    }

    public String getXmPPServer() {
        String xmPPServer;
        block3: {
            String coralFilePath = "/etc/default/coral";
            xmPPServer = "";
            try {
                Ini ini;
                File file = new File(coralFilePath);
                if (!file.exists() || !(ini = new Ini(file)).containsKey((Object)"CLUSTER")) break block3;
                Profile.Section cscfSection = (Profile.Section)ini.get((Object)"CLUSTER");
                if (cscfSection.containsKey((Object)"XMPP-SERVER-PRIMARY")) {
                    xmPPServer = (String)cscfSection.get((Object)"XMPP-SERVER-PRIMARY");
                    break block3;
                }
                return "";
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return xmPPServer;
    }

    public CoralFileModel readConfigFile() {
        CoralFileModel coralFileModel = new CoralFileModel();
        try {
            Ini ini;
            File file = new File("/etc/default/coral");
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CLUSTER")) {
                Profile.Section clusterSection = (Profile.Section)ini.get((Object)"CLUSTER");
                coralFileModel.setPrimaryDomain(clusterSection.get((Object)"DOMAIN", "").trim());
                coralFileModel.setSecondaryDomain(clusterSection.get((Object)"SECONDARY-DOMAIN", "").trim());
                coralFileModel.setXmPPPrimaryDomain(clusterSection.get((Object)"XMPP-SERVER-PRIMARY", "").trim());
                coralFileModel.setXmPPSecondaryDomain(clusterSection.get((Object)"XMPP-SERVER-SECONDARY", "").trim());
                String tlsValue = clusterSection.get((Object)"TLS", "").trim();
                coralFileModel.setEnableSsl(this.isTlsEnabled(tlsValue));
                String sbcUsersPort = clusterSection.get((Object)"SBC_USERS_PORT", "").trim();
                String sbcUsersPortTls = clusterSection.get((Object)"SBC_USERS_PORT_TLS", "").trim();
                if (coralFileModel.isEnableSsl()) {
                    coralFileModel.setServerPort(sbcUsersPort);
                } else {
                    coralFileModel.setServerPort(sbcUsersPortTls);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return coralFileModel;
    }

    public MapConfigModel mapConfiguration(HttpServletRequest request) {
        MapConfigModel mapConfigModel;
        block9: {
            mapConfigModel = new MapConfigModel();
            try {
                String[] parts;
                File file = new File("/etc/default/coral");
                if (!file.exists()) break block9;
                Ini ini = new Ini(file);
                String clientIp = request.getRemoteAddr();
                if (!ini.containsKey((Object)"MAP")) break block9;
                Profile.Section mapSection = (Profile.Section)ini.get((Object)"MAP");
                Profile.Section clusterSection = (Profile.Section)ini.get((Object)"CLUSTER");
                if (mapSection.get((Object)"MAP-URL") == null || ((String)mapSection.get((Object)"MAP-URL")).isEmpty()) {
                    if (clusterSection.get((Object)"DOMAIN") == null || ((String)clusterSection.get((Object)"DOMAIN")).isEmpty()) {
                        mapConfigModel.setMapURL(clientIp);
                    } else {
                        mapConfigModel.setMapURL(((String)clusterSection.get((Object)"DOMAIN")).trim());
                    }
                } else {
                    mapConfigModel.setMapURL(((String)mapSection.get((Object)"MAP-URL")).trim());
                }
                String centerString = mapSection.get((Object)"MAP-CENTER", "").trim();
                if (!centerString.isEmpty() && (parts = (centerString = centerString.replace("[", "").replace("]", "")).split(",")).length == 2) {
                    try {
                        double lat = Double.parseDouble(parts[0].trim());
                        double lng = Double.parseDouble(parts[1].trim());
                        mapConfigModel.setMapCenter(Arrays.asList(lat, lng));
                    }
                    catch (NumberFormatException e) {
                        logger.error("Invalid MAP-CENTER format: " + centerString);
                    }
                }
                mapConfigModel.setMapDefaultZoom(mapSection.get((Object)"MAP-DEFAULT-ZOOM") != null ? Integer.valueOf(Integer.parseInt((String)mapSection.get((Object)"MAP-DEFAULT-ZOOM"))) : null);
                mapConfigModel.setMapMinZoom(mapSection.get((Object)"MAP-MIN-ZOOM") != null ? Integer.valueOf(Integer.parseInt((String)mapSection.get((Object)"MAP-MIN-ZOOM"))) : null);
                mapConfigModel.setMapMaxZoom(mapSection.get((Object)"MAP-MAX-ZOOM") != null ? Integer.valueOf(Integer.parseInt((String)mapSection.get((Object)"MAP-MAX-ZOOM"))) : null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mapConfigModel;
    }

    private boolean isTlsEnabled(String tlsValue) {
        return "Y".equalsIgnoreCase(tlsValue) || "true".equalsIgnoreCase(tlsValue);
    }

    public void sendNotifyToSubscriber(EventNotifyModel data) {
        ObjectMapper obj = new ObjectMapper();
        try {
            EventNotify row = new EventNotify();
            row.setEventId(data.getEventId());
            if (data.getEventUUID() != null) {
                row.setEventUUID(data.getEventUUID());
            } else {
                row.setEventUUID(UUID.randomUUID().toString());
            }
            row.setEventMessage(data.getEventMessage());
            row.setEventSeverity(data.getEventSeverity());
            row.setEventEpoch(data.getEventEpoch());
            row.setEventSource(data.getEventSource());
            row.setEventDestination(data.getEventDestination());
            row.setReadByUser(data.getReadByUser());
            row.setEventData(obj.writeValueAsString(data.getEventData()));
            this.eventNotifyRepository.save((Object)row);
            Messaging.sendAlert((EventNotifyModel)data);
            logger.info("Alert event send successfully to user:{} and data:{}", (Object)data.getEventDestination(), data.getEventData());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Unable to send event to user:{},and error:{}", (Object)data.getEventDestination(), (Object)e.getMessage());
        }
    }

    public RequestResponse updatePasswordForUsers(ChangePasswordModel data) {
        RequestResponse returnValue = new RequestResponse();
        if (data == null || data.getUsername() == null) {
            return this.errorResponse(returnValue, "Invalid input", "Username cannot be null");
        }
        try {
            if (!data.getDefaultPassword().booleanValue()) {
                if (data.getNewPassword() == null || data.getConfirmPassword() == null) {
                    return this.errorResponse(returnValue, "Invalid input", "newPassword and confirmPassword cannot be null");
                }
                this.decryptPasswordData(data);
            } else {
                data.setUsername(this.credential.decryptData(data.getUsername()));
            }
        }
        catch (Exception e) {
            return this.errorResponse(returnValue, "Decryption failed", "Unable to decrypt input fields", e);
        }
        Optional userOptional = this.userRepository.findByUsername(data.getUsername());
        if (!userOptional.isPresent()) {
            return this.errorResponse(returnValue, "Unable to change password", "Wrong username or old password");
        }
        User user = (User)userOptional.get();
        try {
            if (data.getDefaultPassword().booleanValue()) {
                this.updateUserPassword(user, "12345");
                return this.successResponse(returnValue, user, "Successfully set the default password");
            }
            if (data.getNewPassword().equals(data.getConfirmPassword())) {
                this.updateUserPassword(user, data.getNewPassword());
                return this.successResponse(returnValue, user, "Successfully changed your password");
            }
            return this.errorResponse(returnValue, "Unable to change password", "newPassword and confirmPassword must match");
        }
        catch (Exception ex) {
            return this.errorResponse(returnValue, "Unable to change password", "Contact your administrator", ex);
        }
    }

    private void decryptPasswordData(ChangePasswordModel data) throws Exception {
        data.setUsername(this.credential.decryptData(data.getUsername()));
        data.setNewPassword(this.credential.decryptData(data.getNewPassword()));
        data.setConfirmPassword(this.credential.decryptData(data.getConfirmPassword()));
    }

    private void updateUserPassword(User user, String newPassword) {
        user.setPassword(this.bcryptEncoder.encode((CharSequence)newPassword));
        user.setLastPasswordChange(LocalDate.now());
        user.setCredentialsExpired(Boolean.valueOf(false));
        user.setFailedAttempts(Integer.valueOf(0));
        user.setLastLogon(LocalDate.now());
        this.userRepository.save((Object)user);
    }

    private RequestResponse successResponse(RequestResponse returnValue, User user, String message) {
        ReturnField field = new ReturnField();
        field.setId(user.getId().intValue());
        field.setDescription(user.getUsername());
        returnValue.setData((Object)field);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage(message);
        logger.info(message);
        return returnValue;
    }

    private RequestResponse errorResponse(RequestResponse returnValue, String message, String detail) {
        return this.errorResponse(returnValue, message, detail, null);
    }

    private RequestResponse errorResponse(RequestResponse returnValue, String message, String detail, Exception e) {
        returnValue.setStatus(Constants.Error.ERROR);
        returnValue.setMessage(message);
        returnValue.setMessageDetail(detail);
        if (e != null) {
            logger.error(message + ": " + e.getMessage(), (Throwable)e);
        } else {
            logger.error(message);
        }
        return returnValue;
    }

    public RequestResponse deAttachedUser(String username, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            String areaName = "";
            Integer areaId = ((User)user.get()).getAreaId();
            ((User)user.get()).setAreaId(null);
            this.userRepository.save(user.get());
            Optional areaData = this.areaRepository.findById((Object)areaId);
            if (areaData.isPresent()) {
                areaName = ((Area)areaData.get()).getName();
            }
            EventNotifyModel eventData = new EventNotifyModel();
            long epoch = System.currentTimeMillis() / 1000L;
            eventData.setReadByUser(Boolean.valueOf(false));
            eventData.setEventData((Object)("User Remove from area:" + areaName));
            eventData.setEventId(Constants.EventStatus.USER_ZONE_UPDATE_EVENT);
            eventData.setEventSeverity(Integer.valueOf(1));
            eventData.setEventUUID(UUID.randomUUID().toString());
            eventData.setEventMessage("User remove from area");
            eventData.setEventEpoch(Long.valueOf(epoch));
            eventData.setEventSource(principal.getName());
            eventData.setEventDestination(username);
            this.sendNotifyToSubscriber(eventData);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("User Remove from area Successfully");
        returnValue.setMessageDetail("User removed");
        return returnValue;
    }

    public UserLocationModel getUserLocation(String username) {
        UserLocationModel row = new UserLocationModel();
        try {
            Optional userCoordinate = this.userCoordinateRepository.findByUsername(username);
            if (userCoordinate != null) {
                row.setLatitude(((UserCoordinate)userCoordinate.get()).getGeoX());
                row.setLongitude(((UserCoordinate)userCoordinate.get()).getGeoY());
            }
            return row;
        }
        catch (Exception ex) {
            logger.error("Unable to find user latitude and longitude:{}", (Object)ex.getMessage());
            return row;
        }
    }

    public void updateZone(String extension, String zone) {
        Optional extensionData = this.extensionRepository.findByExtension(extension);
        if (extensionData.isPresent()) {
            ((Extension)extensionData.get()).setZone(zone);
            this.extensionRepository.save(extensionData.get());
        }
    }

    public String getColor(String username) {
        String department = this.extensionSecondaryService.getDepartmentOfUser(username);
        if (StringUtils.hasText((String)department)) {
            return this.departmentService.getColor(department);
        }
        return "";
    }

    public List<Integer> getAssignedZone(String username) {
        ArrayList<Integer> zones = new ArrayList();
        Optional userData = this.userRepository.findByUsername(username);
        if (userData.isPresent() && StringUtils.hasLength((String)((User)userData.get()).getZoneId())) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                zones = (List)objectMapper.readValue(((User)userData.get()).getZoneId(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                return zones;
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    public List<ExtensionDepartmentModel> getAssociatedDepartment(String username, String department) {
        Extension firstExtension;
        ArrayList<ExtensionDepartmentModel> addValue = new ArrayList<ExtensionDepartmentModel>();
        HashSet<String> uniqueDepartments = new HashSet<String>();
        List getExtData = this.extensionRepository.findByExtensionTypeAndDepartment("ec", department);
        if (!getExtData.isEmpty() && uniqueDepartments.add((firstExtension = (Extension)getExtData.get(0)).getDepartment())) {
            ExtensionDepartmentModel defaultData = new ExtensionDepartmentModel();
            defaultData.setId(Integer.valueOf(0));
            defaultData.setDepartment(firstExtension.getDepartment());
            defaultData.setExtensionType(firstExtension.getExtensionType());
            defaultData.setName(username);
            defaultData.setExtension(firstExtension.getExtension());
            defaultData.setColor(this.extensionsService.getColorOfDepartment(firstExtension.getDepartment()));
            Optional departmentOptional = this.departmentRepository.findByCode(firstExtension.getDepartment());
            if (departmentOptional.isPresent()) {
                defaultData.setDepartmentDescription(((Department)departmentOptional.get()).getDescription());
            }
            defaultData.setSerialNo(this.extensionsService.getSerialOfDepartment(firstExtension.getDepartment()));
            addValue.add(defaultData);
        }
        List userDepartmentList = this.userDepartmentRepository.findByUsername(username);
        for (UserDepartment row : userDepartmentList) {
            Optional departmentOptional;
            if (row.getDepartment().equals(department)) continue;
            List extensionList = this.extensionRepository.findByExtensionTypeAndDepartment("ec", row.getDepartment());
            Optional dept = this.departmentRepository.findByCode(row.getDepartment());
            if (extensionList.isEmpty() || !uniqueDepartments.add(row.getDepartment())) continue;
            Extension firstExtension2 = (Extension)extensionList.get(0);
            ExtensionDepartmentModel data = new ExtensionDepartmentModel();
            data.setId(row.getId());
            data.setDepartment(row.getDepartment());
            data.setExtensionType(firstExtension2.getExtensionType());
            data.setName(username);
            data.setExtension(firstExtension2.getExtension());
            data.setColor(this.extensionsService.getColorOfDepartment(row.getDepartment()));
            data.setSerialNo(this.extensionsService.getSerialOfDepartment(row.getDepartment()));
            if (dept.isPresent()) {
                data.setEmergencyContactNumber(((Department)dept.get()).getEmergencyContactNumber());
            }
            if ((departmentOptional = this.departmentRepository.findByCode(row.getDepartment())).isPresent()) {
                data.setDepartmentDescription(((Department)departmentOptional.get()).getDescription());
            }
            addValue.add(data);
        }
        addValue.sort(Comparator.comparingInt(ExtensionDepartmentModel::getSerialNo));
        return addValue;
    }

    public String getDesignationByUsername(String username) {
        return this.userRepository.findByUsername(username).map(User::getContactNo).flatMap(arg_0 -> ((ExtensionsRepository)this.extensionRepository).findByExtension(arg_0)).map(Extension::getDesignation).orElse("");
    }

    public String getUserByExtension(String extension) {
        List userList = this.userRepository.findByContactNo(extension);
        if (!userList.isEmpty()) {
            return ((User)userList.get(0)).getUsername();
        }
        return "";
    }

    public void uploadAnnouncementFile(String extension, String filePath, Long epoch, String description, String createdBy) {
        try {
            FileUpload temp = new FileUpload();
            temp.setCreatedOn(epoch);
            temp.setCreatedBy(createdBy);
            temp.setFileDescription(description);
            temp.setFilePath(filePath);
            temp.setFileType("audio");
            temp.setGroupUpload(Boolean.valueOf(false));
            temp.setUserId(this.getUserByExtension(extension));
            temp.setFileName("Announcement Call");
            this.fileUploadRepository.save((Object)temp);
        }
        catch (Exception e) {
            logger.error("Error while uploading file:{}", (Object)e.getMessage());
        }
    }

    public String getWssDomain(String extension) {
        try {
            File file = new File("/etc/default/coral");
            if (file.exists()) {
                Ini ini = new Ini(file);
                if (ini.containsKey((Object)"CLUSTER")) {
                    Profile.Section clusterSection = (Profile.Section)ini.get((Object)"CLUSTER");
                    String wssDomain = clusterSection.get((Object)"WSS-DOMAIN", "").trim();
                    if (StringUtils.hasText((String)wssDomain)) {
                        logger.info("Returning WSS-DOMAIN: {}", (Object)wssDomain);
                        String rluCode = this.controlRluServerService.getRluCodeFinal(extension);
                        if (StringUtils.hasText((String)rluCode)) {
                            wssDomain = wssDomain.replace("$rlu", rluCode);
                        }
                        return wssDomain;
                    }
                    String domain = clusterSection.get((Object)"DOMAIN", "").trim();
                    if (!domain.isEmpty()) {
                        String[] parts = domain.split("\\.");
                        if (parts.length == 3) {
                            String modified = "wss." + parts[1] + "." + parts[2];
                            logger.info("Modified 3-part DOMAIN to WSS-DOMAIN: {}", (Object)modified);
                            return modified;
                        }
                        if (parts.length == 2) {
                            String modified = "wss." + domain;
                            logger.info("Modified 2-part DOMAIN to WSS-DOMAIN: {}", (Object)modified);
                            return modified;
                        }
                    }
                }
            } else {
                logger.error("Configuration file not found: /etc/default/coral");
            }
        }
        catch (Exception e) {
            logger.error("Error while finding WSS-DOMAIN: {}", (Object)e.getMessage(), (Object)e);
        }
        logger.error("No WSS-DOMAIN or valid DOMAIN found.");
        return "";
    }

    public Role getUsersRole(String role) {
        return this.roleRepository.findByShortCode(role).orElse(null);
    }

    public void createDispatcherUser(String extensionNumber) {
        McxDispatcher mcxDispatcher = new McxDispatcher();
        mcxDispatcher.setExtensionNumber(extensionNumber);
        mcxDispatcher.setUserType("Dispatcher");
        this.mcxDispatcherRepository.save((Object)mcxDispatcher);
    }

    private void deleteExtensionIfExistsByUserId(Integer userId) {
        try {
            Optional userOptional = this.userRepository.findById((Object)userId);
            if (userOptional.isPresent()) {
                boolean shouldDelete;
                User user = (User)userOptional.get();
                String contactNo = user.getContactNo();
                String userType = user.getUserType();
                boolean bl = shouldDelete = userType == null || userType.trim().isEmpty() || "normalUser".equalsIgnoreCase(userType);
                if (!shouldDelete) {
                    if (StringUtils.hasText((String)contactNo)) {
                        Optional extOptional = this.extensionsRepository.findByExtension(contactNo);
                        if (extOptional.isPresent()) {
                            this.extensionsRepository.delete(extOptional.get());
                            logger.info("Deleted extension for contactNo: {} (userType: {})", (Object)contactNo, (Object)userType);
                        } else {
                            logger.info("No extension found for contactNo: {}", (Object)contactNo);
                        }
                    } else {
                        logger.info("User with id {} has no contact number to delete from extensions", (Object)userId);
                    }
                } else {
                    logger.info("Skipped deleting extension for userId: {} because userType is '{}'", (Object)userId, (Object)userType);
                }
            } else {
                logger.warn("User not found for id: {}", (Object)userId);
            }
        }
        catch (Exception e) {
            logger.error("Error deleting extension for userId: {}", (Object)userId, (Object)e);
        }
    }
}

