/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.service;

import com.coraltele.config.JwtUserDetailConfiguration;
import com.coraltele.db.telephony.main.repository.McxDispatcherRepository;
import com.coraltele.db.telephony.pbx.repository.VipMasterRepository;
import com.coraltele.db.users.main.entity.PasswordConfig;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.PasswordConfigRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DecryptCredential;
import com.coraltele.helper.JwtUtil;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.ReturnField;
import com.coraltele.service.billing.main.agentStatus.service.AgentStatusService;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.pbx.extension.service.AuthExtensionService;
import com.coraltele.service.pbx.extension.service.ExtensionSecondaryService;
import com.coraltele.service.pbx.fileConfiguration.sipPhoneConfiguration.service.SipPhoneButtonService;
import com.coraltele.service.telemetry.coralnms.imsi.model.DeviceInformationModel;
import com.coraltele.service.telemetry.coralnms.imsi.service.IMSIService;
import com.coraltele.service.user.model.AuthenticationRequestModel;
import com.coraltele.service.user.model.AuthenticationRequestResponseModel;
import com.coraltele.service.user.model.ChangePasswordModel;
import com.coraltele.service.user.model.CoralFileModel;
import com.coraltele.service.user.model.GenerateOtpModel;
import com.coraltele.service.user.model.MapConfigModel;
import com.coraltele.service.user.model.RefreshTokenResponseModel;
import com.coraltele.service.user.model.RequiredChangePassword;
import com.coraltele.service.user.service.ExternalApplicationService;
import com.coraltele.service.user.service.UserMenuService;
import com.coraltele.service.user.service.UserRoleMenuService;
import com.coraltele.service.user.service.UserRoleService;
import com.coraltele.service.user.service.UserService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UserAuthenticationService {
    private static final Logger logger = LogManager.getLogger(UserAuthenticationService.class);
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private PasswordEncoder bcryptEncoder;
    @Autowired
    private JwtUserDetailConfiguration jwtUserDetailConfiguration;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private DateFormatUtility dateFormatUtility;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRoleMenuService userRoleMenuService;
    @Autowired
    AuthExtensionService authExtensionService;
    @Autowired
    ControlRluServerService controlRluServer;
    @Autowired
    UserMenuService userMenuService;
    @Autowired
    DecryptCredential credential;
    @Autowired
    UserRoleService userRoleService;
    @Autowired
    PasswordConfigRepository passwordConfigRepository;
    @Autowired
    ExternalApplicationService externalApplicationService;
    @Autowired
    SipPhoneButtonService sipPhoneConfiguration;
    @Autowired
    ExtensionSecondaryService extensionSecondaryService;
    @Autowired
    VipMasterRepository vipMasterRepository;
    @Autowired
    UserRoleRepository userRoleRepository;
    @Autowired
    McxDispatcherRepository mcxDispatcherRepository;
    @Autowired
    IMSIService imsiService;
    @Autowired
    AgentStatusService agentStatusService;
    private final String USERNAME = "coral351881";
    private final String PASSWORD = "13158";
    private final String SENDER_ID = "CTLMCX";
    private final String TEMPLATE_ID = "1707174158709368831";

    public RequestResponse login(AuthenticationRequestModel jwtRequest, Integer mode, HttpServletRequest request) throws Exception {
        RequestResponse returnValue;
        block67: {
            String userAgent = request.getHeader("User-Agent");
            Boolean isBrowser = false;
            returnValue = new RequestResponse();
            String username = jwtRequest.getUsername();
            if (username == null || username.trim().isEmpty()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Login Failed");
                returnValue.setMessageDetail("Username cannot be empty.");
                return returnValue;
            }
            if (userAgent != null && ((userAgent = userAgent.toLowerCase()).contains("mozilla") || userAgent.contains("chrome") || userAgent.contains("safari") || userAgent.contains("firefox") || userAgent.contains("edge"))) {
                isBrowser = true;
                logger.info("User is logged in from browser");
            }
            RequiredChangePassword flag = new RequiredChangePassword();
            if (mode == 2) {
                jwtRequest.setUsername(this.credential.decryptPaddingCS5(jwtRequest.getUsername()));
                jwtRequest.setPassword(this.credential.decryptPaddingCS5(jwtRequest.getPassword()));
            } else {
                jwtRequest.setUsername(this.credential.decryptData(jwtRequest.getUsername()));
                jwtRequest.setPassword(this.credential.decryptData(jwtRequest.getPassword()));
                username = jwtRequest.getUsername().trim();
                String usernameRegex = "^[A-Za-z0-9_.]+$";
                if (!username.matches(usernameRegex)) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Login Failed");
                    returnValue.setMessageDetail("Username contains invalid special characters. Allowed: letters, numbers, '_' and '.'");
                    return returnValue;
                }
            }
            CoralFileModel configValues = this.userService.readConfigFile();
            MapConfigModel mapConfigModel = this.userService.mapConfiguration(request);
            Optional userInfo = this.userService.getUserByName(jwtRequest.getUsername());
            List passwordConfigs = this.passwordConfigRepository.findAll();
            if (passwordConfigs.isEmpty()) {
                PasswordConfig configData = new PasswordConfig();
                configData.setAcceptLastPassword(Integer.valueOf(3));
                configData.setCreatedBy(jwtRequest.getUsername());
                configData.setCreatedOn(LocalDateTime.now());
                configData.setDefaultPwd(Boolean.valueOf(true));
                configData.setExpiredCredential(Integer.valueOf(90));
                configData.setIdealTimeout(Integer.valueOf(0));
                configData.setLastLogin(Integer.valueOf(90));
                configData.setMaxAttempt(Integer.valueOf(5));
                configData.setPwdChangeHistory(Integer.valueOf(10));
                configData.setPwdChangeNotice(Integer.valueOf(60));
                configData.setPwdComplication(Boolean.valueOf(false));
                configData.setSingleLogin(Boolean.valueOf(false));
                this.passwordConfigRepository.save((Object)configData);
            }
            if (userInfo.isPresent()) {
                try {
                    DeviceInformationModel deviceData = this.getDeviceInfo(jwtRequest.getUsername(), jwtRequest.getDeviceId());
                    this.imsiService.updateDeviceUser(deviceData);
                }
                catch (Exception e) {
                    logger.error("Unable to update imsi for device information:", (Object)e.getMessage());
                }
                try {
                    if (this.userService.checkRoleDispatcher(((User)userInfo.get()).getUsername()) && !this.mcxDispatcherRepository.existsByExtensionNumber(((User)userInfo.get()).getContactNo())) {
                        this.userService.createDispatcherUser(((User)userInfo.get()).getContactNo());
                    }
                }
                catch (Exception e) {
                    logger.error("13158Unable to create dispatcher user for " + jwtRequest.getUsername() + ": " + e.getMessage());
                }
                List userRole = this.userRoleRepository.findByUser((User)userInfo.get());
                boolean isAdmin = this.isFailedAttemptExempt((User)userInfo.get());
                if (((PasswordConfig)passwordConfigs.get(0)).getSingleLogin().equals(true)) {
                    if (!userRole.isEmpty() && userRole.stream().anyMatch(row -> row.getRole().getShortCode().equalsIgnoreCase("ROLE_ADMIN")) || ((User)userInfo.get()).getStatus() == null || ((User)userInfo.get()).getStatus().equalsIgnoreCase("logout") || isBrowser.booleanValue()) {
                        int enabled = ((User)userInfo.get()).getEnabled();
                        boolean accountExpired = ((User)userInfo.get()).getAccountExpired();
                        boolean credentialExpired = ((User)userInfo.get()).getCredentialsExpired();
                        boolean accountLocked = ((User)userInfo.get()).getAccountLocked();
                        int failedAttempt = ((User)userInfo.get()).getFailedAttempts();
                        Integer userId = ((User)userInfo.get()).getId();
                        String publicEmergencyNumber = ((User)userInfo.get()).getPublicEmergencyNumber();
                        String broadcastNumber = ((User)userInfo.get()).getBroadcastNumber();
                        LocalDate lastLogon = ((User)userInfo.get()).getLastLogon();
                        if (lastLogon == null) {
                            lastLogon = LocalDate.now();
                        }
                        LocalDate lastPasswordChange = ((User)userInfo.get()).getLastPasswordChange();
                        long maxDaysForLastLogon = DateFormatUtility.getDaysDifference((LocalDate)lastLogon, (LocalDate)LocalDate.now());
                        long maxDaysForLastPasswordChange = 0L;
                        String extensionName = this.authExtensionService.getExtName(this.authExtensionService.getExtensionOfUser(jwtRequest.getUsername()));
                        String extension = this.authExtensionService.getExtensionOfUser(jwtRequest.getUsername());
                        String designation = this.authExtensionService.getDesignation(extension);
                        String sosNumber = this.authExtensionService.getSOSNumber();
                        String department = this.authExtensionService.getDepartment(extension);
                        String zone = this.authExtensionService.getZone(extension);
                        String ecExtension = this.authExtensionService.getEcExtension(department, zone);
                        String sipPasswdEncrypt = this.extensionSecondaryService.getSipPassword(extension);
                        String rluCode = this.authExtensionService.getRluCodeForAll(extension);
                        String rluIp = this.controlRluServer.getVirtualIp(rluCode);
                        String status = ((User)userInfo.get()).getStatus();
                        String fullName = ((User)userInfo.get()).getUsername();
                        Boolean defaultPassword = ((PasswordConfig)passwordConfigs.get(0)).getDefaultPwd();
                        Boolean pwdComplication = ((PasswordConfig)passwordConfigs.get(0)).getPwdComplication();
                        Integer idealTimeout = ((PasswordConfig)passwordConfigs.get(0)).getIdealTimeout();
                        List coralApplication = this.externalApplicationService.applicationListByRole(jwtRequest.getUsername());
                        Object sipPhoneButton = this.sipPhoneConfiguration.getSipPhoneButtonConfiguration().getData();
                        Boolean isCOUser = this.vipMasterRepository.existsByOfficeExtension(extension);
                        Integer ringAnswerCount = ((User)userInfo.get()).getDispatcherAutoAnswer() != false ? ((User)userInfo.get()).getRingAnswerCount() : 0;
                        String primaryDomain = configValues.getPrimaryDomain();
                        boolean enableSsl = configValues.isEnableSsl();
                        String secondaryDomain = configValues.getSecondaryDomain();
                        String xmPPPrimaryDomain = configValues.getXmPPPrimaryDomain();
                        String xmPPSecondaryDomain = configValues.getXmPPSecondaryDomain();
                        String serverPort = configValues.getServerPort();
                        String mapURL = mapConfigModel.getMapURL();
                        List mapCenter = mapConfigModel.getMapCenter();
                        Integer mapDefaultZoom = mapConfigModel.getMapDefaultZoom();
                        Integer mapMinZoom = mapConfigModel.getMapMinZoom();
                        Integer mapMaxZoom = mapConfigModel.getMapMaxZoom();
                        if (lastPasswordChange != null) {
                            maxDaysForLastPasswordChange = DateFormatUtility.getDaysDifference((LocalDate)lastPasswordChange, (LocalDate)LocalDate.now());
                        }
                        boolean enableGeoFencing = false;
                        boolean enablePrivateCall = true;
                        boolean enableVideoPrivateCall = true;
                        boolean enableVideoGroupCall = false;
                        boolean enableAudioMessage = true;
                        boolean enableVideoMessage = true;
                        boolean enableTextMessage = false;
                        boolean enableCoordinate = false;
                        List departmentList = this.userService.getAssociatedDepartment(jwtRequest.getUsername(), department);
                        String clickToCall = Constants.CLICK_TO_CALL_IP;
                        String wssDomain = this.userService.getWssDomain(extension);
                        if (isAdmin) {
                            failedAttempt = 0;
                        }
                        if (failedAttempt < ((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt()) {
                            try {
                                this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)jwtRequest.getUsername(), (Object)jwtRequest.getPassword()));
                                UserDetails userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(jwtRequest.getUsername());
                                if (!isAdmin && enabled != 1 && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                    returnValue.setStatus(Constants.Error.ACCOUNT_NOT_ENABLED);
                                    returnValue.setMessage("Login Failed");
                                    returnValue.setMessageDetail("User needs to enable the account");
                                    returnValue.setData((Object)flag);
                                }
                                if (!isAdmin && accountExpired && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                    returnValue.setStatus(Constants.Error.ACCOUNT_EXPIRED);
                                    returnValue.setMessage("Login Failed");
                                    returnValue.setMessageDetail(" Your account has been expired ");
                                    returnValue.setData((Object)flag);
                                }
                                if (!isAdmin && credentialExpired && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                    returnValue.setStatus(Constants.Error.CREDENTIAL_EXPIRED);
                                    returnValue.setMessage("Login Failed");
                                    returnValue.setMessageDetail("User need to change their password ");
                                    flag.setRequiredChangePassword(true);
                                    returnValue.setData((Object)flag);
                                }
                                if (!isAdmin && accountLocked && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                    returnValue.setStatus(Constants.Error.ACCOUNT_BLOCKED);
                                    returnValue.setMessage("Login Failed");
                                    returnValue.setMessageDetail("Your account has been locked");
                                    returnValue.setData((Object)flag);
                                }
                                if (!isAdmin && maxDaysForLastLogon >= (long)((PasswordConfig)passwordConfigs.get(0)).getExpiredCredential().intValue() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                    returnValue.setStatus(Constants.Error.TOO_MANY_DAYS);
                                    returnValue.setMessage("Login Failed");
                                    returnValue.setMessageDetail("User need to change the password ");
                                    flag.setRequiredChangePassword(true);
                                    returnValue.setData((Object)flag);
                                }
                                if (!isAdmin && maxDaysForLastPasswordChange >= (long)((PasswordConfig)passwordConfigs.get(0)).getPwdChangeNotice().intValue() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                    returnValue.setStatus(Constants.Error.TOO_MANY_DAYS);
                                    returnValue.setMessage("Login Failed");
                                    returnValue.setMessageDetail("User need to change the password ");
                                    flag.setRequiredChangePassword(true);
                                    returnValue.setData((Object)flag);
                                }
                                if (!isAdmin && failedAttempt >= ((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                    returnValue.setStatus(Constants.Error.TOO_MANY_FAILED_ATTEMPTS);
                                    returnValue.setMessage("Login Failed, Too many failed attempts");
                                    returnValue.setMessageDetail("User not allowed to Logged In again");
                                }
                                if (jwtRequest.getDeviceId() != null && StringUtils.hasLength((String)jwtRequest.getDeviceId())) {
                                    returnValue = this.validateDeviceAndUser(jwtRequest);
                                }
                                List roles = this.userRoleMenuService.rolesOfParticularUser(jwtRequest.getUsername());
                                List roleId = this.userRoleService.roleIdOfParticularUser(jwtRequest.getUsername());
                                if (!returnValue.getStatus().equals((Object)Constants.Error.OK)) break block67;
                                long currentTime = System.currentTimeMillis();
                                Optional existingRecordOpt = this.userService.getUserByName(userDetails.getUsername());
                                if (!existingRecordOpt.isPresent()) break block67;
                                Long tokenEpoch = ((User)existingRecordOpt.get()).getTokenEpoch();
                                if (tokenEpoch != null && tokenEpoch > currentTime) {
                                    String token = this.jwtUtil.generateTokenByDB(userDetails, ((User)existingRecordOpt.get()).getUuidSecurity());
                                    String refreshToken = this.jwtUtil.generateRefreshTokenByDB(userDetails, ((User)existingRecordOpt.get()).getUuidSecurity());
                                    Long expiryTokenMillis = this.jwtUtil.getTokenExpirationEpoch(token);
                                    Long expiryRefreshTokenMillis = this.jwtUtil.getRefreshTokenExpirationEpoch(refreshToken);
                                    ((User)userInfo.get()).setTokenEpoch(expiryTokenMillis);
                                    ((User)userInfo.get()).setRefreshTokenEpoch(expiryRefreshTokenMillis);
                                    this.userRepository.save(userInfo.get());
                                    logger.info("Generating token by DB for userDB Token : {} ", (Object)token);
                                    returnValue.setMessage(" Authenticated ");
                                    returnValue.setMessageDetail("User has been successfully authenticated");
                                    List menu = this.userMenuService.getUserActiveMenu();
                                    returnValue.setData((Object)new AuthenticationRequestResponseModel(token, refreshToken, fullName, userId, jwtRequest.getUsername(), extensionName, extension, designation, rluCode, rluIp, sipPasswdEncrypt, sosNumber, department, zone, ecExtension, roles, menu, false, status, roleId, defaultPassword, pwdComplication, idealTimeout, coralApplication, sipPhoneButton, isCOUser.booleanValue(), ringAnswerCount, publicEmergencyNumber, broadcastNumber, primaryDomain, enableSsl, secondaryDomain, xmPPPrimaryDomain, xmPPSecondaryDomain, serverPort, enableGeoFencing, enablePrivateCall, enableVideoPrivateCall, enableVideoGroupCall, enableAudioMessage, enableVideoMessage, enableTextMessage, enableCoordinate, departmentList, clickToCall, wssDomain, mapURL, mapCenter, mapDefaultZoom, mapMinZoom, mapMaxZoom));
                                    logger.info(returnValue.getMessage());
                                    break block67;
                                }
                                String token = this.jwtUtil.generateToken(userDetails);
                                String refreshToken = this.jwtUtil.generateRefreshToken(userDetails);
                                String uuidToken = this.jwtUtil.getClaimFromToken(token, "uuidSecurity", false);
                                String uuidRefreshToken = this.jwtUtil.getClaimFromToken(refreshToken, "uuidSecurity", true);
                                Long expiryTokenMillis = this.jwtUtil.getTokenExpirationEpoch(token);
                                Long expiryRefreshTokenMillis = this.jwtUtil.getRefreshTokenExpirationEpoch(refreshToken);
                                ((User)userInfo.get()).setDeviceId(jwtRequest.getDeviceId());
                                ((User)userInfo.get()).setLoggedIn(Boolean.valueOf(true));
                                ((User)userInfo.get()).setFailedAttempts(Integer.valueOf(0));
                                ((User)userInfo.get()).setLastLogon(LocalDate.now());
                                ((User)userInfo.get()).setUuidSecurity(uuidToken);
                                ((User)userInfo.get()).setTokenEpoch(expiryTokenMillis);
                                ((User)userInfo.get()).setRefreshTokenEpoch(expiryRefreshTokenMillis);
                                this.userRepository.save(userInfo.get());
                                returnValue.setMessage(" Authenticated ");
                                returnValue.setMessageDetail("User has been successfully authenticated");
                                List menu = this.userMenuService.getUserActiveMenu();
                                returnValue.setData((Object)new AuthenticationRequestResponseModel(token, refreshToken, fullName, userId, jwtRequest.getUsername(), extensionName, extension, designation, rluCode, rluIp, sipPasswdEncrypt, sosNumber, department, zone, ecExtension, roles, menu, false, status, roleId, defaultPassword, pwdComplication, idealTimeout, coralApplication, sipPhoneButton, isCOUser.booleanValue(), ringAnswerCount, publicEmergencyNumber, broadcastNumber, primaryDomain, enableSsl, secondaryDomain, xmPPPrimaryDomain, xmPPSecondaryDomain, serverPort, enableGeoFencing, enablePrivateCall, enableVideoPrivateCall, enableVideoGroupCall, enableAudioMessage, enableVideoMessage, enableTextMessage, enableCoordinate, departmentList, clickToCall, wssDomain, mapURL, mapCenter, mapDefaultZoom, mapMinZoom, mapMaxZoom));
                                logger.info(returnValue.getMessage());
                            }
                            catch (BadCredentialsException | UsernameNotFoundException e) {
                                ((User)userInfo.get()).setFailedAttempts(Integer.valueOf(++failedAttempt));
                                this.userRepository.save(userInfo.get());
                                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                                returnValue.setMessage("Login Failed");
                                returnValue.setMessageDetail("Wrong username or password ");
                                returnValue.setData((Object)("total " + String.valueOf(((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt() - failedAttempt) + " attempts remains"));
                                logger.info(returnValue.getMessage());
                            }
                        } else {
                            returnValue.setStatus(Constants.Error.ACCOUNT_BLOCKED);
                            returnValue.setMessage("Login Failed");
                            returnValue.setMessageDetail("Your account has been locked, you have tried maximum attempts");
                            logger.info(returnValue.getMessage());
                        }
                    } else {
                        String clientIp = AgentStatusService.getClientIp((HttpServletRequest)request);
                        if (((User)userInfo.get()).getIpAddress() != null && ((User)userInfo.get()).getIpAddress().equals(clientIp)) {
                            int enabled = ((User)userInfo.get()).getEnabled();
                            boolean accountExpired = ((User)userInfo.get()).getAccountExpired();
                            Integer userId = ((User)userInfo.get()).getId();
                            boolean credentialExpired = ((User)userInfo.get()).getCredentialsExpired();
                            boolean accountLocked = ((User)userInfo.get()).getAccountLocked();
                            int failedAttempt = ((User)userInfo.get()).getFailedAttempts();
                            LocalDate lastLogon = ((User)userInfo.get()).getLastLogon();
                            if (lastLogon == null) {
                                lastLogon = LocalDate.now();
                            }
                            LocalDate lastPasswordChange = ((User)userInfo.get()).getLastPasswordChange();
                            long maxDaysForLastLogon = DateFormatUtility.getDaysDifference((LocalDate)lastLogon, (LocalDate)LocalDate.now());
                            long maxDaysForLastPasswordChange = 0L;
                            String extensionName = this.authExtensionService.getExtName(this.authExtensionService.getExtensionOfUser(jwtRequest.getUsername()));
                            String extension = this.authExtensionService.getExtensionOfUser(jwtRequest.getUsername());
                            String designation = this.authExtensionService.getDesignation(extension);
                            String sosNumber = this.authExtensionService.getSOSNumber();
                            String department = this.authExtensionService.getDepartment(extension);
                            String zone = this.authExtensionService.getZone(extension);
                            String ecExtension = this.authExtensionService.getEcExtension(department, zone);
                            String sipPasswdEncrypt = this.extensionSecondaryService.getSipPassword(extension);
                            String rluCode = this.authExtensionService.getRluCodeForAll(extension);
                            String rluIp = this.controlRluServer.getVirtualIp(rluCode);
                            String status = ((User)userInfo.get()).getStatus();
                            String fullName = ((User)userInfo.get()).getUsername();
                            Boolean defaultPassword = ((PasswordConfig)passwordConfigs.get(0)).getDefaultPwd();
                            Boolean pwdComplication = ((PasswordConfig)passwordConfigs.get(0)).getPwdComplication();
                            Integer idealTimeout = ((PasswordConfig)passwordConfigs.get(0)).getIdealTimeout();
                            List coralApplication = this.externalApplicationService.applicationListByRole(jwtRequest.getUsername());
                            Object sipPhoneButton = this.sipPhoneConfiguration.getSipPhoneButtonConfiguration().getData();
                            Boolean isCOUser = this.vipMasterRepository.existsByOfficeExtension(extension);
                            String publicEmergencyNumber = ((User)userInfo.get()).getPublicEmergencyNumber();
                            String broadcastNumber = ((User)userInfo.get()).getBroadcastNumber();
                            Integer ringAnswerCount = ((User)userInfo.get()).getDispatcherAutoAnswer() != false ? ((User)userInfo.get()).getRingAnswerCount() : 0;
                            String primaryDomain = configValues.getPrimaryDomain();
                            boolean enableSsl = configValues.isEnableSsl();
                            String secondaryDomain = configValues.getSecondaryDomain();
                            String xmPPPrimaryDomain = configValues.getXmPPPrimaryDomain();
                            String xmPPSecondaryDomain = configValues.getXmPPSecondaryDomain();
                            String serverPort = configValues.getServerPort();
                            boolean enableGeoFencing = false;
                            boolean enablePrivateCall = true;
                            boolean enableVideoPrivateCall = true;
                            boolean enableVideoGroupCall = false;
                            boolean enableAudioMessage = true;
                            boolean enableVideoMessage = true;
                            boolean enableTextMessage = false;
                            boolean enableCoordinate = false;
                            List departmentList = this.userService.getAssociatedDepartment(jwtRequest.getUsername(), department);
                            String clickToCall = Constants.CLICK_TO_CALL_IP;
                            String wssDomain = this.userService.getWssDomain(extension);
                            String mapURL = mapConfigModel.getMapURL();
                            List mapCenter = mapConfigModel.getMapCenter();
                            Integer mapDefaultZoom = mapConfigModel.getMapDefaultZoom();
                            Integer mapMinZoom = mapConfigModel.getMapMinZoom();
                            Integer mapMaxZoom = mapConfigModel.getMapMaxZoom();
                            if (lastPasswordChange != null) {
                                maxDaysForLastPasswordChange = DateFormatUtility.getDaysDifference((LocalDate)lastPasswordChange, (LocalDate)LocalDate.now());
                            }
                            if (isAdmin) {
                                failedAttempt = 0;
                            }
                            if (failedAttempt < ((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt()) {
                                try {
                                    this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)jwtRequest.getUsername(), (Object)jwtRequest.getPassword()));
                                    UserDetails userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(jwtRequest.getUsername());
                                    if (!isAdmin && enabled != 1 && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                        returnValue.setStatus(Constants.Error.ACCOUNT_NOT_ENABLED);
                                        returnValue.setMessage("Login Failed");
                                        returnValue.setMessageDetail("User needs to enable the account");
                                        returnValue.setData((Object)flag);
                                    }
                                    if (!isAdmin && accountExpired && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                        returnValue.setStatus(Constants.Error.ACCOUNT_EXPIRED);
                                        returnValue.setMessage("Login Failed");
                                        returnValue.setMessageDetail(" Your account has been expired ");
                                        returnValue.setData((Object)flag);
                                    }
                                    if (!isAdmin && credentialExpired && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                        returnValue.setStatus(Constants.Error.CREDENTIAL_EXPIRED);
                                        returnValue.setMessage("Login Failed");
                                        returnValue.setMessageDetail("User need to change their password ");
                                        flag.setRequiredChangePassword(true);
                                        returnValue.setData((Object)flag);
                                    }
                                    if (!isAdmin && accountLocked && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                        returnValue.setStatus(Constants.Error.ACCOUNT_BLOCKED);
                                        returnValue.setMessage("Login Failed");
                                        returnValue.setMessageDetail("Your account has been locked");
                                        returnValue.setData((Object)flag);
                                    }
                                    if (!isAdmin && maxDaysForLastLogon >= (long)((PasswordConfig)passwordConfigs.get(0)).getExpiredCredential().intValue() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                        returnValue.setStatus(Constants.Error.TOO_MANY_DAYS);
                                        returnValue.setMessage("Login Failed");
                                        returnValue.setMessageDetail("User need to change the password ");
                                        flag.setRequiredChangePassword(true);
                                        returnValue.setData((Object)flag);
                                    }
                                    if (!isAdmin && maxDaysForLastPasswordChange >= (long)((PasswordConfig)passwordConfigs.get(0)).getPwdChangeNotice().intValue() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                        returnValue.setStatus(Constants.Error.TOO_MANY_DAYS);
                                        returnValue.setMessage("Login Failed");
                                        returnValue.setMessageDetail("User need to change the password ");
                                        flag.setRequiredChangePassword(true);
                                        returnValue.setData((Object)flag);
                                    }
                                    if (!isAdmin && failedAttempt >= ((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                        returnValue.setStatus(Constants.Error.TOO_MANY_FAILED_ATTEMPTS);
                                        returnValue.setMessage("Login Failed, Too many failed attempts");
                                        returnValue.setMessageDetail("User not allowed to Logged In again");
                                    }
                                    if (jwtRequest.getDeviceId() != null && StringUtils.hasLength((String)jwtRequest.getDeviceId())) {
                                        returnValue = this.validateDeviceAndUser(jwtRequest);
                                    }
                                    List roles = this.userRoleMenuService.rolesOfParticularUser(jwtRequest.getUsername());
                                    List roleId = this.userRoleService.roleIdOfParticularUser(jwtRequest.getUsername());
                                    if (!isAdmin && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                        String token = this.jwtUtil.generateToken(userDetails);
                                        String refreshToken = this.jwtUtil.generateRefreshToken(userDetails);
                                        ((User)userInfo.get()).setDeviceId(jwtRequest.getDeviceId());
                                        ((User)userInfo.get()).setLoggedIn(Boolean.valueOf(true));
                                        ((User)userInfo.get()).setFailedAttempts(Integer.valueOf(0));
                                        ((User)userInfo.get()).setLastLogon(LocalDate.now());
                                        this.userRepository.save(userInfo.get());
                                        returnValue.setMessage(" Authenticated ");
                                        returnValue.setMessageDetail("User has been successfully authenticated");
                                        List menu = this.userMenuService.getUserActiveMenu();
                                        returnValue.setData((Object)new AuthenticationRequestResponseModel(token, refreshToken, fullName, userId, jwtRequest.getUsername(), extensionName, extension, designation, rluCode, rluIp, sipPasswdEncrypt, sosNumber, department, zone, ecExtension, roles, menu, false, status, roleId, defaultPassword, pwdComplication, idealTimeout, coralApplication, sipPhoneButton, isCOUser.booleanValue(), ringAnswerCount, publicEmergencyNumber, broadcastNumber, primaryDomain, enableSsl, secondaryDomain, xmPPPrimaryDomain, xmPPSecondaryDomain, serverPort, enableGeoFencing, enablePrivateCall, enableVideoPrivateCall, enableVideoGroupCall, enableAudioMessage, enableVideoMessage, enableTextMessage, enableCoordinate, departmentList, clickToCall, wssDomain, mapURL, mapCenter, mapDefaultZoom, mapMinZoom, mapMaxZoom));
                                        logger.info(returnValue.getMessage());
                                    }
                                }
                                catch (BadCredentialsException | UsernameNotFoundException e) {
                                    ((User)userInfo.get()).setFailedAttempts(Integer.valueOf(++failedAttempt));
                                    this.userRepository.save(userInfo.get());
                                    returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                                    returnValue.setMessage("Login Failed");
                                    returnValue.setMessageDetail("Wrong username or password ");
                                    returnValue.setData((Object)("total " + String.valueOf(((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt() - failedAttempt) + " attempts remains"));
                                    logger.info(returnValue.getMessage());
                                }
                            } else {
                                returnValue.setStatus(Constants.Error.ACCOUNT_BLOCKED);
                                returnValue.setMessage("Login Failed");
                                returnValue.setMessageDetail("Your account has been locked, you have tried maximum attempts");
                                logger.info(returnValue.getMessage());
                            }
                        } else {
                            returnValue.setStatus(Constants.Error.ALREADY_LOGGED_IN);
                            returnValue.setMessage("Login Failed ");
                            returnValue.setMessageDetail("someone's already loggedIn On " + ((User)userInfo.get()).getIpAddress());
                            logger.info(returnValue.getMessage() + "," + returnValue.getMessageDetail());
                        }
                    }
                } else {
                    int enabled = ((User)userInfo.get()).getEnabled();
                    boolean accountExpired = ((User)userInfo.get()).getAccountExpired();
                    Integer userId = ((User)userInfo.get()).getId();
                    boolean credentialExpired = ((User)userInfo.get()).getCredentialsExpired();
                    boolean accountLocked = ((User)userInfo.get()).getAccountLocked();
                    int failedAttempt = ((User)userInfo.get()).getFailedAttempts();
                    LocalDate lastLogon = ((User)userInfo.get()).getLastLogon();
                    if (lastLogon == null) {
                        lastLogon = LocalDate.now();
                    }
                    LocalDate lastPasswordChange = ((User)userInfo.get()).getLastPasswordChange();
                    long maxDaysForLastLogon = DateFormatUtility.getDaysDifference((LocalDate)lastLogon, (LocalDate)LocalDate.now());
                    long maxDaysForLastPasswordChange = 0L;
                    String extensionName = this.authExtensionService.getExtName(this.authExtensionService.getExtensionOfUser(jwtRequest.getUsername()));
                    String extension = this.authExtensionService.getExtensionOfUser(jwtRequest.getUsername());
                    String designation = this.authExtensionService.getDesignation(extension);
                    String sosNumber = this.authExtensionService.getSOSNumber();
                    String department = this.authExtensionService.getDepartment(extension);
                    String zone = this.authExtensionService.getZone(extension);
                    String ecExtension = this.authExtensionService.getEcExtension(department, zone);
                    String sipPasswdEncrypt = this.extensionSecondaryService.getSipPassword(extension);
                    String rluCode = this.authExtensionService.getRluCodeForAll(extension);
                    String rluIp = this.controlRluServer.getVirtualIp(rluCode);
                    String status = ((User)userInfo.get()).getStatus();
                    String fullName = ((User)userInfo.get()).getUsername();
                    Boolean defaultPassword = ((PasswordConfig)passwordConfigs.get(0)).getDefaultPwd();
                    Boolean pwdComplication = ((PasswordConfig)passwordConfigs.get(0)).getPwdComplication();
                    Integer idealTimeout = ((PasswordConfig)passwordConfigs.get(0)).getIdealTimeout();
                    List coralApplication = this.externalApplicationService.applicationListByRole(jwtRequest.getUsername());
                    Object sipPhoneButton = this.sipPhoneConfiguration.getSipPhoneButtonConfiguration().getData();
                    Boolean isCOUser = this.vipMasterRepository.existsByOfficeExtension(extension);
                    String publicEmergencyNumber = ((User)userInfo.get()).getPublicEmergencyNumber();
                    String broadcastNumber = ((User)userInfo.get()).getBroadcastNumber();
                    Integer ringAnswerCount = ((User)userInfo.get()).getDispatcherAutoAnswer() != false ? ((User)userInfo.get()).getRingAnswerCount() : 0;
                    String primaryDomain = configValues.getPrimaryDomain();
                    boolean enableSsl = configValues.isEnableSsl();
                    String secondaryDomain = configValues.getSecondaryDomain();
                    String xmPPPrimaryDomain = configValues.getXmPPPrimaryDomain();
                    String xmPPSecondaryDomain = configValues.getXmPPSecondaryDomain();
                    String serverPort = configValues.getServerPort();
                    boolean enableGeoFencing = false;
                    boolean enablePrivateCall = true;
                    boolean enableVideoPrivateCall = true;
                    boolean enableVideoGroupCall = false;
                    boolean enableAudioMessage = true;
                    boolean enableVideoMessage = true;
                    boolean enableTextMessage = false;
                    boolean enableCoordinate = false;
                    List departmentList = this.userService.getAssociatedDepartment(jwtRequest.getUsername(), department);
                    String clickToCall = Constants.CLICK_TO_CALL_IP;
                    String wssDomain = this.userService.getWssDomain(extension);
                    String existingDeviceId = ((User)userInfo.get()).getDeviceId();
                    String mapURL = mapConfigModel.getMapURL();
                    List mapCenter = mapConfigModel.getMapCenter();
                    Integer mapDefaultZoom = mapConfigModel.getMapDefaultZoom();
                    Integer mapMinZoom = mapConfigModel.getMapMinZoom();
                    Integer mapMaxZoom = mapConfigModel.getMapMaxZoom();
                    if (lastPasswordChange != null) {
                        maxDaysForLastPasswordChange = DateFormatUtility.getDaysDifference((LocalDate)lastPasswordChange, (LocalDate)LocalDate.now());
                    }
                    if (isAdmin) {
                        failedAttempt = 0;
                    }
                    if (failedAttempt < ((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt()) {
                        try {
                            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)jwtRequest.getUsername(), (Object)jwtRequest.getPassword()));
                            UserDetails userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(jwtRequest.getUsername());
                            if (!isAdmin && enabled != 1 && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(Constants.Error.ACCOUNT_NOT_ENABLED);
                                returnValue.setMessage("Login Failed");
                                returnValue.setMessageDetail("User needs to enable the account");
                                returnValue.setData((Object)flag);
                            }
                            if (!isAdmin && accountExpired && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(Constants.Error.ACCOUNT_EXPIRED);
                                returnValue.setMessage("Login Failed");
                                returnValue.setMessageDetail(" Your account has been expired ");
                                returnValue.setData((Object)flag);
                            }
                            if (!isAdmin && credentialExpired && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(Constants.Error.CREDENTIAL_EXPIRED);
                                returnValue.setMessage("Login Failed");
                                returnValue.setMessageDetail("User need to change their password ");
                                flag.setRequiredChangePassword(true);
                                returnValue.setData((Object)flag);
                            }
                            if (!isAdmin && accountLocked && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(Constants.Error.ACCOUNT_BLOCKED);
                                returnValue.setMessage("Login Failed");
                                returnValue.setMessageDetail("Your account has been locked");
                                returnValue.setData((Object)flag);
                            }
                            if (!isAdmin && maxDaysForLastLogon >= (long)((PasswordConfig)passwordConfigs.get(0)).getExpiredCredential().intValue() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(Constants.Error.TOO_MANY_DAYS);
                                returnValue.setMessage("Login Failed");
                                returnValue.setMessageDetail("User need to change the password ");
                                flag.setRequiredChangePassword(true);
                                returnValue.setData((Object)flag);
                            }
                            if (!isAdmin && maxDaysForLastPasswordChange >= (long)((PasswordConfig)passwordConfigs.get(0)).getPwdChangeNotice().intValue() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(Constants.Error.TOO_MANY_DAYS);
                                returnValue.setMessage("Login Failed");
                                returnValue.setMessageDetail("User need to change the password ");
                                flag.setRequiredChangePassword(true);
                                returnValue.setData((Object)flag);
                            }
                            if (!isAdmin && failedAttempt >= ((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt() && returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                                returnValue.setStatus(Constants.Error.TOO_MANY_FAILED_ATTEMPTS);
                                returnValue.setMessage("Login Failed, Too many failed attempts");
                                returnValue.setMessageDetail("User not allowed to Logged In again");
                            }
                            if (jwtRequest.getDeviceId() != null && StringUtils.hasLength((String)jwtRequest.getDeviceId())) {
                                returnValue = this.validateDeviceAndUser(jwtRequest);
                            }
                            List roles = this.userRoleMenuService.rolesOfParticularUser(jwtRequest.getUsername());
                            List roleId = this.userRoleService.roleIdOfParticularUser(jwtRequest.getUsername());
                            if (!returnValue.getStatus().equals((Object)Constants.Error.OK)) break block67;
                            long currentTime = System.currentTimeMillis();
                            Optional existingRecordOpt = this.userService.getUserByName(userDetails.getUsername());
                            if (!existingRecordOpt.isPresent()) break block67;
                            Long tokenEpoch = ((User)existingRecordOpt.get()).getTokenEpoch();
                            if (tokenEpoch != null && tokenEpoch > currentTime) {
                                String token = this.jwtUtil.generateTokenByDB(userDetails, ((User)existingRecordOpt.get()).getUuidSecurity());
                                String refreshToken = this.jwtUtil.generateRefreshTokenByDB(userDetails, ((User)existingRecordOpt.get()).getUuidSecurity());
                                Long expiryTokenMillis = this.jwtUtil.getTokenExpirationEpoch(token);
                                Long expiryRefreshTokenMillis = this.jwtUtil.getRefreshTokenExpirationEpoch(refreshToken);
                                ((User)userInfo.get()).setTokenEpoch(expiryTokenMillis);
                                ((User)userInfo.get()).setRefreshTokenEpoch(expiryRefreshTokenMillis);
                                this.userRepository.save(userInfo.get());
                                logger.info("Generating token by DB for userDB Token : {} ", (Object)token);
                                returnValue.setMessage(" Authenticated ");
                                returnValue.setMessageDetail("User has been successfully authenticated");
                                List menu = this.userMenuService.getUserActiveMenu();
                                returnValue.setData((Object)new AuthenticationRequestResponseModel(token, refreshToken, fullName, userId, jwtRequest.getUsername(), extensionName, extension, designation, rluCode, rluIp, sipPasswdEncrypt, sosNumber, department, zone, ecExtension, roles, menu, false, status, roleId, defaultPassword, pwdComplication, idealTimeout, coralApplication, sipPhoneButton, isCOUser.booleanValue(), ringAnswerCount, publicEmergencyNumber, broadcastNumber, primaryDomain, enableSsl, secondaryDomain, xmPPPrimaryDomain, xmPPSecondaryDomain, serverPort, enableGeoFencing, enablePrivateCall, enableVideoPrivateCall, enableVideoGroupCall, enableAudioMessage, enableVideoMessage, enableTextMessage, enableCoordinate, departmentList, clickToCall, wssDomain, mapURL, mapCenter, mapDefaultZoom, mapMinZoom, mapMaxZoom));
                                logger.info(returnValue.getMessage());
                                break block67;
                            }
                            String token = this.jwtUtil.generateToken(userDetails);
                            String refreshToken = this.jwtUtil.generateRefreshToken(userDetails);
                            String uuidToken = this.jwtUtil.getClaimFromToken(token, "uuidSecurity", false);
                            String uuidRefreshToken = this.jwtUtil.getClaimFromToken(refreshToken, "uuidSecurity", true);
                            Long expiryTokenMillis = this.jwtUtil.getTokenExpirationEpoch(token);
                            Long expiryRefreshTokenMillis = this.jwtUtil.getRefreshTokenExpirationEpoch(refreshToken);
                            ((User)userInfo.get()).setDeviceId(jwtRequest.getDeviceId());
                            ((User)userInfo.get()).setLoggedIn(Boolean.valueOf(true));
                            ((User)userInfo.get()).setFailedAttempts(Integer.valueOf(0));
                            ((User)userInfo.get()).setLastLogon(LocalDate.now());
                            ((User)userInfo.get()).setUuidSecurity(uuidToken);
                            ((User)userInfo.get()).setTokenEpoch(expiryTokenMillis);
                            ((User)userInfo.get()).setRefreshTokenEpoch(expiryRefreshTokenMillis);
                            this.userRepository.save(userInfo.get());
                            returnValue.setMessage(" Authenticated ");
                            returnValue.setMessageDetail("User has been successfully authenticated");
                            List menu = this.userMenuService.getUserActiveMenu();
                            returnValue.setData((Object)new AuthenticationRequestResponseModel(token, refreshToken, fullName, userId, jwtRequest.getUsername(), extensionName, extension, designation, rluCode, rluIp, sipPasswdEncrypt, sosNumber, department, zone, ecExtension, roles, menu, false, status, roleId, defaultPassword, pwdComplication, idealTimeout, coralApplication, sipPhoneButton, isCOUser.booleanValue(), ringAnswerCount, publicEmergencyNumber, broadcastNumber, primaryDomain, enableSsl, secondaryDomain, xmPPPrimaryDomain, xmPPSecondaryDomain, serverPort, enableGeoFencing, enablePrivateCall, enableVideoPrivateCall, enableVideoGroupCall, enableAudioMessage, enableVideoMessage, enableTextMessage, enableCoordinate, departmentList, clickToCall, wssDomain, mapURL, mapCenter, mapDefaultZoom, mapMinZoom, mapMaxZoom));
                            logger.info(returnValue.getMessage());
                        }
                        catch (BadCredentialsException | UsernameNotFoundException e) {
                            ((User)userInfo.get()).setFailedAttempts(Integer.valueOf(++failedAttempt));
                            this.userRepository.save(userInfo.get());
                            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                            returnValue.setMessage("Login Failed");
                            returnValue.setMessageDetail("Wrong username or password ");
                            returnValue.setData((Object)("total " + String.valueOf(((PasswordConfig)passwordConfigs.get(0)).getMaxAttempt() - failedAttempt) + " attempts remains"));
                            logger.info(returnValue.getMessage());
                        }
                    } else {
                        returnValue.setStatus(Constants.Error.ACCOUNT_BLOCKED);
                        returnValue.setMessage("Login Failed");
                        returnValue.setMessageDetail("Your account has been locked, you have tried maximum attempts");
                        logger.info(returnValue.getMessage());
                    }
                }
            } else {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Login Failed ");
                returnValue.setMessageDetail("Wrong username or password ");
                logger.info(returnValue.getMessage());
            }
        }
        return returnValue;
    }

    public RequestResponse refreshToken(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        UserDetails userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(principal.getName());
        Optional userOpt = this.userService.getUserByName(principal.getName());
        if (!userOpt.isPresent()) {
            throw new BadCredentialsException("User not found");
        }
        User user = (User)userOpt.get();
        String uuid = user.getUuidSecurity();
        String newAccessToken = this.jwtUtil.generateTokenByDB(userDetails, uuid);
        String newRefreshToken = this.jwtUtil.generateRefreshTokenByDB(userDetails, uuid);
        user.setTokenEpoch(this.jwtUtil.getTokenExpirationEpoch(newAccessToken));
        user.setRefreshTokenEpoch(this.jwtUtil.getRefreshTokenExpirationEpoch(newRefreshToken));
        this.userRepository.save((Object)user);
        returnValue.setData((Object)new RefreshTokenResponseModel(newAccessToken, newRefreshToken));
        return returnValue;
    }

    public RequestResponse updatePassword(ChangePasswordModel data) {
        RequestResponse returnValue;
        block7: {
            returnValue = new RequestResponse();
            Optional user = this.userRepository.findByUsername(data.getUsername());
            if (user.isPresent() && this.bcryptEncoder.matches((CharSequence)data.getOldPassword(), ((User)user.get()).getPassword())) {
                try {
                    if (!this.bcryptEncoder.matches((CharSequence)data.getNewPassword(), ((User)user.get()).getPassword())) {
                        if (data.getNewPassword().equals(data.getConfirmPassword())) {
                            ((User)user.get()).setPassword(this.bcryptEncoder.encode((CharSequence)data.getNewPassword()));
                            ((User)user.get()).setLastPasswordChange(LocalDate.now());
                            ((User)user.get()).setCredentialsExpired(Boolean.valueOf(false));
                            ((User)user.get()).setLastLogon(LocalDate.now());
                            this.userRepository.save(user.get());
                            ReturnField field = new ReturnField();
                            field.setId(((User)user.get()).getId().intValue());
                            field.setDescription(((User)user.get()).getUsername());
                            returnValue.setData((Object)field);
                            returnValue.setStatus(Constants.Error.OK);
                            returnValue.setMessage("Successfully Changed Your password");
                            logger.info(returnValue.getMessage());
                        } else {
                            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                            returnValue.setMessage("Unable to change the password");
                            returnValue.setMessageDetail("newPassword & confirmPassword does not match");
                            logger.info(returnValue.getMessage());
                        }
                        break block7;
                    }
                    returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                    returnValue.setMessage("Unable to change your password");
                    returnValue.setMessageDetail("please enter the different newPassword");
                    logger.info(returnValue.getMessage());
                }
                catch (Exception ex) {
                    returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                    returnValue.setMessage("Unable to change password");
                    returnValue.setMessageDetail("Contact with your administrator");
                    logger.info(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Unable to change password");
                returnValue.setMessageDetail("wrong username or oldPassword");
                logger.info(returnValue.getMessage());
            }
        }
        return returnValue;
    }

    public DeviceInformationModel getDeviceInfo(String username, String deviceId) {
        DeviceInformationModel record = new DeviceInformationModel();
        record.setUsername(username);
        record.setDeviceId(deviceId);
        return record;
    }

    public RequestResponse getUserLoginResponse(Principal principal, HttpServletRequest request) {
        RequestResponse returnValue = new RequestResponse();
        try {
            List roles = this.userRoleMenuService.rolesOfParticularUser(principal.getName());
            List roleId = this.userRoleService.roleIdOfParticularUser(principal.getName());
            List menu = this.userMenuService.getUserActiveMenu();
            CoralFileModel configValues = this.userService.readConfigFile();
            MapConfigModel mapConfigModel = this.userService.mapConfiguration(request);
            List passwordConfigs = this.passwordConfigRepository.findAll();
            Optional userInfo = this.userRepository.findByUsername(principal.getName());
            int enabled = ((User)userInfo.get()).getEnabled();
            boolean accountExpired = ((User)userInfo.get()).getAccountExpired();
            boolean credentialExpired = ((User)userInfo.get()).getCredentialsExpired();
            boolean accountLocked = ((User)userInfo.get()).getAccountLocked();
            int failedAttempt = ((User)userInfo.get()).getFailedAttempts();
            Integer userId = ((User)userInfo.get()).getId();
            String publicEmergencyNumber = ((User)userInfo.get()).getPublicEmergencyNumber();
            String broadcastNumber = ((User)userInfo.get()).getBroadcastNumber();
            LocalDate lastLogon = ((User)userInfo.get()).getLastLogon();
            if (lastLogon == null) {
                lastLogon = LocalDate.now();
            }
            LocalDate lastPasswordChange = ((User)userInfo.get()).getLastPasswordChange();
            long maxDaysForLastLogon = DateFormatUtility.getDaysDifference((LocalDate)lastLogon, (LocalDate)LocalDate.now());
            long maxDaysForLastPasswordChange = 0L;
            String extensionName = this.authExtensionService.getExtName(this.authExtensionService.getExtensionOfUser(principal.getName()));
            String extension = this.authExtensionService.getExtensionOfUser(principal.getName());
            String designation = this.authExtensionService.getDesignation(extension);
            String sosNumber = this.authExtensionService.getSOSNumber();
            String department = this.authExtensionService.getDepartment(extension);
            String zone = this.authExtensionService.getZone(extension);
            String ecExtension = this.authExtensionService.getEcExtension(department, zone);
            String sipPasswdEncrypt = this.extensionSecondaryService.getSipPassword(extension);
            String rluCode = this.authExtensionService.getRluCodeForAll(extension);
            String rluIp = this.controlRluServer.getVirtualIp(rluCode);
            String status = ((User)userInfo.get()).getStatus();
            String fullName = ((User)userInfo.get()).getUsername();
            List departmentList = this.userService.getAssociatedDepartment(principal.getName(), department);
            String clickToCall = Constants.CLICK_TO_CALL_IP;
            String wssDomain = this.userService.getWssDomain(extension);
            Boolean defaultPassword = ((PasswordConfig)passwordConfigs.get(0)).getDefaultPwd();
            Boolean pwdComplication = ((PasswordConfig)passwordConfigs.get(0)).getPwdComplication();
            Integer idealTimeout = ((PasswordConfig)passwordConfigs.get(0)).getIdealTimeout();
            List coralApplication = this.externalApplicationService.applicationListByRole(principal.getName());
            Object sipPhoneButton = this.sipPhoneConfiguration.getSipPhoneButtonConfiguration().getData();
            Boolean isCOUser = this.vipMasterRepository.existsByOfficeExtension(extension);
            Integer ringAnswerCount = ((User)userInfo.get()).getDispatcherAutoAnswer() != false ? ((User)userInfo.get()).getRingAnswerCount() : 0;
            String primaryDomain = configValues.getPrimaryDomain();
            boolean enableSsl = configValues.isEnableSsl();
            String secondaryDomain = configValues.getSecondaryDomain();
            String xmPPPrimaryDomain = configValues.getXmPPPrimaryDomain();
            String xmPPSecondaryDomain = configValues.getXmPPSecondaryDomain();
            String serverPort = configValues.getServerPort();
            String mapURL = mapConfigModel.getMapURL();
            List mapCenter = mapConfigModel.getMapCenter();
            Integer mapDefaultZoom = mapConfigModel.getMapDefaultZoom();
            Integer mapMinZoom = mapConfigModel.getMapMinZoom();
            Integer mapMaxZoom = mapConfigModel.getMapMaxZoom();
            if (lastPasswordChange != null) {
                maxDaysForLastPasswordChange = DateFormatUtility.getDaysDifference((LocalDate)lastPasswordChange, (LocalDate)LocalDate.now());
            }
            boolean enableGeoFencing = false;
            boolean enablePrivateCall = true;
            boolean enableVideoPrivateCall = true;
            boolean enableVideoGroupCall = false;
            boolean enableAudioMessage = true;
            boolean enableVideoMessage = true;
            boolean enableTextMessage = false;
            boolean enableCoordinate = false;
            returnValue.setData((Object)new AuthenticationRequestResponseModel("", "", fullName, userId, ((User)userInfo.get()).getUsername(), extensionName, extension, designation, rluCode, rluIp, sipPasswdEncrypt, sosNumber, department, zone, ecExtension, roles, menu, false, status, roleId, defaultPassword, pwdComplication, idealTimeout, coralApplication, sipPhoneButton, isCOUser.booleanValue(), ringAnswerCount, publicEmergencyNumber, broadcastNumber, primaryDomain, enableSsl, secondaryDomain, xmPPPrimaryDomain, xmPPSecondaryDomain, serverPort, enableGeoFencing, enablePrivateCall, enableVideoPrivateCall, enableVideoGroupCall, enableAudioMessage, enableVideoMessage, enableTextMessage, enableCoordinate, departmentList, clickToCall, wssDomain, mapURL, mapCenter, mapDefaultZoom, mapMinZoom, mapMaxZoom));
            returnValue.setMessage("response of user");
            returnValue.setMessageDetail("data fetched successfully");
        }
        catch (Exception e) {
            logger.error("Error while fetching data of user:{}", (Object)principal.getName());
            returnValue.setMessage("Unable to find data");
            returnValue.setMessageDetail("Contact to Administrator");
        }
        return returnValue;
    }

    public synchronized RequestResponse validateDeviceAndUser(AuthenticationRequestModel jwtRequest) {
        RequestResponse returnValue = new RequestResponse();
        String providedDeviceId = jwtRequest.getDeviceId();
        String providedUsername = jwtRequest.getUsername();
        Optional deviceAssignedUser = this.userRepository.findByDeviceId(providedDeviceId);
        if (deviceAssignedUser.isPresent() && !((User)deviceAssignedUser.get()).getUsername().equals(providedUsername)) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Device ID is already assigned to another user");
            returnValue.setMessageDetail("Device is assigned to user: " + ((User)deviceAssignedUser.get()).getUsername());
            logger.error("Device ID: {} is assigned to user: {}", (Object)providedDeviceId, (Object)((User)deviceAssignedUser.get()).getUsername());
            return returnValue;
        }
        Optional userWithDifferentDevice = this.userRepository.findByUsername(providedUsername);
        if (userWithDifferentDevice.isPresent() && ((User)userWithDifferentDevice.get()).getDeviceId() != null && !Objects.equals(((User)userWithDifferentDevice.get()).getDeviceId(), providedDeviceId)) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("User is assigned to a different device ID");
            returnValue.setMessageDetail("User: " + providedUsername + " is assigned to device: " + ((User)userWithDifferentDevice.get()).getDeviceId());
            logger.error("User: {} is assigned to a different device ID: {}", (Object)providedUsername, (Object)((User)userWithDifferentDevice.get()).getDeviceId());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Validation successful");
        returnValue.setMessageDetail("Device and user are valid");
        logger.info("Validation successful for user: {}, device: {}", (Object)providedUsername, (Object)providedDeviceId);
        return returnValue;
    }

    public RequestResponse generateOTP(GenerateOtpModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional userData = this.userRepository.findByUsername(data.getNumber());
        Long currentTime = Instant.now().getEpochSecond();
        if (userData.isPresent()) {
            String lastOtpGeneratedOnStr = ((User)userData.get()).getOtpGeneratedOn();
            Long lastOtpGeneratedOn = lastOtpGeneratedOnStr != null ? Long.parseLong(lastOtpGeneratedOnStr) : 0L;
            long elapsedTime = currentTime - lastOtpGeneratedOn;
            long remainingTime = 300L - elapsedTime;
            if (elapsedTime < 300L) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("OTP can only be regenerated after " + remainingTime / 60L + " minutes and " + remainingTime % 60L + " seconds.");
                returnValue.setMessageDetail("Please wait before requesting a new OTP.");
                logger.info("OTP request denied for number {}: OTP was recently generated. Try again in {} minutes and {} seconds.", (Object)data.getNumber(), (Object)(remainingTime / 60L), (Object)(remainingTime % 60L));
                return returnValue;
            }
            Integer otp = (int)(Math.random() * 90000.0) + 10000;
            ((User)userData.get()).setOtpCode(otp);
            ((User)userData.get()).setOtpGeneratedOn(String.valueOf(Instant.now().getEpochSecond()));
            this.userRepository.save(userData.get());
            boolean otpSent = this.sendOtpViaKit19(data.getNumber(), otp);
            if (otpSent) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OTP Generated and Sent Successfully");
                returnValue.setData((Object)data);
                logger.info("OTP for number {}: {}", (Object)data.getNumber(), (Object)otp);
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("OTP Generation Successful, but Failed to Send via SMS");
            }
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Number");
            returnValue.setMessageDetail("Select existing number from directory");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public boolean sendOtpViaKit19(String phoneNumber, Integer otp) {
        try {
            String inputLine;
            String message = "Your One-Time Password (OTP) for accessing your CoralMCX PPDR account is " + otp + ". This OTP is valid for the next 10 minutes. Please do not share this code with anyone. For assistance, please reach out to our support team at helpdesk@coraltele.com.";
            String encodedMessage = URLEncoder.encode(message, "UTF-8").replace("+", "%20").replace("%3A", ":").replace("%40", "@").replace("%2C", ",");
            String urlStr = String.format("http://www.kit19.com/ComposeSMS.aspx?username=%s&password=%s&sender=%s&to=%s&message=%s&priority=1&dnd=1&unicode=0&dlttemplateid=%s", "coral351881", "13158", "CTLMCX", phoneNumber, encodedMessage, "1707174158709368831");
            logger.info("Final OTP URL: {}", (Object)urlStr);
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            conn.setRequestProperty("Accept-Language", "en-US,en;q=0.9");
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            int responseCode = conn.getResponseCode();
            logger.info("Response Code: {}", (Object)responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            logger.info("Kit19 Response Body: {}", (Object)response.toString());
            return responseCode == 200 && response.toString().contains("Sent");
        }
        catch (Exception e) {
            logger.error("Failed to send OTP via Kit19: {}", (Object)e.getMessage());
            return false;
        }
    }

    public RequestResponse loginByNumberAndOtp(GenerateOtpModel data, HttpServletRequest request) {
        RequestResponse returnValue;
        block10: {
            returnValue = new RequestResponse();
            try {
                if (!StringUtils.hasText((String)data.getNumber()) && data.getOtp() != null) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Invalid Number or Otp");
                    returnValue.setMessageDetail("Verify the number and otp again");
                    logger.error("Improper data to authenticate user");
                    return returnValue;
                }
                Optional userInfo = this.userRepository.findByUsernameAndOtpCode(data.getNumber(), data.getOtp());
                if (userInfo.isPresent()) {
                    long oldEpochTime = Long.valueOf(((User)userInfo.get()).getOtpGeneratedOn());
                    long currentEpochTime = Instant.now().getEpochSecond();
                    String username = ((User)userInfo.get()).getUsername();
                    String password = ((User)userInfo.get()).getPassword();
                    if (currentEpochTime - oldEpochTime > 1200L) {
                        returnValue.setStatus(Constants.Error.CREDENTIAL_EXPIRED);
                        returnValue.setMessage("Selected OTP is expired");
                        returnValue.setMessageDetail("Please regenerate the otp");
                        logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
                        return returnValue;
                    }
                    CoralFileModel configValues = this.userService.readConfigFile();
                    MapConfigModel mapConfigModel = this.userService.mapConfiguration(request);
                    int enabled = ((User)userInfo.get()).getEnabled();
                    boolean accountExpired = ((User)userInfo.get()).getAccountExpired();
                    Integer userId = ((User)userInfo.get()).getId();
                    boolean credentialExpired = ((User)userInfo.get()).getCredentialsExpired();
                    boolean accountLocked = ((User)userInfo.get()).getAccountLocked();
                    int failedAttempt = ((User)userInfo.get()).getFailedAttempts();
                    LocalDate lastLogon = ((User)userInfo.get()).getLastLogon();
                    if (lastLogon == null) {
                        lastLogon = LocalDate.now();
                    }
                    LocalDate lastPasswordChange = ((User)userInfo.get()).getLastPasswordChange();
                    long maxDaysForLastLogon = DateFormatUtility.getDaysDifference((LocalDate)lastLogon, (LocalDate)LocalDate.now());
                    long maxDaysForLastPasswordChange = 0L;
                    String extensionName = this.authExtensionService.getExtensionOfUser(((User)userInfo.get()).getUsername());
                    String extension = this.authExtensionService.getExtensionOfUser(((User)userInfo.get()).getUsername());
                    String designation = this.authExtensionService.getDesignation(extension);
                    String sosNumber = this.authExtensionService.getSOSNumber();
                    String department = this.authExtensionService.getDepartment(extension);
                    String zone = this.authExtensionService.getZone(extension);
                    String ecExtension = this.authExtensionService.getEcExtension(department, zone);
                    String sipPasswdEncrypt = this.extensionSecondaryService.getSipPassword(extension);
                    String rluCode = this.authExtensionService.getRluCodeForAll(extension);
                    String rluIp = this.controlRluServer.getVirtualIp(rluCode);
                    String status = ((User)userInfo.get()).getStatus();
                    String fullName = ((User)userInfo.get()).getUsername();
                    Boolean defaultPassword = false;
                    Boolean pwdComplication = false;
                    Integer idealTimeout = 0;
                    List coralApplication = this.externalApplicationService.applicationListByRole(((User)userInfo.get()).getUsername());
                    Object sipPhoneButton = this.sipPhoneConfiguration.getSipPhoneButtonConfiguration().getData();
                    Boolean isCOUser = this.vipMasterRepository.existsByOfficeExtension(extension);
                    String publicEmergencyNumber = ((User)userInfo.get()).getPublicEmergencyNumber();
                    String broadcastNumber = ((User)userInfo.get()).getBroadcastNumber();
                    Integer ringAnswerCount = ((User)userInfo.get()).getDispatcherAutoAnswer() != false ? ((User)userInfo.get()).getRingAnswerCount() : 0;
                    String primaryDomain = configValues.getPrimaryDomain();
                    boolean enableSsl = configValues.isEnableSsl();
                    String secondaryDomain = configValues.getSecondaryDomain();
                    String xmPPPrimaryDomain = configValues.getXmPPPrimaryDomain();
                    String xmPPSecondaryDomain = configValues.getXmPPSecondaryDomain();
                    String serverPort = configValues.getServerPort();
                    boolean enableGeoFencing = false;
                    boolean enablePrivateCall = true;
                    boolean enableVideoPrivateCall = true;
                    boolean enableVideoGroupCall = false;
                    boolean enableAudioMessage = true;
                    boolean enableVideoMessage = true;
                    boolean enableTextMessage = false;
                    boolean enableCoordinate = false;
                    String wssDomain = this.userService.getWssDomain(extension);
                    String mapURL = mapConfigModel.getMapURL();
                    List mapCenter = mapConfigModel.getMapCenter();
                    Integer mapDefaultZoom = mapConfigModel.getMapDefaultZoom();
                    Integer mapMinZoom = mapConfigModel.getMapMinZoom();
                    Integer mapMaxZoom = mapConfigModel.getMapMaxZoom();
                    List departmentList = this.userService.getAssociatedDepartment(((User)userInfo.get()).getUsername(), department);
                    String clickToCall = Constants.CLICK_TO_CALL_IP;
                    String existingDeviceId = ((User)userInfo.get()).getDeviceId();
                    if (lastPasswordChange != null) {
                        maxDaysForLastPasswordChange = DateFormatUtility.getDaysDifference((LocalDate)lastPasswordChange, (LocalDate)LocalDate.now());
                    }
                    try {
                        UserDetails userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(((User)userInfo.get()).getUsername());
                        List roles = this.userRoleMenuService.rolesOfParticularUser(((User)userInfo.get()).getUsername());
                        List roleId = this.userRoleService.roleIdOfParticularUser(((User)userInfo.get()).getUsername());
                        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                            String token = this.jwtUtil.generateToken(userDetails);
                            String refreshToken = this.jwtUtil.generateRefreshToken(userDetails);
                            ((User)userInfo.get()).setLastLogon(LocalDate.now());
                            this.userRepository.save(userInfo.get());
                            returnValue.setMessage(" Authenticated ");
                            returnValue.setMessageDetail("User has been successfully authenticated");
                            List menu = this.userMenuService.getUserActiveMenu();
                            returnValue.setData((Object)new AuthenticationRequestResponseModel(token, refreshToken, fullName, userId, ((User)userInfo.get()).getUsername(), extensionName, extension, designation, rluCode, rluIp, sipPasswdEncrypt, sosNumber, department, zone, ecExtension, roles, menu, false, status, roleId, defaultPassword, pwdComplication, idealTimeout, coralApplication, sipPhoneButton, isCOUser.booleanValue(), ringAnswerCount, publicEmergencyNumber, broadcastNumber, primaryDomain, enableSsl, secondaryDomain, xmPPPrimaryDomain, xmPPSecondaryDomain, serverPort, enableGeoFencing, enablePrivateCall, enableVideoPrivateCall, enableVideoGroupCall, enableAudioMessage, enableVideoMessage, enableTextMessage, enableCoordinate, departmentList, clickToCall, wssDomain, mapURL, mapCenter, mapDefaultZoom, mapMinZoom, mapMaxZoom));
                            logger.info(returnValue.getMessage());
                        }
                        break block10;
                    }
                    catch (BadCredentialsException | UsernameNotFoundException e) {
                        e.printStackTrace();
                        returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                        returnValue.setMessage("Login Failed");
                        returnValue.setMessageDetail("Wrong username or password ");
                        logger.info(e.getMessage());
                    }
                    break block10;
                }
                returnValue.setStatus(Constants.Error.INCORRECT_CREDENTIALS);
                returnValue.setMessage("Selected number or otp incorrect");
                returnValue.setMessageDetail("verify the number and otp again");
                logger.info(returnValue.getMessage());
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Contact to Administrator");
                returnValue.setMessageDetail("Error Occured on authenticate user with otp");
                logger.error(returnValue.getMessage());
            }
        }
        return returnValue;
    }

    private boolean isFailedAttemptExempt(User user) {
        return this.userRoleRepository.findByUser(user).stream().anyMatch(r -> {
            String role = r.getRole().getShortCode();
            return role.equalsIgnoreCase("ROLE_ADMIN");
        });
    }
}

