/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.userWidget.doughnutChart.service;

import com.coraltele.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.db.telemetry.main.entity.UserWidget;
import com.coraltele.db.telemetry.main.repository.DoughnutChartRepository;
import com.coraltele.db.telemetry.main.repository.UserWidgetRepository;
import com.coraltele.db.telemetry.main.specification.DoughnutChartViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.userWidget.doughnutChart.model.DoughnutModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DoughnutChartService {
    private static final Logger logger = LogManager.getLogger(DoughnutChartService.class);
    @Autowired
    UserWidgetRepository userWidgetRepository;
    @Autowired
    WidgetTypeRepository widgetTypeRepository;
    @Autowired
    DoughnutChartRepository doughnutViewRepository;

    public RequestResponse createData(DoughnutModel data, Principal principal) {
        logger.debug("Create New Doughnut : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            UserWidget userWidget = new UserWidget();
            Optional widgetType = this.widgetTypeRepository.findById(Integer.valueOf(7));
            if (widgetType.isPresent()) {
                userWidget.setApiURL(data.getApiURL());
                userWidget.setChartType(data.getChartType());
                userWidget.setLegendField(data.getLegendField());
                userWidget.setLegendFieldDataType(data.getLegendFieldDataType());
                userWidget.setName(data.getName());
                userWidget.setRefreshInterval(data.getRefreshInterval());
                userWidget.setValueField(data.getValueField());
                userWidget.setValueFieldDataType(data.getValueFieldDataType());
                userWidget.setCode(data.getCode());
                userWidget.setHasWebSocketUpdate(data.getHasWebSocketUpdate());
                userWidget.setWidgetType((WidgetType)widgetType.get());
                userWidget.setCategory(data.getCategory());
                userWidget.setActions(data.getActions());
                userWidget.setShowLegends(data.getShowLegends());
                userWidget.setUuid(UUID.randomUUID().toString());
                userWidget.setCreatedBy(principal.getName());
                userWidget.setCreatedOn(LocalDateTime.now());
                userWidget.setDashboardLayout(data.getDashboardLayout());
                this.userWidgetRepository.save((Object)userWidget);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found");
                returnValue.setMessageDetail("Doughnut Not Found");
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Doughnut created successfully");
            returnValue.setData((Object)userWidget.getUuid());
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create Doughnut");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DoughnutModel data) {
        logger.debug("Update Doughnut {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userWidget = this.userWidgetRepository.findById((Object)data.getId());
        if (!userWidget.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not found");
            returnValue.setMessageDetail("Doughnut Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((UserWidget)userWidget.get()).setCode(data.getCode());
        }
        if (data.getApiURL() != null) {
            ((UserWidget)userWidget.get()).setApiURL(data.getApiURL());
        }
        if (data.getCategory() != null) {
            ((UserWidget)userWidget.get()).setCategory(data.getCategory());
        }
        if (data.getChartType() != null) {
            ((UserWidget)userWidget.get()).setChartType(data.getChartType());
        }
        if (data.getHasWebSocketUpdate() != null) {
            ((UserWidget)userWidget.get()).setHasWebSocketUpdate(data.getHasWebSocketUpdate());
        }
        if (data.getLegendField() != null) {
            ((UserWidget)userWidget.get()).setLegendField(data.getLegendField());
        }
        if (data.getLegendFieldDataType() != null) {
            ((UserWidget)userWidget.get()).setLegendFieldDataType(data.getLegendFieldDataType());
        }
        if (data.getShowLegends() != null) {
            ((UserWidget)userWidget.get()).setShowLegends(data.getShowLegends());
        }
        if (data.getActions() != null) {
            ((UserWidget)userWidget.get()).setActions(data.getActions());
        }
        if (data.getName() != null) {
            ((UserWidget)userWidget.get()).setName(data.getName());
        }
        if (data.getRefreshInterval() != null) {
            ((UserWidget)userWidget.get()).setRefreshInterval(data.getRefreshInterval());
        }
        if (data.getValueField() != null) {
            ((UserWidget)userWidget.get()).setValueField(data.getValueField());
        }
        if (data.getValueFieldDataType() != null) {
            ((UserWidget)userWidget.get()).setValueFieldDataType(data.getValueFieldDataType());
        }
        if (data.getDashboardLayout() != null) {
            ((UserWidget)userWidget.get()).setDashboardLayout(data.getDashboardLayout());
        }
        this.userWidgetRepository.save(userWidget.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Doughnut Updated Successfully");
        returnValue.setData((Object)((UserWidget)userWidget.get()).getUuid());
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteDoughnutById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional userWidget = this.userWidgetRepository.findById((Object)ids);
            if (userWidget.isPresent()) {
                addValue.add(userWidget.get());
                this.userWidgetRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllDoughnutByFilter(SearchRequest searchRequestData, String currentUser) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DoughnutChartViewSpecification.generateFilters((SearchRequest)searchRequestData, (String)currentUser);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.doughnutViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.doughnutViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

