/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.snmpRules.service;

import com.coraltele.db.telemetry.main.entity.SNMPRules;
import com.coraltele.db.telemetry.main.repository.SNMPRulesRepository;
import com.coraltele.db.telemetry.main.specification.SNMPRulesSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.snmpRules.model.SNMPRulesModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SNMPRulesService {
    private static final Logger logger = LogManager.getLogger(SNMPRulesService.class);
    @Autowired
    SNMPRulesRepository snmpRulesRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse createData(SNMPRulesModel data, Principal principal) {
        logger.debug("create new SNMPRules : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            SNMPRules snmpRules = new SNMPRules();
            Long epochTime = System.currentTimeMillis() / 1000L;
            snmpRules.setAlias(data.getAlias());
            snmpRules.setCreatedBy(principal.getName());
            snmpRules.setCreatedOn(epochTime);
            snmpRules.setFailureServiceCodeValue(data.getFailureServiceCodeValue());
            snmpRules.setFailureServiceCodeVariable(data.getFailureServiceCodeVariable());
            snmpRules.setRulePriority(data.getRulePriority());
            snmpRules.setServiceCode(data.getServiceCode());
            snmpRules.setSeverity(data.getSeverity());
            snmpRules.setSlot(data.getSlot());
            snmpRules.setSnmpVersion(data.getSnmpVersion());
            snmpRules.setStatusDetailFailure(data.getStatusDetailFailure());
            snmpRules.setStatusDetailSuccess(data.getStatusDetailSuccess());
            snmpRules.setSuccessServiceCodeValue(data.getSuccessServiceCodeValue());
            snmpRules.setSuccessServiceCodeVariable(data.getSuccessServiceCodeVariable());
            snmpRules.setSuccessValue(data.getSuccessValue());
            snmpRules.setSuccessVariable(data.getSuccessVariable());
            snmpRules.setTrapId(data.getTrapId());
            snmpRules.setTrapIdType(data.getTrapIdType());
            this.snmpRulesRepository.save((Object)snmpRules);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("SNMPRules Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create SNMPRules");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(SNMPRulesModel data) {
        logger.debug("Update SNMPRules {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional snmpRules = this.snmpRulesRepository.findById((Object)data.getId());
        if (!snmpRules.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("SNMPRules Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAlias() != null) {
            ((SNMPRules)snmpRules.get()).setAlias(data.getAlias());
        }
        if (data.getFailureServiceCodeValue() != null) {
            ((SNMPRules)snmpRules.get()).setFailureServiceCodeValue(data.getFailureServiceCodeValue());
        }
        if (data.getFailureServiceCodeVariable() != null) {
            ((SNMPRules)snmpRules.get()).setFailureServiceCodeVariable(data.getFailureServiceCodeVariable());
        }
        if (data.getRulePriority() != null) {
            ((SNMPRules)snmpRules.get()).setRulePriority(data.getRulePriority());
        }
        if (data.getServiceCode() != null) {
            ((SNMPRules)snmpRules.get()).setServiceCode(data.getServiceCode());
        }
        if (data.getSeverity() != null) {
            ((SNMPRules)snmpRules.get()).setSeverity(data.getSeverity());
        }
        if (data.getSlot() != null) {
            ((SNMPRules)snmpRules.get()).setSlot(data.getSlot());
        }
        if (data.getSnmpVersion() != null) {
            ((SNMPRules)snmpRules.get()).setSnmpVersion(data.getSnmpVersion());
        }
        if (data.getStatusDetailFailure() != null) {
            ((SNMPRules)snmpRules.get()).setStatusDetailFailure(data.getStatusDetailFailure());
        }
        if (data.getStatusDetailSuccess() != null) {
            ((SNMPRules)snmpRules.get()).setStatusDetailSuccess(data.getStatusDetailSuccess());
        }
        if (data.getSuccessServiceCodeValue() != null) {
            ((SNMPRules)snmpRules.get()).setSuccessServiceCodeValue(data.getSuccessServiceCodeValue());
        }
        if (data.getSuccessServiceCodeVariable() != null) {
            ((SNMPRules)snmpRules.get()).setSuccessServiceCodeVariable(data.getSuccessServiceCodeVariable());
        }
        if (data.getSuccessValue() != null) {
            ((SNMPRules)snmpRules.get()).setSuccessValue(data.getSuccessValue());
        }
        if (data.getSuccessVariable() != null) {
            ((SNMPRules)snmpRules.get()).setSuccessVariable(data.getSuccessVariable());
        }
        if (data.getTrapId() != null) {
            ((SNMPRules)snmpRules.get()).setTrapId(data.getTrapId());
        }
        if (data.getTrapIdType() != null) {
            ((SNMPRules)snmpRules.get()).setTrapIdType(data.getTrapIdType());
        }
        this.snmpRulesRepository.save(snmpRules.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("SNMPRules Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String ids : data.getStringId()) {
            Optional snmpRules = this.snmpRulesRepository.findById((Object)ids);
            if (snmpRules.isPresent()) {
                addValue.add(snmpRules.get());
                this.snmpRulesRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = SNMPRulesSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.snmpRulesRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.snmpRulesRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<SNMPRulesModel> entityToModelConversion(List<SNMPRules> snmpRule) {
        ArrayList<SNMPRulesModel> addValue = new ArrayList<SNMPRulesModel>();
        for (SNMPRules row : snmpRule) {
            SNMPRulesModel data = new SNMPRulesModel();
            data.setId(row.getId());
            if (row.getCreatedOn() != null) {
                data.setCreatedOn(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getCreatedOn()));
            }
            data.setAlias(row.getAlias());
            data.setCreatedBy(row.getCreatedBy());
            data.setFailureServiceCodeValue(row.getFailureServiceCodeValue());
            data.setFailureServiceCodeVariable(row.getFailureServiceCodeVariable());
            data.setRulePriority(row.getRulePriority());
            data.setServiceCode(row.getServiceCode());
            data.setSeverity(row.getSeverity());
            data.setSlot(row.getSlot());
            data.setSnmpVersion(row.getSnmpVersion());
            data.setStatusDetailFailure(row.getStatusDetailFailure());
            data.setStatusDetailSuccess(row.getStatusDetailSuccess());
            data.setSuccessServiceCodeValue(row.getSuccessServiceCodeValue());
            data.setSuccessServiceCodeVariable(row.getSuccessServiceCodeVariable());
            data.setSuccessValue(row.getSuccessValue());
            data.setSuccessVariable(row.getSuccessVariable());
            data.setTrapId(row.getTrapId());
            data.setTrapIdType(row.getTrapIdType());
            addValue.add(data);
        }
        return addValue;
    }
}

