/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.paCDR.service;

import com.coraltele.db.telemetry.main.entity.PaCdr;
import com.coraltele.db.telemetry.main.repository.PaCdrRepository;
import com.coraltele.db.telemetry.main.specification.PaCdrSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.paCDR.model.PACDRModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PaCdrService {
    private static final Logger logger = LogManager.getLogger(PaCdrService.class);
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    PaCdrRepository paCdrRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = PaCdrSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.paCdrRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.paCdrRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<PACDRModel> entityToModelConversion(List<PaCdr> paCdr) {
        ArrayList<PACDRModel> addValue = new ArrayList<PACDRModel>();
        for (PaCdr row : paCdr) {
            PACDRModel data = new PACDRModel();
            data.setUuid(row.getUuid());
            data.setCallStatus(row.isCallStatus());
            data.setPaNumber(row.getPaNumber());
            data.setParticipantNumber(row.getParticipantNumber());
            data.setParticipantType(row.getParticipantType());
            data.setRecordingFile(row.getRecordingFile());
            data.setTalkTime(row.getTalkTime());
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getStartTime()));
            }
            if (row.getAnswerTime() != null) {
                data.setAnswerTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerTime()));
            }
            if (row.getEndTime() != null) {
                data.setEndTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getEndTime()));
            }
            addValue.add(data);
        }
        return addValue;
    }

    public String getFile(String id) {
        Optional data = this.paCdrRepository.findById((Object)id);
        if (data.isPresent()) {
            return ((PaCdr)data.get()).getRecordingFile();
        }
        return null;
    }
}

