/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.billingCDR.controller;

import com.coraltele.db.telemetry.main.entity.BillingCDR;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.specification.ExtensionBillingInBoundSpecification;
import com.coraltele.db.telemetry.main.specification.ExtensionBillingOutBoundSpecification;
import com.coraltele.db.telemetry.main.specification.ExtensionBillingSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.billingCDR.service.ExtensionBillingReportService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/extensionBilling"})
@RestController
public class ExtensionBillingController {
    private static final Logger logger = LogManager.getLogger(ExtensionBillingController.class);
    @Autowired
    ExtensionBillingReportService billingCDRService;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    BillingCDRRepository billingCDRRepository;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> columnMappingsInbound = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> columnMappingsOutBound = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.billingCDRService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForCallerCall(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for Extension Billing");
            Specification filters = ExtensionBillingSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.billingCDRRepository.findAll(filters, sort) : this.billingCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (BillingCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValueForCallerCall(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Extension Billing", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Extension Billing file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValueForCallerCall(BillingCDR item, String columnName) {
        switch (columnName) {
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "coralCallDirection": {
                return this.checkNull((Object)item.getCoralCallDirection());
            }
            case "startEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getStartEpoch());
            }
            case "answerEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerEpoch());
            }
            case "endEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getEndEpoch());
            }
            case "duration": {
                return DateFormatUtility.findLocalTime((Long)item.getDuration());
            }
            case "talkDuration": {
                return DateFormatUtility.findLocalTime((Long)item.getTalkDuration());
            }
            case "callConnected": {
                if (item.getCallConnected() != null) {
                    if (item.getCallConnected().booleanValue()) {
                        return this.checkNull((Object)"Yes");
                    }
                    return this.checkNull((Object)"No");
                }
                return this.checkNull((Object)"No");
            }
            case "startDate": {
                return this.dateFormatUtility.epochToLocalDate(item.getStartEpoch());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
            case "pulseVal": {
                return this.checkNull((Object)item.getPulseVal());
            }
            case "pulseRate": {
                return this.checkNull((Object)item.getPulseRate());
            }
            case "costVal": {
                Long paise = item.getCostVal() != null ? item.getCostVal() : 0L;
                double rupees = (double)paise.longValue() / 100.0;
                return rupees;
            }
            case "callerName": {
                return this.checkNull((Object)item.getCallerName());
            }
            case "destinationName": {
                return this.checkNull((Object)item.getDestinationName());
            }
            case "callType": {
                return this.checkNull((Object)item.getCallType());
            }
            case "coralFeatureCode": {
                return this.checkNull((Object)item.getCoralFeatureCode());
            }
        }
        return null;
    }

    private Object getColumnValueForInBound(BillingCDR item, String columnName) {
        switch (columnName) {
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "coralCallDirection": {
                return this.checkNull((Object)item.getCoralCallDirection());
            }
            case "startEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getStartEpoch());
            }
            case "answerEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerEpoch());
            }
            case "endEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getEndEpoch());
            }
            case "duration": {
                return DateFormatUtility.findLocalTime((Long)item.getDuration());
            }
            case "talkDuration": {
                return DateFormatUtility.findLocalTime((Long)item.getTalkDuration());
            }
            case "callConnected": {
                if (item.getCallConnected() != null) {
                    if (item.getCallConnected().booleanValue()) {
                        return this.checkNull((Object)"Yes");
                    }
                    return this.checkNull((Object)"No");
                }
                return this.checkNull((Object)"No");
            }
            case "startDate": {
                return this.dateFormatUtility.epochToLocalDate(item.getStartEpoch());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
            case "pulseVal": {
                return this.checkNull((Object)item.getPulseVal());
            }
            case "pulseRate": {
                return this.checkNull((Object)item.getPulseRate());
            }
            case "costVal": {
                Long paise = item.getCostVal() != null ? item.getCostVal() : 0L;
                double rupees = (double)paise.longValue() / 100.0;
                return rupees;
            }
            case "callerName": {
                return this.checkNull((Object)item.getCallerName());
            }
            case "destinationName": {
                return this.checkNull((Object)item.getDestinationName());
            }
            case "coralGateway": {
                return this.checkNull((Object)item.getCoralInBoundGateway());
            }
            case "coralGatewayName": {
                return this.checkNull((Object)item.getCoralInBoundGatewayName());
            }
            case "callType": {
                return this.checkNull((Object)item.getCallType());
            }
        }
        return null;
    }

    private Object getColumnValueForOutBound(BillingCDR item, String columnName) {
        switch (columnName) {
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "coralCallDirection": {
                return this.checkNull((Object)item.getCoralCallDirection());
            }
            case "startEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getStartEpoch());
            }
            case "answerEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerEpoch());
            }
            case "endEpoch": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getEndEpoch());
            }
            case "duration": {
                return DateFormatUtility.findLocalTime((Long)item.getDuration());
            }
            case "talkDuration": {
                return DateFormatUtility.findLocalTime((Long)item.getTalkDuration());
            }
            case "callConnected": {
                if (item.getCallConnected() != null) {
                    if (item.getCallConnected().booleanValue()) {
                        return this.checkNull((Object)"Yes");
                    }
                    return this.checkNull((Object)"No");
                }
                return this.checkNull((Object)"No");
            }
            case "startDate": {
                return this.dateFormatUtility.epochToLocalDate(item.getStartEpoch());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
            case "pulseVal": {
                return this.checkNull((Object)item.getPulseVal());
            }
            case "pulseRate": {
                return this.checkNull((Object)item.getPulseRate());
            }
            case "callerName": {
                return this.checkNull((Object)item.getCallerName());
            }
            case "destinationName": {
                return this.checkNull((Object)item.getDestinationName());
            }
            case "coralGateway": {
                return this.checkNull((Object)item.getCoralGateway());
            }
            case "coralGatewayName": {
                return this.checkNull((Object)item.getCoralGatewayName());
            }
            case "callType": {
                return this.checkNull((Object)item.getCallType());
            }
            case "costVal": {
                Long paise = item.getCostVal() != null ? item.getCostVal() : 0L;
                double rupees = (double)paise.longValue() / 100.0;
                return rupees;
            }
        }
        return null;
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/listInBound"})
    public ResponseEntity<RequestResponse> getAllByInBound() {
        RequestResponse returnValue = this.billingCDRService.getAllByInBound();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listOutBound"})
    public ResponseEntity<RequestResponse> getAllByOutBound() {
        RequestResponse returnValue = this.billingCDRService.getAllByOutBound();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listFilterInbound"})
    public ResponseEntity<RequestResponse> getAllByInBoundFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.billingCDRService.getAllByInBoundFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listFilterOutBound"})
    public ResponseEntity<RequestResponse> getAllByOutBoundFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.billingCDRService.getAllByOutBoundFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSVInBound"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForInBound(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for Extension Billing");
            Specification filters = ExtensionBillingInBoundSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.billingCDRRepository.findAll(filters, sort) : this.billingCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappingsInbound.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (BillingCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValueForInBound(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Extension Billing", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Extension Billing file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/downloadCSVOutBound"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForOutBound(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for Extension Billing");
            Specification filters = ExtensionBillingOutBoundSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startEpoch" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.billingCDRRepository.findAll(filters, sort) : this.billingCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappingsOutBound.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (BillingCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValueForOutBound(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Extension Billing", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Extension Billing file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/generateAndDownloadInBoundPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadInBoundPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/generateAndDownloadOutBoundPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadOutBoundPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappingsInbound.put("callerIdNumber", "Caller No");
        columnMappingsInbound.put("destinationNumber", "Destination No");
        columnMappingsInbound.put("coralCallDirection", "Call Direction");
        columnMappingsInbound.put("startEpoch", "Start Time");
        columnMappingsInbound.put("answerEpoch", "Answer Time");
        columnMappingsInbound.put("endEpoch", "End Time");
        columnMappingsInbound.put("talkDuration", "TalkTime (HH:MM:SS)");
        columnMappingsInbound.put("callConnected", "Call Answered");
        columnMappingsInbound.put("startDate", "Date");
        columnMappingsInbound.put("mos", "MOS");
        columnMappingsInbound.put("pulseVal", "Pulse");
        columnMappingsInbound.put("pulseRate", "Pulse Rate");
        columnMappingsInbound.put("costVal", "Cost");
        columnMappingsInbound.put("callerName", "Caller Name");
        columnMappingsInbound.put("destinationName", "Destination Name");
        columnMappingsInbound.put("coralGateway", "Inbound  Gateway Code");
        columnMappingsInbound.put("coralGatewayName", "Inbound  Gateway Name");
        columnMappingsInbound.put("callType", "call Type");
        columnMappingsOutBound.put("callerIdNumber", "Caller No");
        columnMappingsOutBound.put("destinationNumber", "Destination No");
        columnMappingsOutBound.put("coralCallDirection", "Call Direction");
        columnMappingsOutBound.put("startEpoch", "Start Time");
        columnMappingsOutBound.put("answerEpoch", "Answer Time");
        columnMappingsOutBound.put("endEpoch", "End Time");
        columnMappingsOutBound.put("talkDuration", "TalkTime (HH:MM:SS)");
        columnMappingsOutBound.put("callConnected", "Call Answered");
        columnMappingsOutBound.put("startDate", "Date");
        columnMappingsOutBound.put("mos", "MOS");
        columnMappingsOutBound.put("pulseVal", "Pulse");
        columnMappingsOutBound.put("pulseRate", "Pulse Rate");
        columnMappingsOutBound.put("costVal", "Cost");
        columnMappingsOutBound.put("callerName", "Caller Name");
        columnMappingsOutBound.put("destinationName", "Destination Name");
        columnMappingsOutBound.put("coralGateway", "Outbound Gateway Code");
        columnMappingsOutBound.put("coralGatewayName", "Outbound Gateway Name");
        columnMappingsOutBound.put("callType", "call Type");
        columnMappings.put("callerIdNumber", "Caller No");
        columnMappings.put("destinationNumber", "Destination No");
        columnMappings.put("coralCallDirection", "Call Direction");
        columnMappings.put("startEpoch", "Start Time");
        columnMappings.put("answerEpoch", "Answer Time");
        columnMappings.put("endEpoch", "End Time");
        columnMappings.put("talkDuration", "TalkTime (HH:MM:SS)");
        columnMappings.put("callConnected", "Call Answered");
        columnMappings.put("startDate", "Date");
        columnMappings.put("mos", "MOS");
        columnMappings.put("pulseVal", "Pulse");
        columnMappings.put("pulseRate", "Pulse Rate");
        columnMappings.put("costVal", "Cost");
        columnMappings.put("callerName", "Caller Name");
        columnMappings.put("destinationName", "Destination Name");
        columnMappings.put("callType", "call Type");
        columnMappings.put("coralFeatureCode", "Feature Name");
    }
}

