/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.emailDetail.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.emailDetail.model.PredefinedMessagesModel;
import com.coraltele.service.pbx.emailDetail.service.PredefinedMessagesServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/predefinedMessage"})
@RestController
public class PredefinedMessagesController {
    @Autowired
    private PredefinedMessagesServices predefinedMessagesServices;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createPredefinedMessages(@RequestBody PredefinedMessagesModel data) {
        RequestResponse returnValue = this.predefinedMessagesServices.createPredefinedMessages(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updatePredefinedMessages(@RequestBody PredefinedMessagesModel data) {
        RequestResponse returnValue = this.predefinedMessagesServices.updatePredefinedMessages(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.predefinedMessagesServices.deletePredefinedMessages(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getListPredefinedMessages(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.predefinedMessagesServices.getFilteredList(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/{type}"})
    public ResponseEntity<RequestResponse> getAllPredefinedMessages(@PathVariable String type) {
        RequestResponse returnValue = this.predefinedMessagesServices.getAllPredefinedMessages(type);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

