/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.department.service;

import com.coraltele.db.telephony.billing.entity.Department;
import com.coraltele.db.telephony.billing.repository.DepartmentRepository;
import com.coraltele.db.telephony.billing.specification.DepartmentSpecification;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.department.model.DepartmentModel;
import com.coraltele.service.user.model.UserModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DepartmentService {
    private static final Logger logger = LogManager.getLogger(DepartmentService.class);
    @Autowired
    DepartmentRepository departmentRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;

    public RequestResponse createData(DepartmentModel data, Principal principal) {
        Optional duplicateDeptByContact;
        logger.debug("create new data for department : {} ==> {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional department = this.departmentRepository.findByDescriptionOrCode(data.getDescription(), data.getCode());
        if (department.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Select different department or Code");
            returnValue.setMessageDetail("Already exist");
            logger.error(returnValue.getMessageDetail(), (Object)returnValue.getMessage());
            return returnValue;
        }
        if (data.getDepartmentPriority() != null && this.departmentRepository.findByDepartmentPriority(data.getDepartmentPriority()).isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Select different priority");
            returnValue.setMessageDetail("Already exist");
            logger.error(returnValue.getMessageDetail(), (Object)returnValue.getMessage());
            return returnValue;
        }
        if (StringUtils.hasText((String)data.getContactNo()) && (duplicateDeptByContact = this.departmentRepository.findByEmergencyCommunicationNumber(data.getContactNo())).isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Duplicate Contact");
            returnValue.setMessageDetail("Contact number already exists in Department table");
            return returnValue;
        }
        try {
            Department row = new Department();
            row.setCreatedOn(LocalDateTime.now());
            row.setCreatedBy(principal.getName());
            row.setDescription(data.getDescription());
            row.setSerialNo(data.getSerialNo());
            row.setCode(data.getCode());
            row.setCompanyCode(data.getCompanyCode());
            row.setFloor(data.getFloor());
            row.setColor(data.getColor());
            row.setDepartmentPriority(data.getDepartmentPriority());
            data.setId(row.getId());
            row.setEmergencyContactNumber(data.getEmergencyContactNumber());
            this.departmentRepository.save((Object)row);
            data.setId(row.getId());
            this.updateDepartmentExtensionAssociation(data);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("record Registered");
            returnValue.setMessageDetail("Record created successfully");
            logger.info(" record saved : {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("unable to create department");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        RequestResponse returnValue = new RequestResponse();
        List list = (List)this.departmentRepository.findAll();
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Empty list present");
            logger.info(returnValue.getMessage());
        } else {
            ArrayList<DepartmentModel> addValue = new ArrayList<DepartmentModel>();
            for (Department department : list) {
                DepartmentModel row = new DepartmentModel();
                row.setCode(department.getCode());
                row.setCompanyCode(department.getCompanyCode());
                row.setDescription(department.getDescription());
                row.setSerialNo(department.getSerialNo());
                row.setFloor(department.getFloor());
                row.setCreatedBy(department.getCreatedBy());
                row.setCreatedOn(department.getCreatedOn());
                row.setColor(department.getColor());
                row.setDepartmentPriority(department.getDepartmentPriority());
                row.setEmergencyContactNumber(department.getEmergencyContactNumber());
                addValue.add(row);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData(addValue);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateData(DepartmentModel data) {
        logger.debug("Update DepartmentModel {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional department = this.departmentRepository.findById(data.getId());
            if (department.isPresent()) {
                Optional duplicate;
                if (data.getDescription() != null) {
                    ((Department)department.get()).setDescription(data.getDescription());
                }
                if (data.getSerialNo() != null) {
                    ((Department)department.get()).setSerialNo(data.getSerialNo());
                }
                if (data.getCode() != null) {
                    ((Department)department.get()).setCode(data.getCode());
                }
                if (data.getCompanyCode() != null) {
                    ((Department)department.get()).setCompanyCode(data.getCompanyCode());
                }
                if (data.getFloor() != null) {
                    ((Department)department.get()).setFloor(data.getFloor());
                }
                if (data.getColor() != null) {
                    ((Department)department.get()).setColor(data.getColor());
                }
                if (data.getDepartmentPriority() != null) {
                    ((Department)department.get()).setDepartmentPriority(data.getDepartmentPriority());
                }
                if (data.getEmergencyContactNumber() != null) {
                    ((Department)department.get()).setEmergencyContactNumber(data.getEmergencyContactNumber());
                }
                if (StringUtils.hasText((String)data.getContactNo()) && (duplicate = this.departmentRepository.findByEmergencyCommunicationNumber(data.getContactNo())).isPresent() && !((Department)duplicate.get()).getId().equals(data.getId())) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Already assigned to another department");
                    returnValue.setMessageDetail("Please enter different contact number");
                    return returnValue;
                }
                this.departmentRepository.save(department.get());
                this.updateDepartmentExtensionAssociation(data);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("Department Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Department not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update Department");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteModelDetail(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        for (Integer ids : data.getIntId()) {
            Optional department = this.departmentRepository.findById(ids);
            if (!department.isPresent()) continue;
            String emergencyNumber = ((Department)department.get()).getEmergencyCommunicationNumber();
            if (StringUtils.hasText((String)emergencyNumber)) {
                Optional extOpt = this.extensionsRepository.findByExtension(emergencyNumber);
                extOpt.ifPresent(ext -> {
                    this.extensionsRepository.delete(ext);
                    logger.info("Deleted extension {} linked to department code {}", (Object)emergencyNumber, (Object)((Department)department.get()).getCode());
                });
            }
            this.departmentRepository.deleteById((Object)ids);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DepartmentSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.departmentRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.departmentRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public String getColor(String deptName) {
        Optional department = this.departmentRepository.findByDescription(deptName);
        if (department.isPresent()) {
            return ((Department)department.get()).getColor();
        }
        return "";
    }

    public List<DepartmentModel> entityToModelConversion(List<Department> report) {
        ArrayList<DepartmentModel> addValue = new ArrayList<DepartmentModel>();
        for (Department row : report) {
            DepartmentModel data = new DepartmentModel();
            data.setId(row.getId());
            data.setCode(row.getCode());
            data.setColor(row.getColor());
            data.setCompanyCode(row.getCompanyCode());
            data.setContactNo(row.getEmergencyCommunicationNumber());
            data.setDepartmentPriority(row.getDepartmentPriority());
            data.setDescription(row.getDescription());
            data.setFloor(row.getFloor());
            data.setSerialNo(row.getSerialNo());
            data.setEmergencyContactNumber(row.getEmergencyContactNumber());
            addValue.add(data);
        }
        return addValue;
    }

    public void updateDepartmentExtensionAssociation(DepartmentModel data) {
        Optional depOptional = Optional.empty();
        if (data.getId() != null) {
            depOptional = this.departmentRepository.findById(data.getId());
            if (!depOptional.isPresent()) {
                throw new RuntimeException("Department not found for id: " + data.getId());
            }
            Department department = (Department)depOptional.get();
            if (StringUtils.hasText((String)data.getContactNo())) {
                Optional existingDeptWithSameNumber = this.departmentRepository.findByEmergencyCommunicationNumber(data.getContactNo());
                if (existingDeptWithSameNumber.isPresent() && !((Department)existingDeptWithSameNumber.get()).getId().equals(department.getId())) {
                    throw new RuntimeException("This emergency communication number is already assigned to another department.");
                }
                Optional extOptional = this.extensionsRepository.findByExtension(data.getContactNo());
                Extension extension = extOptional.orElseGet(Extension::new);
                extension.setExtension(data.getContactNo());
                extension.setDepartment(department.getCode());
                extension.setExtensionType("ec");
                this.extensionsRepository.save((Object)extension);
                department.setEmergencyCommunicationNumber(data.getContactNo());
                this.departmentRepository.save((Object)department);
            } else {
                String oldContactNo = department.getEmergencyCommunicationNumber();
                if (StringUtils.hasText((String)oldContactNo)) {
                    Optional extOptional = this.extensionsRepository.findByExtension(oldContactNo);
                    extOptional.ifPresent(arg_0 -> ((ExtensionsRepository)this.extensionsRepository).delete(arg_0));
                }
                department.setEmergencyCommunicationNumber("");
                this.departmentRepository.save((Object)department);
            }
        } else {
            Department department = new Department();
            department.setEmergencyCommunicationNumber(data.getContactNo());
            this.departmentRepository.save((Object)department);
            if (StringUtils.hasText((String)data.getContactNo())) {
                Optional extOptional = this.extensionsRepository.findByExtension(data.getContactNo());
                Extension extension = extOptional.orElseGet(Extension::new);
                extension.setExtension(data.getContactNo());
                extension.setDepartment(department.getCode());
                this.extensionsRepository.save((Object)extension);
                extension.setExtensionType("ec");
            }
        }
    }

    public void createOrUpdateUserExtension(User user, UserModel data) {
        try {
            String contactNo = data.getContactNo();
            String userType = data.getUserType();
            String designation = data.getDesignation();
            user.setUserType(userType);
            if ("normalUser".equalsIgnoreCase(userType)) {
                logger.info("Skipping extension creation/update for normalUser: {}", (Object)user.getUsername());
                user.setContactNo(contactNo != null ? contactNo.trim() : "");
                return;
            }
            if (!StringUtils.hasText((String)contactNo)) {
                Optional oldExt;
                if (StringUtils.hasText((String)user.getContactNo()) && (oldExt = this.extensionsRepository.findByExtension(user.getContactNo())).isPresent()) {
                    this.extensionsRepository.delete(oldExt.get());
                    logger.info("Deleted extension {} as contactNo is now blank", (Object)user.getContactNo());
                }
                user.setContactNo("");
                return;
            }
            contactNo = contactNo.trim();
            user.setContactNo(contactNo);
            String extensionType = "phone";
            Department department = null;
            if (StringUtils.hasText((String)data.getDepartment())) {
                Optional depOpt = this.departmentRepository.findByCode(data.getDepartment());
                if (depOpt.isPresent()) {
                    department = (Department)depOpt.get();
                    logger.info("Linked to department: {}", (Object)department.getCode());
                } else {
                    logger.info("Department {} not found \u2014 skipping linkage.", (Object)data.getDepartment());
                }
            }
            Optional extOpt = this.extensionsRepository.findByExtension(contactNo);
            Extension extension = extOpt.orElseGet(Extension::new);
            extension.setExtension(contactNo);
            extension.setExtensionType(extensionType);
            extension.setDepartment(department != null ? department.getCode() : null);
            extension.setDesignation(designation);
            this.extensionsRepository.save((Object)extension);
            logger.info("Extension {} updated/created successfully", (Object)contactNo);
        }
        catch (Exception e) {
            logger.error("Error in createOrUpdateUserExtension: ", (Throwable)e);
            throw new RuntimeException("Unable to process user-extension association");
        }
    }
}

