/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.conferenceMeeting.configureConferencer.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.conferenceMeeting.configureConferencer.model.ConferenceDateModel;
import com.coraltele.service.pbx.conferenceMeeting.configureConferencer.model.ConferenceUpdateModel;
import com.coraltele.service.pbx.conferenceMeeting.configureConferencer.service.ConferenceService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/conference"})
@RestController
public class ConferenceController {
    @Autowired
    ConferenceService conferenceService;

    @PostMapping(value={"/dateList"})
    public ResponseEntity<RequestResponse> updateById() {
        RequestResponse returnValue = this.conferenceService.getConferenceList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dateTimeList"})
    public ResponseEntity<RequestResponse> getRecordsByScheduleDate(@RequestBody ConferenceDateModel data) {
        RequestResponse returnValue = this.conferenceService.getByScheduleDate(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/reSchedule"})
    public ResponseEntity<RequestResponse> updateByConferenceId(@RequestBody ConferenceUpdateModel data, Authentication authentication) {
        RequestResponse returnValue = this.conferenceService.updateByConfigureConferenceId(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/cancel"})
    public ResponseEntity<RequestResponse> cancelMeeting(@RequestBody ConferenceUpdateModel data, Principal authentication) {
        RequestResponse returnValue = this.conferenceService.updateByCancel(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/week"})
    public ResponseEntity<RequestResponse> getWeekData(@RequestBody ConferenceDateModel data, Principal authentication) {
        RequestResponse returnValue = this.conferenceService.getWeekOfData(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/month"})
    public ResponseEntity<RequestResponse> getMonthData(@RequestBody ConferenceDateModel data, Principal authentication) {
        RequestResponse returnValue = this.conferenceService.getMonthOfData(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/day"})
    public ResponseEntity<RequestResponse> getSpecificDay(@RequestBody ConferenceDateModel data, Principal authentication) {
        RequestResponse returnValue = this.conferenceService.getRecordsForDay(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/upComingEvents"})
    public ResponseEntity<RequestResponse> getUpcomingMeeting(Principal authentication) {
        RequestResponse returnValue = this.conferenceService.getRecordsFromToday(authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/accessCode/listAll"})
    public ResponseEntity<RequestResponse> getLoggedUserConference(Principal authentication) {
        RequestResponse returnValue = this.conferenceService.getLoggedUserConference(authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

