/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ConfRecProcessModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ConferenceMeetingModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.MeetingAddressedModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.MeetingStatusUpdateModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.RdSOMeetingModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.RecBackupModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.service.ConferenceMeetingService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/conferenceRoom"})
@RestController
public class ConferenceMeetingController {
    private static final Logger logger = LogManager.getLogger(ConferenceMeetingController.class);
    @Autowired
    private ConferenceMeetingService conferenceMeetingService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllMeetingList(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.conferenceMeetingService.getListOfMeetings(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createMeeting(Authentication authentication, @RequestBody ConferenceMeetingModel data) {
        RequestResponse returnValue = this.conferenceMeetingService.createNewConferenceMeeting(data, (Principal)authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateMeeting(@RequestBody ConferenceMeetingModel data, Principal authentication) {
        RequestResponse returnValue = this.conferenceMeetingService.updateMeetingRoomDetails(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteMeeting(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.conferenceMeetingService.deleteConferenceParticipantById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<RequestResponse> upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="recordId", required=false) Integer recordId, @RequestParam(value="type", required=true) String type) {
        RequestResponse returnValue = this.conferenceMeetingService.uploadWavFile(file, recordId, type);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllMeetings(Principal principal) {
        RequestResponse returnValue = this.conferenceMeetingService.getAll(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/pastMeeting"})
    public ResponseEntity<RequestResponse> getPastMeeting(Principal principal) {
        RequestResponse returnValue = this.conferenceMeetingService.getPastMeetings(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/recordingList/{accessCode}"})
    public ResponseEntity<RequestResponse> getRecordingList(@PathVariable(value="accessCode") String accessCode) {
        RequestResponse returnValue = this.conferenceMeetingService.getRecordingList(accessCode);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/recording"})
    public ResponseEntity<RequestResponse> recordingProcess(@RequestBody ConfRecProcessModel data) {
        RequestResponse returnValue = this.conferenceMeetingService.recordingProcess(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/backup"})
    public ResponseEntity<RequestResponse> makeBackup(@RequestBody RecBackupModel data) {
        RequestResponse returnValue = this.conferenceMeetingService.createBackupFileAsync(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/restore"})
    public ResponseEntity<RequestResponse> restoreBackupFile(@RequestBody RecBackupModel data) {
        RequestResponse returnValue = this.conferenceMeetingService.restoreBackup(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/backup/list"})
    public ResponseEntity<RequestResponse> getBackupHistory(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.conferenceMeetingService.getBackupList(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/active/list"})
    public ResponseEntity<RequestResponse> getActiveMeeting() {
        RequestResponse returnValue = this.conferenceMeetingService.getActiveConference();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listOfMeetings"})
    public ResponseEntity<RequestResponse> getMeetingList() {
        RequestResponse returnValue = this.conferenceMeetingService.getAllMeetingDetail();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/createTo"})
    public ResponseEntity<RequestResponse> createMeetingRDSO(Authentication authentication, @RequestBody RdSOMeetingModel data) {
        RequestResponse returnValue = this.conferenceMeetingService.createToMeeting(data, (Principal)authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/zone/{zone}"})
    public ResponseEntity<RequestResponse> getMeetingListByZone(@PathVariable(value="zone") String zone) {
        RequestResponse returnValue = this.conferenceMeetingService.getMeetingListRDso(zone);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/status"})
    public ResponseEntity<RequestResponse> udateMeetingStatus(@RequestBody MeetingStatusUpdateModel data, Principal principal) {
        RequestResponse returnValue = this.conferenceMeetingService.updateMeetingStatus(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/runningMeeting"})
    public ResponseEntity<RequestResponse> getMeetingByStatus() {
        RequestResponse returnValue = this.conferenceMeetingService.getMeetingListByStatus();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/meetingStatus"})
    public ResponseEntity<RequestResponse> getAllMeetingStatus(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.conferenceMeetingService.getFilteredList(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/meetingAddressed"})
    public ResponseEntity<RequestResponse> getAllMeetingStatus(@RequestBody MeetingAddressedModel data, Principal principal) {
        RequestResponse returnValue = this.conferenceMeetingService.updateStatusRemarks(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/joinDispatcher/{accessCode}"})
    public ResponseEntity<RequestResponse> joinDispatcher(@PathVariable(value="accessCode") String accessCode, Principal principal) {
        RequestResponse returnValue = this.conferenceMeetingService.joinMeetingDispatcher(accessCode, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/recordingFilename"})
    public ResponseEntity<RequestResponse> getRecordingList(Principal principal, @RequestParam(value="accessCode", required=false) String accessCode) {
        RequestResponse returnValue = this.conferenceMeetingService.getAllRecordings(principal, accessCode);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

